/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.state;

import java.util.Arrays;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEPublicationProfile;
import org.gcube.common.core.state.GCUBEStatefulResource;
import org.gcube.common.core.state.GCUBETopicList;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.state.GCUBEWSResourcePropertyProxy;
import org.gcube.common.core.state.GCUBEWSResourcePropertySet;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceLifetime;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.impl.ResourcePropertyTopic;
import org.globus.wsrf.utils.AddressingUtils;

public abstract class GCUBEWSResource
extends GCUBEStatefulResource<GCUBEWSResourceKey>
implements PersistenceCallback,
ResourceLifetime,
ResourceProperties,
TopicListAccessor {
    private GCUBEWSResourcePropertySet propSet;
    private GCUBETopicList topicList;
    private GCUBEStatefulPortTypeContext portTypeContext;

    protected void initialiseContainers() throws Exception {
        ResourceProperty prop;
        try {
            this.propSet = new GCUBEWSResourcePropertySet(this);
            this.topicList = new GCUBETopicList(this);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
        for (String name : this.getPropertyNames()) {
            prop = this.getProperty(name);
            this.getResourcePropertySet().add(prop);
        }
        for (String name : this.getTopicNames()) {
            prop = this.getProperty(name);
            ResourcePropertyTopic topic = new ResourcePropertyTopic(prop);
            topic.setSendOldValue(false);
            this.getTopicList().addTopic((Topic)topic);
            this.getResourcePropertySet().add((ResourceProperty)topic);
        }
    }

    @Override
    protected void initialise(GCUBEWSResourceKey id, Object ... params) throws Exception {
        this.setID(id != null ? id : this.getPorttypeContext().makeKey(uuidGen.nextUUID()));
        this.logger.trace("initialising " + this.getClass().getSimpleName() + "(" + this.getID() + ")");
        this.setTerminationTime(null);
        this.initialise(params);
        Integer lifetime = this.getPorttypeContext().getResourceLifeTime();
        if (lifetime != null) {
            Calendar terminationTime = this.getCurrentTime();
            terminationTime.add(13, lifetime);
            this.setTerminationTime(terminationTime);
        }
    }

    protected abstract void initialise(Object ... var1) throws Exception;

    public GCUBEWSResourcePropertySet getResourcePropertySet() {
        return this.propSet;
    }

    public GCUBETopicList getTopicList() {
        return this.topicList;
    }

    public EndpointReferenceType getEPR() throws Exception {
        return AddressingUtils.createEndpointReference((String)(GHNContext.getContext().getBaseURL() + this.getPorttypeContext().getJNDIName()), (ResourceKey)((ResourceKey)this.getID()));
    }

    public Calendar getCurrentTime() {
        return this.propSet.getCurrentTime();
    }

    public Calendar getTerminationTime() {
        return this.propSet.getTerminationTime();
    }

    public void setTerminationTime(Calendar calendar) {
        if (calendar != null) {
            this.logger.info(this.getClass().getSimpleName() + "(" + this.getID() + ") set to expire at " + calendar.getTime().toString() + " seconds");
        }
        this.propSet.setTerminationTime(calendar);
    }

    public void publish(GCUBEScope ... scopes) throws ResourceException {
        GCUBEPublicationProfile profile;
        if (scopes.length == 0 || GHNContext.getContext().getMode() == GHNContext.Mode.STANDALONE && GHNContext.getContext().getMode() != GHNContext.Mode.ROOT) {
            return;
        }
        ISNotifier notifier = null;
        if (this.getTopicList().asList().size() > 0) {
            for (GCUBEScope scope : scopes) {
                if (scope == null) continue;
                try {
                    (notifier == null ? GHNContext.getImplementation(ISNotifier.class) : notifier).registerISNotification(this.getEPR(), this.getTopicList().asList(), this.getServiceContext(), scope);
                }
                catch (Exception e) {
                    this.logger.warn("could not publish topics for " + this.getClass().getSimpleName() + "(" + this.getID() + ") in " + scope, e);
                }
            }
        }
        if ((profile = this.getPorttypeContext().getPublicationProfile()) == null) {
            return;
        }
        this.logger.info("publishing " + this.getClass().getSimpleName() + "(" + this.getID() + ") in " + Arrays.asList(scopes));
        ISPublisher publisher = null;
        for (GCUBEScope scope : scopes) {
            if (scope == null) continue;
            try {
                (publisher == null ? this.getPublisher() : publisher).registerWSResource(this, scope);
            }
            catch (Exception e) {
                this.logger.warn("could not publish " + this.getClass().getSimpleName() + "(" + this.getID() + ") in " + scope, e);
            }
        }
    }

    public void unpublish(GCUBEScope ... scopes) throws ResourceException {
        GCUBEPublicationProfile profile;
        if (scopes.length == 0 || GHNContext.getContext().getMode() == GHNContext.Mode.STANDALONE && GHNContext.getContext().getMode() != GHNContext.Mode.ROOT) {
            return;
        }
        ISNotifier notifier = null;
        if (this.getTopicList().asList().size() > 0) {
            for (GCUBEScope scope : scopes) {
                if (scope == null) continue;
                try {
                    (notifier == null ? GHNContext.getImplementation(ISNotifier.class) : notifier).unregisterISNotification(this.getEPR(), this.getTopicList().asList(), this.getServiceContext(), scope);
                }
                catch (Exception e) {
                    this.logger.warn("could not unpublish topics for " + this.getClass().getSimpleName() + "(" + this.getID() + ") in " + scope, e);
                }
            }
        }
        if ((profile = this.getPorttypeContext().getPublicationProfile()) == null) {
            return;
        }
        this.logger.info("unpublishing " + this.getClass().getSimpleName() + "(" + this.getID() + ") from " + Arrays.asList(scopes));
        ISPublisher publisher = null;
        for (GCUBEScope scope : scopes) {
            if (scope == null) continue;
            try {
                (publisher == null ? this.getPublisher() : publisher).removeWSResource(this, scope);
            }
            catch (Exception e) {
                this.logger.warn(this.getClass().getSimpleName() + "(" + this.getID() + ") could not be unpublished from " + scope);
            }
        }
    }

    public GCUBEStatefulPortTypeContext getPorttypeContext() {
        return this.portTypeContext;
    }

    public void setPortTypeContext(GCUBEStatefulPortTypeContext context) {
        if (this.portTypeContext != null) {
            throw new RuntimeException("resource port-type already configured");
        }
        this.portTypeContext = context;
        this.logger.setContext(context.getServiceContext());
    }

    @Override
    public GCUBEServiceContext getServiceContext() {
        return this.getPorttypeContext().getServiceContext();
    }

    protected String[] getPropertyNames() {
        return new String[0];
    }

    protected String[] getTopicNames() {
        return new String[0];
    }

    protected ResourceProperty getProperty(String name) throws Exception {
        return GCUBEWSResourcePropertyProxy.createSimpleResourceProperty(new QName(this.getPorttypeContext().getNamespace(), name), this.getResourcePropertySet());
    }

    public void load(ResourceKey key) throws ResourceException, NoSuchResourceException, InvalidResourceKeyException {
    }

    public synchronized boolean inScope(GCUBEScope ... scopes) {
        if (scopes.length == 0) {
            throw new IllegalArgumentException();
        }
        block0: for (GCUBEScope scope : scopes) {
            if (scope == null) {
                return false;
            }
            for (String resScopeString : this.getResourcePropertySet().getScope()) {
                GCUBEScope resScope = GCUBEScope.getScope(resScopeString);
                if (!(resScope.isInfrastructure() ? scope.equals(resScope) : scope.isEnclosedIn(resScope))) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    protected ISPublisher getPublisher() throws Exception {
        return GHNContext.getImplementation(ISPublisher.class);
    }
}

