/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scope.impl;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.gcube.common.scope.api.ServiceMap;
import org.gcube.common.scope.impl.DefaultServiceMap;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceMapScanner {
    private static Logger log = LoggerFactory.getLogger(ServiceMapScanner.class);
    static final String mapConfigPattern = ".*\\.servicemap";

    ServiceMapScanner() {
    }

    static Map<String, ServiceMap> maps() {
        HashMap<String, ServiceMap> maps = new HashMap<String, ServiceMap>();
        try {
            Set<String> resources = ServiceMapScanner.getMapNames();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DefaultServiceMap.class});
            Unmarshaller um = context.createUnmarshaller();
            for (String resource : resources) {
                URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
                log.info("loading {} ", (Object)url);
                DefaultServiceMap map = (DefaultServiceMap)um.unmarshal(url);
                ServiceMap current = (ServiceMap)maps.get(map.scope());
                if (current != null && current.version() != null) {
                    if (current.version().compareToIgnoreCase(map.version()) == 1) {
                        log.warn("discarding {} because older (v.{}) than one previously loaded (v.{}) for {} ", new Object[]{url, map.version(), current.version(), map.scope()});
                        continue;
                    }
                    log.info("overwriting older map (v.{}) with newer map (v.{}) for {} ", new Object[]{current.version(), map.version(), map.scope()});
                }
                maps.put(map.scope(), map);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("could not load service maps", e);
        }
        return maps;
    }

    private static Set<String> getMapNames() {
        ConfigurationBuilder builder = new ConfigurationBuilder().setUrls((Collection)ClasspathHelper.forManifest(ServiceMapScanner.jarURLs())).setScanners(new Scanner[]{new ResourcesScanner()});
        Reflections reflections = new Reflections((Configuration)builder);
        return reflections.getResources(Pattern.compile(mapConfigPattern));
    }

    private static Set<URL> jarURLs() {
        HashSet<URL> result = new HashSet<URL>();
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null && classLoader.getParent() != null; classLoader = classLoader.getParent()) {
            URL[] urls;
            if (!(classLoader instanceof URLClassLoader) || (urls = ((URLClassLoader)classLoader).getURLs()) == null) continue;
            result.addAll(new HashSet<URL>(Arrays.asList(urls)));
        }
        return result;
    }
}

