/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.contexts.ServiceContext;
import org.gcube.common.vremanagement.deployer.impl.contexts.StatefulPortTypeContext;
import org.gcube.common.vremanagement.deployer.impl.operators.DeployerOperator;
import org.gcube.common.vremanagement.deployer.impl.operators.PatchOperator;
import org.gcube.common.vremanagement.deployer.impl.operators.UndeployerOperator;
import org.gcube.common.vremanagement.deployer.impl.operators.UpdateOperator;
import org.gcube.common.vremanagement.deployer.impl.state.DeployerResource;
import org.gcube.common.vremanagement.deployer.stubs.deployer.DeployParameters;
import org.gcube.common.vremanagement.deployer.stubs.deployer.PatchParameters;
import org.gcube.common.vremanagement.deployer.stubs.deployer.UndeployParameters;
import org.gcube.common.vremanagement.deployer.stubs.deployer.UpdateParameters;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;

public class Deployer
extends GCUBEPortType {
    public static final String SINGLETON_RESOURCE_KEY = "DeployerState";
    protected final GCUBELog logger = new GCUBELog(Deployer.class);

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public void deploy(DeployParameters params) throws GCUBEFault {
        if (params.get_package() == null || params.get_package().length == 0) {
            throw ServiceContext.getContext().getDefaultException("deploy operation invoked with an empty list of packages", new Exception()).toFault(new String[0]);
        }
        String[] scopes = params.getTargetScope();
        if (scopes == null || scopes.length == 0) {
            throw ServiceContext.getContext().getDefaultException("deploy operation invoked with an empty list of scopes", new Exception()).toFault(new String[0]);
        }
        try {
            for (String string : scopes) {
                GCUBEScope scopeobj = GCUBEScope.getScope((String)string);
                scopeobj.getServiceMap();
                this.logger.trace((Object)("Target scope " + string + " accepted"));
            }
        }
        catch (GCUBEScope.MalformedScopeExpressionException mse) {
            throw ServiceContext.getContext().getDefaultException("malformed target scope", mse).toFault(new String[0]);
        }
        catch (GCUBEScopeNotSupportedException snse) {
            throw ServiceContext.getContext().getDefaultException("invalid target scope, the node is not included in the given scope, therefore it is not possible to deploy any package there", snse).toFault(new String[0]);
        }
        this.logger.info((Object)("Starting the deployment for the following N." + params.get_package().length + " packages:"));
        for (String string : params.get_package()) {
            this.logger.info((Object)("PackageInfo [class=" + string.getServiceClass() + ", service name=" + string.getServiceName() + ", service version=" + string.getServiceVersion() + ", package name=" + string.getName() + ", package version=" + string.getVersion() + "]"));
        }
        DeployerScheduler scheduler = new DeployerScheduler(5L, GCUBEScheduledHandler.Mode.LAZY);
        try {
            DeployerOperator operator = new DeployerOperator(params, ServiceContext.getContext().getScope());
            operator.setHandled((Object)this.getResource());
            scheduler.setScheduled(operator);
            scheduler.run();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to schedule the deployment operation", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("unable to schedule the deployment operation", e).toFault(new String[0]);
        }
    }

    public void undeploy(UndeployParameters params) throws GCUBEFault {
        if (params.get_package() == null || params.get_package().length == 0) {
            throw ServiceContext.getContext().getDefaultException("undeploy operation invoked with an empty list of packages", new Exception()).toFault(new String[0]);
        }
        String[] scopes = params.getTargetScope();
        if (scopes != null && scopes.length > 0) {
            try {
                for (String string : scopes) {
                    GCUBEScope scopeobj = GCUBEScope.getScope((String)string);
                    scopeobj.getServiceMap();
                    this.logger.trace((Object)("Target scope " + string + " accepted"));
                }
            }
            catch (GCUBEScope.MalformedScopeExpressionException mse) {
                throw ServiceContext.getContext().getDefaultException("malformed target scope", mse).toFault(new String[0]);
            }
            catch (GCUBEScopeNotSupportedException snse) {
                throw ServiceContext.getContext().getDefaultException("invalid target scope, the node is not included in the given scope, therefore it is not possible to undeploy any package there", snse).toFault(new String[0]);
            }
        } else {
            this.logger.debug((Object)"Empty list of scopes detected, the packages will be removed from the gHN without taking into account their scopes");
            params.setTargetScope(new String[0]);
        }
        this.logger.info((Object)("Starting the undeployment for the following N." + params.get_package().length + " packages:"));
        for (String string : params.get_package()) {
            this.logger.info((Object)("PackageInfo [class=" + string.getServiceClass() + ", service name=" + string.getServiceName() + ", service version=" + string.getServiceVersion() + ", package name=" + string.getName() + ", package version=" + string.getVersion() + "]"));
        }
        try {
            UndeployerOperator operator = new UndeployerOperator(params);
            operator.setHandled((Object)this.getResource());
            DeployerScheduler scheduler = new DeployerScheduler(5L, GCUBEScheduledHandler.Mode.LAZY);
            scheduler.setScheduled(operator);
            scheduler.run();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to schedule the undeployment operation", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to schedule the undeployment operation", e).toFault(new String[0]);
        }
    }

    public void update(UpdateParameters params) throws GCUBEFault {
        if (params.get_package() == null || params.get_package().length == 0) {
            throw ServiceContext.getContext().getDefaultException("deploy operation invoked with an empty list of packages", new Exception()).toFault(new String[0]);
        }
        this.logger.info((Object)("starting the update operation for N." + params.get_package().length + " packages..."));
        try {
            DeployerScheduler scheduler = new DeployerScheduler(5L, GCUBEScheduledHandler.Mode.LAZY);
            scheduler.setScheduled(new UpdateOperator(this.getResource(), params, ServiceContext.getContext().getScope()));
            scheduler.run();
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException("unable to schedule the update operation", e).toFault(new String[0]);
        }
        this.logger.trace((Object)"Returning and starting to work");
    }

    public void patch(PatchParameters params) throws GCUBEFault {
        this.logger.info((Object)("Patch operation invoked for " + params.getPatchURI().toString()));
        try {
            if (params.get_package() == null) {
                throw ServiceContext.getContext().getDefaultException("patch operation invoked with an empty list of packages", new Exception()).toFault(new String[0]);
            }
            if (params.getPatchURI() == null || params.getPatchURI().toString().compareToIgnoreCase("") == 0) {
                throw ServiceContext.getContext().getDefaultException("patch operation invoked with an empty patchURI", new Exception()).toFault(new String[0]);
            }
            this.logger.trace((Object)"Starting the patcher...");
            DeployerScheduler scheduler = new DeployerScheduler(5L, GCUBEScheduledHandler.Mode.LAZY);
            scheduler.setScheduled(new PatchOperator(params.get_package(), params.getPatchURI(), params.getEndpointReference(), params.getCallbackID(), params.isRestart(), ServiceContext.getContext().getScope()));
            try {
                scheduler.run();
            }
            catch (Exception e) {
                throw ServiceContext.getContext().getDefaultException("unable to schedule the update operation", e).toFault(new String[0]);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Deployer is unable to start the patch operator", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Deployer is unable to start the patch operator", e).toFault(new String[0]);
        }
    }

    private DeployerResource getResource() throws NoSuchResourceException, ResourceException {
        return (DeployerResource)StatefulPortTypeContext.getContext().getWSHome().find((ResourceKey)StatefulPortTypeContext.getContext().makeKey(SINGLETON_RESOURCE_KEY));
    }

    protected class DeployerScheduler
    extends GCUBEScheduledHandler {
        public DeployerScheduler(long interval, GCUBEScheduledHandler.Mode mode) {
            super(interval, mode, new GCUBEHandler[0]);
        }

        protected boolean repeat(Exception exception, int exceptionCount) {
            if (exception == null) {
                this.logger.info((Object)"deployment operation completed");
            } else {
                this.logger.error((Object)"Failed to complete the local operations on the packages", (Throwable)exception);
            }
            return false;
        }
    }
}

