/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.TypeHandlerValidator;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;

public class CLI2Converter {
    private CLI2Converter() {
    }

    public static Option option(org.apache.commons.cli.Option option1) {
        String longName;
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        obuilder.withRequired(option1.isRequired());
        String shortName = option1.getOpt();
        if (shortName != null && !" ".equals(shortName)) {
            obuilder.withShortName(shortName);
        }
        if ((longName = option1.getLongOpt()) != null) {
            obuilder.withLongName(longName);
        }
        obuilder.withId(option1.getId());
        String description = option1.getDescription();
        if (description != null) {
            obuilder.withDescription(description);
        }
        if (option1.hasArg()) {
            ArgumentBuilder abuilder = new ArgumentBuilder();
            String argName = option1.getArgName();
            abuilder.withName(argName);
            abuilder.withMaximum(option1.getArgs());
            if (option1.hasValueSeparator()) {
                abuilder.withSubsequentSeparator(option1.getValueSeparator());
            }
            if (option1.hasOptionalArg()) {
                abuilder.withMinimum(0);
            } else {
                abuilder.withMinimum(option1.getArgs());
            }
            Object type = option1.getType();
            if (type != null) {
                abuilder.withValidator(new TypeHandlerValidator(type));
            }
            obuilder.withArgument(abuilder.create());
        }
        return obuilder.create();
    }

    public static Group group(OptionGroup optionGroup1) {
        GroupBuilder gbuilder = new GroupBuilder();
        Iterator i = optionGroup1.getOptions().iterator();
        while (i.hasNext()) {
            org.apache.commons.cli.Option option1 = (org.apache.commons.cli.Option)i.next();
            Option option2 = CLI2Converter.option(option1);
            gbuilder.withOption(option2);
        }
        gbuilder.withMaximum(1);
        if (optionGroup1.isRequired()) {
            gbuilder.withMinimum(1);
        }
        return gbuilder.create();
    }

    public static Group group(Options options1) {
        GroupBuilder gbuilder = new GroupBuilder();
        HashSet<OptionGroup> optionGroups = new HashSet<OptionGroup>();
        Iterator i = options1.getOptionGroups().iterator();
        while (i.hasNext()) {
            OptionGroup optionGroup1 = (OptionGroup)i.next();
            Group group = CLI2Converter.group(optionGroup1);
            gbuilder.withOption(group);
            optionGroups.add(optionGroup1);
        }
        i = options1.getOptions().iterator();
        while (i.hasNext()) {
            org.apache.commons.cli.Option option1 = (org.apache.commons.cli.Option)i.next();
            if (CLI2Converter.optionInAGroup(option1, optionGroups)) continue;
            Option option2 = CLI2Converter.option(option1);
            gbuilder.withOption(option2);
        }
        return gbuilder.create();
    }

    private static boolean optionInAGroup(org.apache.commons.cli.Option option1, Set optionGroups) {
        Iterator i = optionGroups.iterator();
        while (i.hasNext()) {
            OptionGroup group = (OptionGroup)i.next();
            if (!group.getOptions().contains(option1)) continue;
            return true;
        }
        return false;
    }
}

