/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.proxy.tcp;

import gr.uoa.di.madgik.commons.channel.events.ChannelState;
import gr.uoa.di.madgik.commons.channel.events.ChannelStateEvent;
import gr.uoa.di.madgik.commons.channel.events.EventFactory;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutletProtocol
extends Thread
implements Observer {
    private static Logger logger = Logger.getLogger(OutletProtocol.class.getName());
    private Object synchThreadStart = null;
    private Socket clientSock = null;
    private String NozzleID = null;
    private String ChannelID = null;
    private ChannelState State = null;
    private final Object synchEventsToSend = new Object();
    private List<ChannelStateEvent> EventsToSend = null;
    private Boolean hasConnected = false;
    private Boolean stillConnected = false;
    private static final long WaitPeriodinMilliseconds = 100L;
    private Boolean InDispose = false;
    private final Object synchInDispose = new Object();

    public OutletProtocol(Object synchThreadStart, Socket clientSock, String NozzleID, String ChannelID, ChannelState State2) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created Outlet protocol");
        }
        this.synchThreadStart = synchThreadStart;
        this.clientSock = clientSock;
        this.NozzleID = NozzleID;
        this.ChannelID = ChannelID;
        this.State = State2;
        this.setName(OutletProtocol.class.getName());
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Dispose() {
        Object object = this.synchInDispose;
        synchronized (object) {
            this.InDispose = true;
        }
        try {
            for (ChannelStateEvent ev : this.State.GetChannelEvents()) {
                ev.deleteObserver(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.EventsToSend.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block20: {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Outlet protocol running");
            }
            try {
                this.hasConnected = true;
                this.stillConnected = true;
                this.EventsToSend = new ArrayList<ChannelStateEvent>();
                for (ChannelStateEvent ev : this.State.GetChannelEvents()) {
                    ev.addObserver(this);
                }
                Object i$ = this.synchThreadStart;
                synchronized (i$) {
                    this.synchThreadStart.notify();
                }
                DataInputStream din = new DataInputStream(this.clientSock.getInputStream());
                DataOutputStream dout = new DataOutputStream(this.clientSock.getOutputStream());
                dout.writeUTF(ITCPConnectionManagerEntry.NamedEntry.Channel.toString());
                dout.writeUTF(this.NozzleID);
                dout.writeUTF(this.ChannelID);
                while (true) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Iterating");
                    }
                    Object object = this.synchInDispose;
                    synchronized (object) {
                        if (this.InDispose.booleanValue()) {
                            break;
                        }
                    }
                    this.EmitOutgoingEvents(dout);
                    this.ReceiveIncomingEvents(din);
                    object = this.synchEventsToSend;
                    synchronized (object) {
                        if (this.EventsToSend.size() == 0) {
                            try {
                                this.synchEventsToSend.wait(100L);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Break Iteration");
                }
            }
            catch (Exception ex) {
                this.stillConnected = false;
                if (this.InDispose.booleanValue() || !logger.isLoggable(Level.FINE)) break block20;
                logger.log(Level.FINE, "Outlet protocol thread could not complete normally", ex);
            }
        }
    }

    public Boolean HasConnected() {
        return this.hasConnected;
    }

    public Boolean StillConnected() {
        return this.stillConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void EmitOutgoingEvents(DataOutputStream dout) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Emiting Outgoing events");
        }
        ArrayList<ChannelStateEvent> TmpEvents = new ArrayList<ChannelStateEvent>();
        Object object = this.synchEventsToSend;
        synchronized (object) {
            for (ChannelStateEvent ev : this.EventsToSend) {
                if (!ev.GetEmitingNozzleID().equals(this.NozzleID)) continue;
                TmpEvents.add(ev);
            }
            this.EventsToSend.clear();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Number of Outgoing events is " + TmpEvents.size());
        }
        dout.writeInt(TmpEvents.size());
        dout.flush();
        for (ChannelStateEvent ev : TmpEvents) {
            byte[] evbuf = null;
            try {
                evbuf = ev.Encode();
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Could not serialize event " + ev + ". Disgarding", ex);
                continue;
            }
            dout.writeUTF(ev.GetEventName().toString());
            dout.writeInt(evbuf.length);
            dout.write(evbuf);
        }
        dout.flush();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Finished Emiting Outgoing events");
        }
    }

    private void ReceiveIncomingEvents(DataInputStream din) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Receiving Incoming events");
        }
        int incoming = din.readInt();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Number of Incoming events is " + incoming);
        }
        for (int i = 0; i < incoming; ++i) {
            ChannelStateEvent evv;
            ChannelState.EventName evtype = ChannelState.EventName.valueOf(din.readUTF());
            int size = din.readInt();
            byte[] evbuf = new byte[size];
            din.readFully(evbuf);
            ChannelStateEvent ev = null;
            try {
                ev = EventFactory.GetEvent(evtype, evbuf);
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Problem deserializing incoming event. Disgarding", ex);
                continue;
            }
            if (ev.GetEmitingNozzleID().equals(this.NozzleID) || (evv = this.State.GetEvent(ev.GetEventName())) == null) continue;
            evv.NotifyChange(ev);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Finished receiving Incoming events");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Caught event has argument other than the one registered for. Disgarding");
            }
            return;
        }
        if (arg instanceof ChannelStateEvent) {
            Object object = this.synchEventsToSend;
            synchronized (object) {
                this.EventsToSend.add((ChannelStateEvent)arg);
            }
        }
    }
}

