/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import cryptix.CryptixProperties;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import netscape.security.PrivilegeManager;

final class NativeLink
implements LinkStatus {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("NativeLink");
    private static final PrintWriter err = Debug.getOutput();
    private static final int NOT_LOADED = 0;
    private static final int FAILED = 1;
    private static final int OK = 2;
    private static boolean native_allowed;
    private int required_major;
    private int required_minor;
    private int actual_major;
    private int actual_minor;
    private String library_name;
    private boolean want_native;
    private int status;
    private boolean lib_loaded;
    private String link_error;

    private static void debug(String string) {
        err.println("NativeLink: " + string);
    }

    public int getRequiredMajorVersion() {
        return this.required_major;
    }

    public int getRequiredMinorVersion() {
        return this.required_minor;
    }

    public String getLibraryName() {
        return this.library_name;
    }

    public int getMajorVersion() {
        return this.actual_major;
    }

    public int getMinorVersion() {
        return this.actual_minor;
    }

    public boolean isLibraryLoaded() {
        return this.lib_loaded;
    }

    public boolean isLibraryCorrect() {
        return this.status == 2;
    }

    public String getLinkErrorString() {
        return this.link_error;
    }

    private static boolean isNativeWanted(String string) {
        if (!native_allowed) {
            return false;
        }
        String string2 = CryptixProperties.getProperty("Native.Enable." + string);
        if (string2 == null) {
            string2 = CryptixProperties.getProperty("Native.Enable.*");
        }
        return string2 != null && string2.equalsIgnoreCase("true");
    }

    void checkVersion(int n, int n2) {
        this.actual_major = n;
        this.actual_minor = n2;
        if (n != this.required_major || n2 < this.required_minor) {
            this.status = 1;
            throw new UnsatisfiedLinkError("The " + this.library_name + " native library " + this.actual_major + "." + this.actual_minor + " is too old (or new) to use. Version " + this.required_major + "." + this.required_minor + " is required.");
        }
    }

    void check(String string) {
        if (string != null) {
            this.status = 1;
            throw new UnsatisfiedLinkError("Unexpected result in " + this.library_name + " native library: " + string);
        }
    }

    void fail(Throwable throwable) {
        this.status = 1;
        this.link_error = throwable.getMessage();
        if (debuglevel >= 3) {
            NativeLink.debug(this.library_name + " library was not loaded: " + this.link_error);
        }
    }

    public void checkNative() {
        if (!this.useNative()) {
            throw new UnsatisfiedLinkError(this.link_error);
        }
    }

    public boolean useNative() {
        return this.status == 2 && this.want_native;
    }

    public void setNative(boolean bl) {
        this.want_native = bl;
    }

    boolean attemptLoad() {
        String string;
        if (this.status != 0 || !this.want_native) {
            return false;
        }
        try {
            String string2 = File.separator;
            string = CryptixProperties.getLibraryPath() + "bin" + string2;
        }
        catch (IOException iOException) {
            return false;
        }
        this.lib_loaded = this.attemptLoad(new String[]{string + this.library_name + ".dll", string + "lib" + this.library_name + ".so"});
        if (!this.lib_loaded) {
            throw new UnsatisfiedLinkError("The " + this.library_name + " native library could not be loaded.");
        }
        this.status = 2;
        this.link_error = null;
        return true;
    }

    private boolean attemptLoad(String[] stringArray) {
        if (debuglevel >= 7) {
            NativeLink.debug("entered attemptLoad(String[] libs) for " + this.library_name);
        }
        try {
            try {
                PrivilegeManager.enablePrivilege("UniversalFileRead");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            if (debuglevel >= 9) {
                int n = 0;
                while (n < stringArray.length) {
                    NativeLink.debug("libs[" + n + "] = \"" + stringArray[n] + "\"");
                    ++n;
                }
            }
            int n = 0;
            while (n < stringArray.length) {
                block29: {
                    try {
                        File file = new File(stringArray[n]);
                        if (file.isFile()) {
                            if (debuglevel >= 5) {
                                NativeLink.debug(stringArray[n] + " exists. Attempting load.");
                            }
                            try {
                                try {
                                    PrivilegeManager.enablePrivilege("UniversalLinkAccess");
                                }
                                catch (NoClassDefFoundError noClassDefFoundError) {
                                    // empty catch block
                                }
                                System.load(stringArray[n]);
                            }
                            finally {
                                Object var5_15 = null;
                                try {
                                    PrivilegeManager.revertPrivilege("UniversalLinkAccess");
                                }
                                catch (NoClassDefFoundError noClassDefFoundError) {}
                            }
                            if (debuglevel >= 3) {
                                NativeLink.debug(this.library_name + " library loaded successfully.");
                            }
                            return true;
                        }
                        if (debuglevel >= 6) {
                            NativeLink.debug(stringArray[n] + " does not exist.");
                        }
                        break block29;
                    }
                    catch (LinkageError linkageError) {
                        this.link_error = linkageError.toString();
                    }
                    catch (SecurityException securityException) {
                        this.link_error = securityException.toString();
                    }
                    catch (Throwable throwable) {
                        try {
                            PrivilegeManager.revertPrivilege("UniversalFileRead");
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            // empty catch block
                        }
                        this.link_error = throwable.getClass().getName();
                        NativeLink.debug("unexpected exception while attempting to load " + stringArray[n] + ": " + this.link_error);
                    }
                    if (debuglevel >= 3) {
                        NativeLink.debug(stringArray[n] + " failed to load: " + this.link_error);
                    }
                }
                ++n;
            }
            return false;
        }
        catch (SecurityException securityException) {
            this.link_error = securityException.toString();
            if (debuglevel >= 3) {
                NativeLink.debug(this.library_name + " library failed to load: " + this.link_error);
            }
            return false;
        }
    }

    NativeLink(String string, int n, int n2) {
        this.required_major = n;
        this.required_minor = n2;
        this.library_name = string;
        this.want_native = NativeLink.isNativeWanted(string);
        this.link_error = this.want_native ? "Library is not loaded because the class has not yet been used." : "Library is not loaded because it is disabled in the properties.";
    }

    static {
        try {
            String string = CryptixProperties.getProperty("Native.Allowed");
            native_allowed = string == null || string.equalsIgnoreCase("true");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

