/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.util.Comparator;
import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.ParserDQL;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.SubQuery;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class StatementProcedure
extends StatementDMQL {
    Expression expression;
    Routine procedure;
    Expression[] arguments = Expression.emptyArray;
    ResultMetaData resultMetaData;

    StatementProcedure(Session session, Expression expression, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentSchemaHsqlName());
        this.statementReturnType = 2;
        if (expression.opType == 27) {
            FunctionSQLInvoked f = (FunctionSQLInvoked)expression;
            if (f.routine.returnsTable) {
                this.procedure = f.routine;
                this.arguments = f.nodes;
            } else {
                this.expression = expression;
            }
        } else {
            this.expression = expression;
        }
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        if (this.procedure != null) {
            session.getGrantee().checkAccess(this.procedure);
        }
    }

    StatementProcedure(Session session, Routine procedure, Expression[] arguments, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentSchemaHsqlName());
        if (procedure.maxDynamicResults > 0) {
            this.statementReturnType = 0;
        }
        this.procedure = procedure;
        this.arguments = arguments;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        session.getGrantee().checkAccess(procedure);
    }

    Result getResult(Session session) {
        Result result = this.expression == null ? this.getProcedureResult(session) : this.getExpressionResult(session);
        result.setStatementType(this.statementReturnType);
        return result;
    }

    Result getProcedureResult(Session session) {
        int argLength;
        Object[] data = ValuePool.emptyObjectArray;
        if (this.procedure.isPSM()) {
            argLength = this.arguments.length;
            if (this.procedure.getMaxDynamicResults() > 0) {
                ++argLength;
            }
        } else {
            argLength = this.procedure.javaMethod.getParameterTypes().length;
            if (this.procedure.javaMethodWithConnection) {
                --argLength;
            }
        }
        if (argLength > 0) {
            data = new Object[argLength];
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            Expression e = this.arguments[i];
            Object value = e.getValue(session);
            if (e == null) continue;
            Type targetType = this.procedure.getParameter(i).getDataType();
            data[i] = targetType.convertToType(session, value, e.getDataType());
        }
        session.sessionContext.push();
        session.sessionContext.routineArguments = data;
        session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
        Result result = Result.updateZeroResult;
        if (this.procedure.isPSM()) {
            result = this.executePSMProcedure(session);
        } else {
            JDBCConnection connection = session.getInternalConnection();
            result = this.executeJavaProcedure(session, connection);
        }
        Object[] callArguments = session.sessionContext.routineArguments;
        session.sessionContext.pop();
        if (!this.procedure.isPSM()) {
            session.releaseInternalConnection();
        }
        if (result.isError()) {
            return result;
        }
        for (int i = 0; i < this.procedure.getParameterCount(); ++i) {
            ColumnSchema param = this.procedure.getParameter(i);
            byte mode = param.getParameterMode();
            if (mode == 1) continue;
            if (this.arguments[i].isDynamicParam()) {
                int paramIndex = this.arguments[i].parameterIndex;
                session.sessionContext.dynamicArguments[paramIndex] = callArguments[i];
                continue;
            }
            int varIndex = this.arguments[i].getColumnIndex();
            session.sessionContext.routineVariables[varIndex] = callArguments[i];
        }
        Result r = result;
        result = Result.newCallResponse(this.getParametersMetaData().getParameterTypes(), this.id, session.sessionContext.dynamicArguments);
        if (this.procedure.returnsTable()) {
            result.addChainedResult(r);
        } else if (callArguments.length > this.arguments.length) {
            r = (Result)callArguments[this.arguments.length];
            result.addChainedResult(r);
        }
        return result;
    }

    Result executePSMProcedure(Session session) {
        int variableCount = this.procedure.getVariableCount();
        session.sessionContext.routineVariables = new Object[variableCount];
        Result result = this.procedure.statement.execute(session);
        if (result.isError()) {
            return result;
        }
        if (this.procedure.returnsTable()) {
            RowSetNavigator resultNavigator = result.getNavigator();
            RowSetNavigatorData navigator = new RowSetNavigatorData(session, resultNavigator);
            result.setNavigator(navigator);
        }
        return result;
    }

    Result executeJavaProcedure(Session session, Connection connection) {
        Result result = Result.updateZeroResult;
        Object[] callArguments = session.sessionContext.routineArguments;
        Object[] data = this.procedure.convertArgsToJava(session, callArguments);
        if (this.procedure.javaMethodWithConnection) {
            data[0] = connection;
        }
        result = this.procedure.invokeJavaMethod(session, data);
        this.procedure.convertArgsToSQL(session, callArguments, data);
        return result;
    }

    Result getExpressionResult(Session session) {
        session.sessionData.startRowProcessing();
        Object o = this.expression.getValue(session);
        if (this.resultMetaData == null) {
            this.getResultMetaData();
        }
        Result r = Result.newSingleColumnResult(this.resultMetaData);
        Object[] row = this.expression.getDataType().isArrayType() ? new Object[]{o} : (o instanceof Object[] ? (Object[])o : new Object[]{o});
        r.getNavigator().add(row);
        return r;
    }

    SubQuery[] getSubqueries(Session session) {
        OrderedHashSet subQueries = null;
        if (this.expression != null) {
            subQueries = this.expression.collectAllSubqueries(subQueries);
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            subQueries = this.arguments[i].collectAllSubqueries(subQueries);
        }
        if (subQueries == null || subQueries.size() == 0) {
            return SubQuery.emptySubqueryArray;
        }
        Object[] subQueryArray = new SubQuery[subQueries.size()];
        subQueries.toArray(subQueryArray);
        ArraySort.sort(subQueryArray, 0, subQueryArray.length, (Comparator)subQueryArray[0]);
        for (int i = 0; i < this.subqueries.length; ++i) {
            ((SubQuery)subQueryArray[i]).prepareTable(session);
        }
        return subQueryArray;
    }

    public ResultMetaData getResultMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        switch (this.type) {
            case 7: {
                if (this.expression == null) {
                    return ResultMetaData.emptyResultMetaData;
                }
                ResultMetaData md = ResultMetaData.newResultMetaData(1);
                ColumnBase column = new ColumnBase(null, null, null, "@p0");
                column.setType(this.expression.getDataType());
                md.columns[0] = column;
                md.prepareData();
                this.resultMetaData = md;
                return md;
            }
        }
        throw Error.runtimeError(201, "StatementProcedure");
    }

    public ResultMetaData getParametersMetaData() {
        return super.getParametersMetaData();
    }

    void collectTableNamesForRead(OrderedHashSet set) {
        if (this.expression == null) {
            set.addAll(this.procedure.getTableNamesForRead());
        } else {
            int i;
            for (i = 0; i < this.subqueries.length; ++i) {
                if (this.subqueries[i].queryExpression == null) continue;
                this.subqueries[i].queryExpression.getBaseTableNames(set);
            }
            for (i = 0; i < this.routines.length; ++i) {
                set.addAll(this.routines[i].getTableNamesForRead());
            }
        }
    }

    void collectTableNamesForWrite(OrderedHashSet set) {
        if (this.expression == null) {
            set.addAll(this.procedure.getTableNamesForWrite());
        }
    }
}

