/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.trilliansecureim;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.channel.rendezvous.TrillianSecureIMRendezvous;
import org.walluck.oscar.handlers.ICBMHandler;

public class TrillianSecureIM {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$handlers$trilliansecureim$TrillianSecureIM == null ? (class$org$walluck$oscar$handlers$trilliansecureim$TrillianSecureIM = TrillianSecureIM.class$("org.walluck.oscar.handlers.trilliansecureim.TrillianSecureIM")) : class$org$walluck$oscar$handlers$trilliansecureim$TrillianSecureIM).getName());
    private AIMSession sess;
    private String screenname;
    private static final BigInteger FIVE = new BigInteger("5");
    private Cipher encoder;
    private Cipher decoder;
    private BigInteger modulus;
    private BigInteger myPrivate;
    private BigInteger myPublic;
    private BigInteger otherPublic;
    private BigInteger sessionKey;
    private SecureRandom random;
    static /* synthetic */ Class class$org$walluck$oscar$handlers$trilliansecureim$TrillianSecureIM;

    public TrillianSecureIM(AIMSession sess, String screenname) {
        this.sess = sess;
        this.screenname = screenname;
        this.random = new SecureRandom();
    }

    private void initCiphers() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        LOG.debug((Object)"initCiphers: called");
        this.sessionKey = this.otherPublic.modPow(this.myPrivate, this.modulus);
        byte[] sessionKeyBytes = this.sessionKey.toByteArray();
        if (sessionKeyBytes.length == 17) {
            LOG.debug((Object)("trimming byte=0x" + Integer.toHexString(sessionKeyBytes[0])));
            byte[] sessionKeyBytes2 = new byte[sessionKeyBytes.length - 1];
            System.arraycopy(sessionKeyBytes, 1, sessionKeyBytes2, 0, sessionKeyBytes2.length);
            sessionKeyBytes = sessionKeyBytes2;
        }
        LOG.debug((Object)("bit length=" + sessionKeyBytes.length * 8));
        LOG.debug((Object)("first byte=0x" + Integer.toHexString(sessionKeyBytes[0])));
        SecretKeySpec spec = new SecretKeySpec(sessionKeyBytes, "Blowfish");
        byte[] ivb = new byte[8];
        this.random.nextBytes(ivb);
        IvParameterSpec ips = new IvParameterSpec(ivb);
        this.encoder = Cipher.getInstance("Blowfish/CFB64/NoPadding");
        this.encoder.init(1, (Key)spec, ips);
        this.decoder = Cipher.getInstance("Blowfish/CFB64/NoPadding");
        this.decoder.init(2, (Key)spec, ips);
    }

    public void end() {
        TrillianSecureIMRendezvous rv = new TrillianSecureIMRendezvous();
        try {
            rv.setClose();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            im.sendRendezvous(this.sess, this.screenname, rv);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void sendRequest() throws IOException {
        this.modulus = new BigInteger(128, this.random);
        this.myPrivate = new BigInteger(128, this.random).mod(this.modulus);
        this.myPublic = FIVE.modPow(this.myPrivate, this.modulus);
        TrillianSecureIMRendezvous rv = new TrillianSecureIMRendezvous();
        rv.setPrime(this.modulus);
        rv.setPublicValue(this.myPublic);
        rv.setRequest();
        ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
        im.sendRendezvous(this.sess, this.screenname, rv);
    }

    public void sendMsg(String msg) {
        TrillianSecureIMRendezvous rv = new TrillianSecureIMRendezvous();
        if (msg == null) {
            LOG.warn((Object)"null msg, not sending");
            return;
        }
        try {
            byte[] mbytes = msg.getBytes("US-ASCII");
            byte[] b = new byte[mbytes.length + 8];
            System.arraycopy(mbytes, 0, b, 8, mbytes.length);
            byte[] encodedMessage = this.encoder.doFinal(b);
            rv.setMsg(encodedMessage);
            rv.setMsg();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            im.sendRendezvous(this.sess, this.screenname, rv);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        catch (IllegalBlockSizeException ibe) {
            LOG.error((Object)"IllegalBlockSizeException", (Throwable)ibe);
        }
        catch (BadPaddingException bpe) {
            LOG.error((Object)"BadPaddignException", (Throwable)bpe);
        }
    }

    public void handleSecureIM(IncomingIMCH2 args) {
        LOG.debug((Object)"handling TrillianSecureIMRendezvous...");
        IncomingIMCH2.TrillianEncryption te = args.getTrillianEncryption();
        if (te.getCmdType() == 0) {
            LOG.debug((Object)("Received Trillian SecureIM Request from " + this.screenname));
            try {
                this.modulus = te.getPrime();
                if (this.modulus == null) {
                    LOG.warn((Object)"modulus is null in Request!");
                }
                this.otherPublic = te.getPublicValue();
                if (this.otherPublic == null) {
                    LOG.warn((Object)"otherPublic is null in Request!");
                }
                this.myPrivate = new BigInteger(128, new Random()).mod(this.modulus);
                this.myPublic = FIVE.modPow(this.myPrivate, this.modulus);
                this.initCiphers();
                TrillianSecureIMRendezvous rv = new TrillianSecureIMRendezvous();
                rv.setPublicValue(this.myPublic);
                try {
                    rv.setAccept();
                    ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
                    im.sendRendezvous(this.sess, this.screenname, rv);
                }
                catch (IOException ioe) {
                    LOG.error((Object)"IOException", (Throwable)ioe);
                }
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
            }
            catch (NoSuchPaddingException nspe) {
                LOG.error((Object)"NoSuchPaddingException", (Throwable)nspe);
            }
            catch (InvalidKeyException ike) {
                LOG.error((Object)"InvalidKeyException", (Throwable)ike);
            }
            catch (InvalidAlgorithmParameterException iape) {
                LOG.error((Object)"InvalidAlgorithmParameterException", (Throwable)iape);
            }
        } else if (te.getCmdType() == 1) {
            LOG.debug((Object)("Received Trillian SecureIm Accept from " + this.screenname));
            if (this.modulus == null || this.myPrivate == null || this.myPublic == null) {
                LOG.warn((Object)"Did we forget to call sendRequest()?");
                return;
            }
            this.otherPublic = te.getPublicValue();
            try {
                this.initCiphers();
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
            }
            catch (NoSuchPaddingException nspe) {
                LOG.error((Object)"NoSuchPaddingException", (Throwable)nspe);
            }
            catch (InvalidKeyException ike) {
                LOG.error((Object)"InvalidKeyException", (Throwable)ike);
            }
            catch (InvalidAlgorithmParameterException iape) {
                LOG.error((Object)"InvalidAlgorithmParameterException", (Throwable)iape);
            }
            TrillianSecureIMRendezvous rv = new TrillianSecureIMRendezvous();
            try {
                rv.setBegin();
                ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
                im.sendRendezvous(this.sess, this.screenname, rv);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        } else if (te.getCmdType() == 2) {
            LOG.debug((Object)("Received Trillian SecureIm Begin from " + this.screenname));
            LOG.debug((Object)("Started encrypted session with " + this.screenname));
        } else if (te.getCmdType() == 3) {
            LOG.debug((Object)("Received Trillian SecureIm Msg from " + this.screenname));
            byte[] encrypted = te.getMsg();
            LOG.debug((Object)("encrypted.length=" + encrypted.length));
            try {
                byte[] decoded = this.decoder.doFinal(encrypted);
                LOG.debug((Object)("decoded.length=" + decoded.length));
                if (decoded.length > 8) {
                    byte[] decoded2 = new byte[decoded.length - 8];
                    System.arraycopy(decoded, 8, decoded2, 0, decoded2.length);
                    te.setMsg(decoded2);
                } else {
                    LOG.warn((Object)("decoded.length=" + decoded.length + ", should be > 8"));
                    te.setMsg(decoded);
                }
                LOG.debug((Object)("decoded message from=" + this.screenname + ": " + new String(te.getMsg(), "US-ASCII")));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.error((Object)"UnsupportedEncodingException", (Throwable)uee);
            }
            catch (IllegalBlockSizeException ibe) {
                LOG.error((Object)"IllegalBlockSizeException", (Throwable)ibe);
            }
            catch (BadPaddingException bpe) {
                LOG.error((Object)"BadPaddignException", (Throwable)bpe);
            }
        } else if (te.getCmdType() == 4) {
            LOG.debug((Object)("Received Trillian SecureIm Close from " + this.screenname));
            LOG.debug((Object)("Closed encryption session with " + this.screenname));
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getMyPrivate() {
        return this.myPrivate;
    }

    public BigInteger getMyPublic() {
        return this.myPublic;
    }

    public BigInteger getOtherPublic() {
        return this.otherPublic;
    }

    public BigInteger getSessionKey() {
        return this.sessionKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

