/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BaseSearchResultPermissionFilter;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import java.util.ArrayList;

public class DefaultSearchResultPermissionFilter
extends BaseSearchResultPermissionFilter {
    private static Log _log = LogFactoryUtil.getLog(DefaultSearchResultPermissionFilter.class);
    private BaseIndexer _baseIndexer;
    private PermissionChecker _permissionChecker;

    public DefaultSearchResultPermissionFilter(BaseIndexer baseIndexer, PermissionChecker permissionChecker) {
        this._baseIndexer = baseIndexer;
        this._permissionChecker = permissionChecker;
    }

    @Override
    protected void filterHits(Hits hits, SearchContext searchContext) {
        ArrayList<Document> docs = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        Document[] documents = hits.getDocs();
        int excludeDocsSize = 0;
        int status = GetterUtil.getInteger(searchContext.getAttribute("status"), 0);
        int i = 0;
        while (i < documents.length) {
            if (this._isIncludeDocument(documents[i], status)) {
                docs.add(documents[i]);
                scores.add(Float.valueOf(hits.score(i)));
            } else {
                ++excludeDocsSize;
            }
            ++i;
        }
        hits.setDocs(docs.toArray(new Document[docs.size()]));
        hits.setScores(ArrayUtil.toFloatArray(scores));
        hits.setSearchTime((float)(System.currentTimeMillis() - hits.getStart()) / 1000.0f);
        hits.setLength(hits.getLength() - excludeDocsSize);
    }

    @Override
    protected Hits getHits(SearchContext searchContext) throws SearchException {
        return this._baseIndexer.doSearch(searchContext);
    }

    @Override
    protected boolean isGroupAdmin(SearchContext searchContext) {
        if (this._permissionChecker.isCompanyAdmin(searchContext.getCompanyId())) {
            return true;
        }
        long[] groupIds = searchContext.getGroupIds();
        if (groupIds == null) {
            return false;
        }
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            if (!this._permissionChecker.isGroupAdmin(groupId)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean _isIncludeDocument(Document document, int status) {
        block5: {
            String entryClassName = document.get("entryClassName");
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer == null) {
                return true;
            }
            if (!indexer.isFilterSearch() || !indexer.isPermissionAware()) {
                return true;
            }
            long entryClassPK = GetterUtil.getLong(document.get("entryClassPK"));
            try {
                if (indexer.hasPermission(this._permissionChecker, entryClassName, entryClassPK, "VIEW") && indexer.isVisibleRelatedEntry(entryClassPK, status)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug(e, e);
            }
        }
        return false;
    }
}

