/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import [Ljava.lang.Boolean;;
import [Ljava.lang.Double;;
import [Ljava.lang.Float;;
import [Ljava.lang.Integer;;
import [Ljava.lang.Long;;
import [Ljava.lang.Short;;
import [Ljava.lang.String;;
import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.lang.reflect.Array;
import org.json.JSONArray;

public class ArraySerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static Class[] _serializableClasses = new Class[]{[I.class, [S.class, [J.class, [F.class, [D.class, [Z.class, Integer;.class, Short;.class, Long;.class, Float;.class, Double;.class, Boolean;.class, String;.class};
    private static Class[] _JSONClasses = new Class[]{JSONArray.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        Class<?> cc = clazz.getComponentType();
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONArray.class) && clazz.isArray() && !cc.isPrimitive();
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int i;
        JSONArray jso = (JSONArray)o;
        Class<?> cc = clazz.getComponentType();
        ObjectMatch m = new ObjectMatch(-1);
        try {
            for (i = 0; i < jso.length(); ++i) {
                m = this.ser.tryUnmarshall(state, cc, jso.get(i)).max(m);
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage());
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int i;
        JSONArray jso = (JSONArray)o;
        Class<?> cc = clazz.getComponentType();
        try {
            if (clazz == [I.class) {
                int[] arr = new int[jso.length()];
                for (i = 0; i < jso.length(); ++i) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).intValue();
                }
                return arr;
            }
            if (clazz == [B.class) {
                byte[] arr = new byte[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).byteValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == [S.class) {
                short[] arr = new short[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).shortValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == [J.class) {
                long[] arr = new long[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).longValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == [F.class) {
                float[] arr = new float[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).floatValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == [D.class) {
                double[] arr = new double[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).doubleValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == [C.class) {
                char[] arr = new char[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((String)this.ser.unmarshall(state, cc, jso.get(i))).charAt(0);
                    ++i;
                }
                return arr;
            }
            if (clazz == [Z.class) {
                boolean[] arr = new boolean[jso.length()];
                while (i < jso.length()) {
                    arr[i] = (Boolean)this.ser.unmarshall(state, cc, jso.get(i));
                    ++i;
                }
                return arr;
            }
            Object[] arr = (Object[])Array.newInstance(clazz.getComponentType(), jso.length());
            while (i < jso.length()) {
                arr[i] = this.ser.unmarshall(state, cc, jso.get(i));
                ++i;
            }
            return arr;
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage());
        }
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        JSONArray arr;
        block10: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block9: {
                                            arr = new JSONArray();
                                            if (!(o instanceof int[])) break block9;
                                            int[] a = (int[])o;
                                            for (int i = 0; i < a.length; ++i) {
                                                arr.put(a[i]);
                                            }
                                            break block10;
                                        }
                                        if (!(o instanceof long[])) break block11;
                                        long[] a = (long[])o;
                                        for (int i = 0; i < a.length; ++i) {
                                            arr.put((double)a[i]);
                                        }
                                        break block10;
                                    }
                                    if (!(o instanceof short[])) break block12;
                                    short[] a = (short[])o;
                                    for (int i = 0; i < a.length; ++i) {
                                        arr.put((int)a[i]);
                                    }
                                    break block10;
                                }
                                if (!(o instanceof byte[])) break block13;
                                byte[] a = (byte[])o;
                                for (int i = 0; i < a.length; ++i) {
                                    arr.put((int)a[i]);
                                }
                                break block10;
                            }
                            if (!(o instanceof float[])) break block14;
                            float[] a = (float[])o;
                            for (int i = 0; i < a.length; ++i) {
                                arr.put((double)a[i]);
                            }
                            break block10;
                        }
                        if (!(o instanceof double[])) break block15;
                        double[] a = (double[])o;
                        for (int i = 0; i < a.length; ++i) {
                            arr.put(a[i]);
                        }
                        break block10;
                    }
                    if (!(o instanceof char[])) break block16;
                    char[] a = (char[])o;
                    for (int i = 0; i < a.length; ++i) {
                        arr.put((int)a[i]);
                    }
                    break block10;
                }
                if (!(o instanceof boolean[])) break block17;
                boolean[] a = (boolean[])o;
                for (int i = 0; i < a.length; ++i) {
                    arr.put(a[i]);
                }
                break block10;
            }
            if (!(o instanceof Object[])) break block10;
            Object[] a = (Object[])o;
            for (int i = 0; i < a.length; ++i) {
                arr.put(this.ser.marshall(state, a[i]));
            }
        }
        return arr;
    }
}

