/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.template;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.template.BaseTemplateHandler;
import com.liferay.portal.kernel.template.TemplateVariableCodeHandler;
import com.liferay.portal.kernel.template.TemplateVariableGroup;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class BaseDDMTemplateHandler
extends BaseTemplateHandler {
    public Map<String, TemplateVariableGroup> getTemplateVariableGroups(long classPK, String language, Locale locale) throws Exception {
        LinkedHashMap<String, TemplateVariableGroup> templateVariableGroups = new LinkedHashMap<String, TemplateVariableGroup>();
        this.addTemplateVariableGroup(templateVariableGroups, this.getGeneralVariablesTemplateVariableGroup());
        this.addTemplateVariableGroup(templateVariableGroups, this.getStructureFieldsTemplateVariableGroup(classPK, locale));
        this.addTemplateVariableGroup(templateVariableGroups, this.getUtilTemplateVariableGroup());
        return templateVariableGroups;
    }

    protected void addTemplateVariableGroup(Map<String, TemplateVariableGroup> templateVariableGroups, TemplateVariableGroup templateVariableGroup) {
        if (templateVariableGroup == null) {
            return;
        }
        templateVariableGroups.put(templateVariableGroup.getLabel(), templateVariableGroup);
    }

    protected Class<?> getFieldVariableClass() {
        return TemplateNode.class;
    }

    protected TemplateVariableGroup getGeneralVariablesTemplateVariableGroup() {
        TemplateVariableGroup templateVariableGroup = new TemplateVariableGroup("general-variables");
        templateVariableGroup.addVariable("portal-instance", Company.class, "company");
        templateVariableGroup.addVariable("portal-instance-id", null, "companyId");
        templateVariableGroup.addVariable("device", Device.class, "device");
        templateVariableGroup.addVariable("site-id", null, "groupId");
        templateVariableGroup.addVariable("view-mode", String.class, "viewMode");
        return templateVariableGroup;
    }

    protected abstract TemplateVariableCodeHandler getTemplateVariableCodeHandler();

    protected TemplateVariableGroup getStructureFieldsTemplateVariableGroup(long ddmStructureId, Locale locale) throws PortalException, SystemException {
        if (ddmStructureId <= 0L) {
            return null;
        }
        TemplateVariableGroup templateVariableGroup = new TemplateVariableGroup("fields");
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        List fieldNames = ddmStructure.getRootFieldNames();
        for (String fieldName : fieldNames) {
            if (fieldName.startsWith("_")) continue;
            String label = ddmStructure.getFieldLabel(fieldName, locale);
            String tip = ddmStructure.getFieldTip(fieldName, locale);
            String dataType = ddmStructure.getFieldDataType(fieldName);
            boolean repeatable = ddmStructure.getFieldRepeatable(fieldName);
            templateVariableGroup.addFieldVariable(label, this.getFieldVariableClass(), fieldName, tip, dataType, repeatable, this.getTemplateVariableCodeHandler());
        }
        return templateVariableGroup;
    }

    protected TemplateVariableGroup getUtilTemplateVariableGroup() {
        TemplateVariableGroup templateVariableGroup = new TemplateVariableGroup("util");
        templateVariableGroup.addVariable("permission-checker", PermissionChecker.class, "permissionChecker");
        templateVariableGroup.addVariable("random-namespace", String.class, "randomNamespace");
        templateVariableGroup.addVariable("templates-path", String.class, "templatesPath");
        return templateVariableGroup;
    }
}

