/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gcube.oidc.D4ScienceMappings;
import org.gcube.oidc.OIDCToSitesAndRolesMapper;
import org.gcube.oidc.Site;
import org.gcube.oidc.SitesMapperExecption;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementPortalException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;

public class UserSitesToGroupsAndRolesMapper {
    protected static final Log log = LogFactoryUtil.getLog(UserSitesToGroupsAndRolesMapper.class);
    protected User user;
    protected OIDCToSitesAndRolesMapper mapper;
    protected UserManager userManager;
    protected GroupManager groupManager;
    protected RoleManager roleManager;
    protected String rootVOName;
    protected Map<Long, List<String>> actualGroupAndRoles;
    protected Map<String, GCubeRole> roleNameToRole;

    public UserSitesToGroupsAndRolesMapper(User user, OIDCToSitesAndRolesMapper mapper) {
        this.user = user;
        this.mapper = mapper;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating the permission checker for admin user");
            }
            long adminUserId = LiferayUserManager.getAdmin().getUserId();
            PrincipalThreadLocal.setName((long)adminUserId);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)adminUserId)));
        }
        catch (Exception e) {
            log.fatal((Object)"Cannot create permission checker for admin user", (Throwable)e);
            return;
        }
        this.userManager = new LiferayUserManager();
        this.groupManager = new LiferayGroupManager();
        this.roleManager = new LiferayRoleManager();
        try {
            this.rootVOName = this.groupManager.getRootVOName();
        }
        catch (GroupRetrievalFault | UserManagementSystemException e) {
            log.error((Object)"Cannot get infrastructure's Root VO", e);
            return;
        }
        try {
            Map retrivedGroupAndRoles = this.groupManager.listGroupsAndRolesByUser(user.getUserId());
            this.actualGroupAndRoles = new TreeMap<Long, List<String>>();
            for (GCubeGroup gCubeGroup : retrivedGroupAndRoles.keySet()) {
                ArrayList<String> newList = new ArrayList<String>();
                this.actualGroupAndRoles.put(gCubeGroup.getGroupId(), newList);
                for (GCubeRole gCubeRole : (List)retrivedGroupAndRoles.get(gCubeGroup)) {
                    newList.add(gCubeRole.getRoleName());
                }
            }
        }
        catch (UserManagementSystemException e) {
            log.error((Object)"Cannot get sites and roles membership for user", (Throwable)e);
            return;
        }
        this.roleNameToRole = new TreeMap<String, GCubeRole>();
        for (GCubeRole role : this.roleManager.listAllGroupRoles()) {
            this.roleNameToRole.put(role.getRoleName(), role);
        }
    }

    public void map() {
        log.debug((Object)("Mapping roles to sites for user: " + this.user.getScreenName()));
        Site gwSitesTree = null;
        try {
            gwSitesTree = this.mapper.map(this.rootVOName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sites tree is: " + (gwSitesTree != null ? gwSitesTree.dump() : "null")));
            }
        }
        catch (SitesMapperExecption e) {
            log.error((Object)"Computing sites tree in concrete mapper class", (Throwable)e);
        }
        if (gwSitesTree != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Check user to sites assignemnts");
            }
            this.rolesToSiteDescendant(gwSitesTree);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Check user to sites removal");
        }
        this.checkForSiteRemoval(gwSitesTree);
    }

    protected void rolesToSiteDescendant(Site actualSite) {
        Long actualSiteGroupId = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting actual site group from group manager, actual site: " + actualSite.getName()));
            }
            actualSiteGroupId = this.groupManager.getGroupId(actualSite.getName());
        }
        catch (GroupRetrievalFault | UserManagementSystemException e) {
            log.warn((Object)("Cannot retrieve group for site: " + actualSite.getName()), e);
            return;
        }
        if (actualSiteGroupId < 0L) {
            log.warn((Object)("Retrieved group id is not valid for the site: " + actualSite.getName()));
            return;
        }
        try {
            if (this.groupManager.isVRE(actualSiteGroupId.longValue()).booleanValue() && !this.actualGroupAndRoles.containsKey(actualSiteGroupId)) {
                log.debug((Object)("Assigning user to new VRE site: " + actualSite.getName()));
                this.userManager.assignUserToGroup(actualSiteGroupId.longValue(), this.user.getUserId());
                if (actualSite.getRoles() != null && !actualSite.getRoles().isEmpty()) {
                    log.debug((Object)"Assiging roles for the new assigned VRE site");
                    for (String roleName : actualSite.getRoles()) {
                        if (D4ScienceMappings.Role.MEMBER.asString().equals(roleName)) continue;
                        this.roleManager.assignRoleToUser(this.user.getUserId(), actualSiteGroupId.longValue(), this.roleNameToRole.get(roleName).getRoleId());
                    }
                    return;
                }
                log.debug((Object)"User has no roles in the VRE site");
            }
        }
        catch (RuntimeException | GroupRetrievalFault | RoleRetrievalFault | UserManagementPortalException | UserManagementSystemException | UserRetrievalFault e) {
            log.error((Object)("Assigning user to new VRE site: " + actualSite.getName()), e);
        }
        if (actualSite.getRoles() != null) {
            List<String> actualSiteGroupRoles = this.actualGroupAndRoles.get(actualSiteGroupId);
            ArrayList newRoles = new ArrayList(actualSite.getRoles());
            newRoles.remove(D4ScienceMappings.Role.MEMBER.asString());
            if (actualSiteGroupRoles != null && !actualSiteGroupRoles.isEmpty()) {
                log.debug((Object)"Checking actual roles in the site's group");
                for (String gcRoleName : actualSiteGroupRoles) {
                    String actualSiteName = actualSite.getName();
                    if (D4ScienceMappings.Role.exists((String)gcRoleName) && !actualSite.getRoles().contains(gcRoleName)) {
                        try {
                            log.debug((Object)("Removing '" + gcRoleName + "' user's role for site: " + actualSiteName));
                            this.roleManager.removeRoleFromUser(this.user.getUserId(), actualSiteGroupId.longValue(), this.roleNameToRole.get(gcRoleName).getRoleId());
                        }
                        catch (GroupRetrievalFault | RoleRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
                            log.error((Object)("Can't remove user role '" + gcRoleName + "' from: " + actualSiteName), e);
                        }
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("User still have role in the site, emoving it from the new roles list: " + gcRoleName));
                    }
                    newRoles.remove(gcRoleName);
                }
            } else {
                log.debug((Object)"User actually has no roles different from Member in the site");
            }
            if (!newRoles.isEmpty()) {
                for (String newRole : newRoles) {
                    GCubeRole newGcRole;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding new role to user. New role: " + newRole));
                    }
                    if ((newGcRole = this.roleNameToRole.get(newRole)) != null) {
                        try {
                            log.debug((Object)("Assinging new role '" + newRole + "' to user"));
                            this.roleManager.assignRoleToUser(this.user.getUserId(), actualSiteGroupId.longValue(), newGcRole.getRoleId());
                        }
                        catch (GroupRetrievalFault | RoleRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
                            log.error((Object)("Cannot assign new role '" + newRole + "' for site: " + actualSite.getName()), e);
                        }
                        continue;
                    }
                    log.warn((Object)("New site's gc role is null (doesn't exist?) after getting it from role manager: " + newRole));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"User has no new roles for the site");
            }
        } else {
            log.debug((Object)("Roles were not set, continuing descending letting them untouched in site: " + actualSite.getName()));
        }
        for (Site childSite : actualSite.getChildren().values()) {
            log.debug((Object)("Recursive call to child site: " + childSite.getName()));
            this.rolesToSiteDescendant(childSite);
        }
    }

    protected void checkForSiteRemoval(Site gwSitesTree) {
        ArrayList<String> vreNames = new ArrayList<String>();
        if (gwSitesTree != null) {
            log.debug((Object)"Collecting VREs user belongs to");
            for (Site vo : gwSitesTree.getChildren().values()) {
                for (Site vre : vo.getChildren().values()) {
                    String vreName = vre.getName();
                    log.trace((Object)("Adding VRE to the list: " + vreName));
                    vreNames.add(vreName);
                }
            }
        } else {
            log.debug((Object)"User not belongs to any VRE");
        }
        for (Long actualGroupId : this.actualGroupAndRoles.keySet()) {
            try {
                String actualGroupName = this.groupManager.getGroup(actualGroupId.longValue()).getGroupName();
                if (this.groupManager.isVRE(actualGroupId.longValue()).booleanValue()) {
                    if (!vreNames.contains(actualGroupName)) {
                        log.debug((Object)("Removing user from VRE: " + actualGroupName));
                        try {
                            this.userManager.dismissUserFromGroup(actualGroupId.longValue(), this.user.getUserId());
                        }
                        catch (UserRetrievalFault e) {
                            log.error((Object)("Removing user from VRE: " + actualGroupName), (Throwable)e);
                        }
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("User still belong to VRE: " + actualGroupName));
                    continue;
                }
                log.debug((Object)("Do not check membership for non VRE: " + actualGroupName));
            }
            catch (GroupRetrievalFault | UserManagementSystemException e) {
                log.error((Object)"Checking if site group is a VRE", e);
            }
        }
    }
}

