/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.WhenThenNode;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class CaseNode
extends Node {
    private List whenClauses = null;

    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        ParseTreeContext context = generationContext.getParseTreeContext();
        if (theQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            Expression expression = this.generateExpression(generationContext);
            reportQuery.addAttribute("Case", expression, (Class)this.getType());
        }
    }

    public Expression generateExpression(GenerationContext context) {
        LinkedHashMap<Expression, Expression> whenClauseMap = new LinkedHashMap<Expression, Expression>(this.whenClauses.size());
        for (WhenThenNode clause : this.whenClauses) {
            whenClauseMap.put(clause.generateExpressionForWhen(context), clause.generateExpressionForThen(context));
        }
        Expression whereClause = null;
        whereClause = this.getLeft() == null ? context.getBaseExpression().caseStatement(whenClauseMap, this.getRight().generateExpression(context)) : this.getLeft().generateExpression(context).caseStatement(whenClauseMap, this.getRight().generateExpression(context));
        return whereClause;
    }

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
        }
        this.right.validate(context);
        Iterator i = this.whenClauses.iterator();
        Class<Object> type = null;
        while (i.hasNext()) {
            Node node = (Node)i.next();
            node.validate(context);
            if (type == null) {
                type = node.getType();
                continue;
            }
            if (type.equals(node.getType())) continue;
            type = Object.class;
        }
        if (this.getRight().getType() != type) {
            type = typeHelper.getObjectType();
        }
        this.setType(type);
    }

    public List getWhenClauses() {
        return this.whenClauses;
    }

    public void setWhenClauses(List whenClauses) {
        this.whenClauses = whenClauses;
    }
}

