/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Row;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.TriggerDef;
import org.hsqldb.TypeInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;

public class SchemaManager {
    Database database;
    HsqlNameManager.HsqlName defaultSchemaHsqlName;
    HashMappedList schemaMap = new HashMappedList();
    MultiValueHashMap referenceMap = new MultiValueHashMap();
    int defaultTableType = 4;
    long schemaChangeTimestamp;
    HsqlNameManager.HsqlName[] catalogNameArray;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();
    Table dualTable;
    int[][] tempIndexRoots;

    public SchemaManager(Database database) {
        this.database = database;
        this.defaultSchemaHsqlName = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        this.catalogNameArray = new HsqlNameManager.HsqlName[]{database.getCatalogName()};
        Schema schema = new Schema(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner);
        this.schemaMap.put(schema.getName().name, schema);
        try {
            schema.typeLookup.add(TypeInvariants.CARDINAL_NUMBER);
            schema.typeLookup.add(TypeInvariants.YES_OR_NO);
            schema.typeLookup.add(TypeInvariants.CHARACTER_DATA);
            schema.typeLookup.add(TypeInvariants.SQL_IDENTIFIER);
            schema.typeLookup.add(TypeInvariants.TIME_STAMP);
            schema.charsetLookup.add(TypeInvariants.SQL_TEXT);
            schema.charsetLookup.add(TypeInvariants.SQL_IDENTIFIER_CHARSET);
            schema.charsetLookup.add(TypeInvariants.SQL_CHARACTER);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void setSchemaChangeTimestamp() {
        this.schemaChangeTimestamp = this.database.txManager.getGlobalChangeTimestamp();
    }

    public long getSchemaChangeTimestamp() {
        return this.schemaChangeTimestamp;
    }

    public HsqlNameManager.HsqlName getSQLJSchemaHsqlName() {
        return SqlInvariants.SQLJ_SCHEMA_HSQLNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPublicSchema() {
        this.writeLock.lock();
        try {
            HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(null, "PUBLIC", 2);
            Schema schema = new Schema(name, this.database.getGranteeManager().getDBARole());
            this.defaultSchemaHsqlName = schema.getName();
            this.schemaMap.put(schema.getName().name, schema);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(HsqlNameManager.HsqlName name, Grantee owner) {
        this.writeLock.lock();
        try {
            SqlInvariants.checkSchemaNameNotSystem(name.name);
            Schema schema = new Schema(name, owner);
            this.schemaMap.add(name.name, schema);
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema(Session session, String name, boolean cascade) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(5501, name);
            }
            if (SqlInvariants.isLobsSchemaName(name)) {
                throw Error.error(5503, name);
            }
            if (!cascade && !schema.isEmpty()) {
                throw Error.error(4200);
            }
            OrderedHashSet externalReferences = new OrderedHashSet();
            this.getCascadingSchemaReferences(schema.getName(), externalReferences);
            this.removeSchemaObjects(externalReferences);
            Iterator tableIterator = schema.schemaObjectIterator(3);
            while (tableIterator.hasNext()) {
                Table table = (Table)tableIterator.next();
                Constraint[] list = table.getFKConstraints();
                for (int i = 0; i < list.length; ++i) {
                    Constraint constraint = list[i];
                    if (constraint.getMain().getSchemaName() == schema.getName()) continue;
                    constraint.getMain().removeConstraint(constraint.getMainName().name);
                }
                this.removeTable(session, table);
            }
            Iterator sequenceIterator = schema.schemaObjectIterator(7);
            while (sequenceIterator.hasNext()) {
                NumberSequence sequence = (NumberSequence)sequenceIterator.next();
                this.database.getGranteeManager().removeDbObject(sequence.getName());
            }
            schema.clearStructures();
            this.schemaMap.remove(name);
            if (this.defaultSchemaHsqlName.name.equals(name)) {
                HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(name, false, 2);
                schema = new Schema(hsqlName, this.database.getGranteeManager().getDBARole());
                this.defaultSchemaHsqlName = schema.getName();
                this.schemaMap.put(schema.getName().name, schema);
            }
            this.database.getUserManager().removeSchemaReference(name);
            this.database.getSessionManager().removeSchemaReference(schema);
            Object var12_11 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchema(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName newName) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.name);
            Schema exists = (Schema)this.schemaMap.get(newName.name);
            if (schema == null) {
                throw Error.error(5501, name.name);
            }
            if (exists != null) {
                throw Error.error(5504, newName.name);
            }
            SqlInvariants.checkSchemaNameNotSystem(name.name);
            SqlInvariants.checkSchemaNameNotSystem(newName.name);
            int index = this.schemaMap.getIndex(name.name);
            schema.getName().rename(newName);
            this.schemaMap.set(index, newName.name, schema);
            Object var7_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStructures() {
        this.writeLock.lock();
        try {
            Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                schema.clearStructures();
            }
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSchemaNamesArray() {
        this.readLock.lock();
        try {
            Object[] array = new String[this.schemaMap.size()];
            this.schemaMap.toKeysArray(array);
            Object[] objectArray = array;
            Object var4_3 = null;
            this.readLock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema[] getAllSchemas() {
        this.readLock.lock();
        try {
            Object[] objects = new Schema[this.schemaMap.size()];
            this.schemaMap.toValuesArray(objects);
            Object[] objectArray = objects;
            Object var4_3 = null;
            this.readLock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getUserSchemaHsqlName(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(4850, name);
            }
            if (schema.getName() == SqlInvariants.INFORMATION_SCHEMA_HSQLNAME) {
                throw Error.error(4850, name);
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            Object var5_4 = null;
            this.readLock.unlock();
            return hsqlName;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grantee toSchemaOwner(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            Grantee grantee = schema == null ? null : schema.getOwner();
            Object var5_4 = null;
            this.readLock.unlock();
            return grantee;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public HsqlNameManager.HsqlName getDefaultSchemaHsqlName() {
        return this.defaultSchemaHsqlName;
    }

    public void setDefaultSchemaHsqlName(HsqlNameManager.HsqlName name) {
        this.defaultSchemaHsqlName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schemaExists(String name) {
        this.readLock.lock();
        try {
            boolean bl = this.schemaMap.containsKey(name);
            Object var4_3 = null;
            this.readLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName findSchemaHsqlName(String name) {
        Schema schema;
        block3: {
            this.readLock.lock();
            try {
                schema = (Schema)this.schemaMap.get(name);
                if (schema != null) break block3;
                HsqlNameManager.HsqlName hsqlName = null;
                Object var5_5 = null;
                this.readLock.unlock();
                return hsqlName;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        HsqlNameManager.HsqlName hsqlName = schema.getName();
        Object var5_6 = null;
        this.readLock.unlock();
        return hsqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getSchemaHsqlName(String name) {
        if (name == null) {
            return this.defaultSchemaHsqlName;
        }
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(4850, name);
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            Object var5_4 = null;
            this.readLock.unlock();
            return hsqlName;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public String getSchemaName(String name) {
        return this.getSchemaHsqlName((String)name).name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema findSchema(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            Object var4_3 = null;
            this.readLock.unlock();
            return schema;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchemas(Session session, Grantee grantee, boolean cascade) {
        this.writeLock.lock();
        try {
            HsqlArrayList list = this.getSchemas(grantee);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                this.dropSchema(session, schema.getName().name, cascade);
            }
            Object var8_7 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList getSchemas(Grantee grantee) {
        this.readLock.lock();
        try {
            HsqlArrayList list = new HsqlArrayList();
            Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                if (!grantee.equals(schema.getOwner())) continue;
                list.add(schema);
            }
            HsqlArrayList hsqlArrayList = list;
            Object var6_5 = null;
            this.readLock.unlock();
            return hsqlArrayList;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSchemas(Grantee grantee) {
        boolean bl;
        this.readLock.lock();
        try {
            Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                if (!grantee.equals(schema.getOwner())) continue;
                boolean bl2 = true;
                Object var6_6 = null;
                this.readLock.unlock();
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.readLock.unlock();
            throw throwable;
        }
        Object var6_7 = null;
        this.readLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList getAllTables(boolean withLobTables) {
        this.readLock.lock();
        try {
            HsqlArrayList alltables = new HsqlArrayList();
            String[] schemas = this.getSchemaNamesArray();
            for (int i = 0; i < schemas.length; ++i) {
                String name = schemas[i];
                if (!withLobTables && SqlInvariants.isLobsSchemaName(name) || SqlInvariants.isSystemSchemaName(name)) continue;
                HashMappedList current = this.getTables(name);
                alltables.addAll(current.values());
            }
            HsqlArrayList hsqlArrayList = alltables;
            Object var8_8 = null;
            this.readLock.unlock();
            return hsqlArrayList;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMappedList getTables(String schema) {
        this.readLock.lock();
        try {
            Schema temp = (Schema)this.schemaMap.get(schema);
            HashMappedList hashMappedList = temp.tableList;
            Object var5_4 = null;
            this.readLock.unlock();
            return hashMappedList;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public HsqlNameManager.HsqlName[] getCatalogNameArray() {
        return this.catalogNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName[] getCatalogAndBaseTableNames() {
        this.readLock.lock();
        try {
            OrderedHashSet names = new OrderedHashSet();
            HsqlArrayList tables = this.getAllTables(false);
            for (int i = 0; i < tables.size(); ++i) {
                Table table = (Table)tables.get(i);
                if (table.isTemp()) continue;
                names.add(table.getName());
            }
            names.add(this.database.getCatalogName());
            Object[] array = new HsqlNameManager.HsqlName[names.size()];
            names.toArray(array);
            Object[] objectArray = array;
            Object var6_6 = null;
            this.readLock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaObjectSet getSchemaObjectSet(Schema schema, int type) {
        this.readLock.lock();
        try {
            SchemaObjectSet set = null;
            switch (type) {
                case 7: {
                    set = schema.sequenceLookup;
                    break;
                }
                case 3: 
                case 4: {
                    set = schema.tableLookup;
                    break;
                }
                case 14: {
                    set = schema.charsetLookup;
                    break;
                }
                case 15: {
                    set = schema.collationLookup;
                    break;
                }
                case 17: {
                    set = schema.procedureLookup;
                    break;
                }
                case 16: {
                    set = schema.functionLookup;
                    break;
                }
                case 12: 
                case 13: {
                    set = schema.typeLookup;
                    break;
                }
                case 20: {
                    set = schema.indexLookup;
                    break;
                }
                case 5: {
                    set = schema.constraintLookup;
                    break;
                }
                case 8: {
                    set = schema.triggerLookup;
                    break;
                }
                case 24: {
                    set = schema.specificRoutineLookup;
                }
            }
            SchemaObjectSet schemaObjectSet = set;
            Object var6_5 = null;
            this.readLock.unlock();
            return schemaObjectSet;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchemaObjectNotExists(HsqlNameManager.HsqlName name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
            set.checkAdd(name);
            Object var5_4 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Table getTable(Session session, String name, String schema) {
        Table table;
        block10: {
            Table table2;
            block9: {
                this.readLock.lock();
                try {
                    Table t = null;
                    if ("MODULE".equals(schema)) {
                        t = this.findSessionTable(session, name);
                        if (t == null) {
                            throw Error.error(5501, name);
                        }
                        Table table3 = t;
                        Object var7_8 = null;
                        this.readLock.unlock();
                        return table3;
                    }
                    if (schema == null) {
                        if (session.database.sqlSyntaxOra && "DUAL".equals(name)) {
                            table2 = this.dualTable;
                            break block9;
                        }
                        t = this.findSessionTable(session, name);
                    }
                    if (t == null) {
                        schema = session.getSchemaName(schema);
                        t = this.findUserTable(session, name, schema);
                    }
                    if (t == null && "INFORMATION_SCHEMA".equals(schema) && this.database.dbInfo != null) {
                        t = this.database.dbInfo.getSystemTable(session, name);
                    }
                    if (t == null) {
                        throw Error.error(5501, name);
                    }
                    table = t;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.readLock.unlock();
                    throw throwable;
                }
            }
            Object var7_9 = null;
            this.readLock.unlock();
            return table2;
        }
        Object var7_10 = null;
        this.readLock.unlock();
        return table;
    }

    public Table getUserTable(Session session, HsqlNameManager.HsqlName name) {
        return this.getUserTable(session, name.name, name.schema.name);
    }

    public Table getUserTable(Session session, String name, String schema) {
        Table t = this.findUserTable(session, name, schema);
        if (t == null) {
            throw Error.error(5501, name);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table findUserTable(Session session, String name, String schemaName) {
        int i;
        Schema schema;
        block5: {
            block4: {
                this.readLock.lock();
                try {
                    schema = (Schema)this.schemaMap.get(schemaName);
                    if (schema != null) break block4;
                    Table table = null;
                    Object var8_7 = null;
                    this.readLock.unlock();
                    return table;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.readLock.unlock();
                    throw throwable;
                }
            }
            i = schema.tableList.getIndex(name);
            if (i != -1) break block5;
            Table table = null;
            Object var8_8 = null;
            this.readLock.unlock();
            return table;
        }
        Table table = (Table)schema.tableList.get(i);
        Object var8_9 = null;
        this.readLock.unlock();
        return table;
    }

    public Table findSessionTable(Session session, String name) {
        return session.sessionContext.findSessionTable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTableOrView(Session session, Table table, boolean cascade) {
        this.writeLock.lock();
        try {
            if (table.isView()) {
                this.removeSchemaObject(table.getName(), cascade);
            } else {
                this.dropTable(session, table, cascade);
            }
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    private void dropTable(Session session, Table table, boolean cascade) {
        int i;
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        int dropIndex = schema.tableList.getIndex(table.getName().name);
        OrderedHashSet externalConstraints = table.getDependentExternalConstraints();
        OrderedHashSet externalReferences = new OrderedHashSet();
        this.getCascadingReferencingObjectNames(table.getName(), externalReferences);
        if (!cascade) {
            int i2;
            for (i2 = 0; i2 < externalConstraints.size(); ++i2) {
                Constraint c = (Constraint)externalConstraints.get(i2);
                HsqlNameManager.HsqlName tablename = c.getRef().getName();
                HsqlNameManager.HsqlName refname = c.getRefName();
                if (c.getConstraintType() != 1) continue;
                throw Error.error(5533, refname.schema.name + '.' + tablename.name + '.' + refname.name);
            }
            if (!externalReferences.isEmpty()) {
                for (i2 = 0; i2 < externalReferences.size(); ++i2) {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)externalReferences.get(i2);
                    if (name.parent == table.getName()) continue;
                    throw Error.error(5502, name.getSchemaQualifiedStatementName());
                }
            }
        }
        OrderedHashSet tableSet = new OrderedHashSet();
        OrderedHashSet constraintNameSet = new OrderedHashSet();
        OrderedHashSet indexNameSet = new OrderedHashSet();
        OrderedHashSet childReferences = table.getReferences();
        TriggerDef[] triggers = table.getTriggers();
        for (i = 0; i < triggers.length; ++i) {
            childReferences.add(triggers[i].getName());
        }
        for (i = 0; i < externalConstraints.size(); ++i) {
            Constraint c = (Constraint)externalConstraints.get(i);
            Table t = c.getMain();
            if (t != table) {
                tableSet.add(t);
            }
            if ((t = c.getRef()) != table) {
                tableSet.add(t);
            }
            constraintNameSet.add(c.getMainName());
            constraintNameSet.add(c.getRefName());
            indexNameSet.add(c.getRefIndex().getName());
        }
        TableWorks tw = new TableWorks(session, table);
        tableSet = tw.makeNewTables(tableSet, constraintNameSet, indexNameSet);
        tw.setNewTablesInSchema(tableSet);
        tw.updateConstraints(tableSet, constraintNameSet);
        this.removeSchemaObjects(externalReferences);
        this.removeSchemaObjects(childReferences);
        this.removeReferencedObject(table.getName());
        this.removeReferencingObject(table);
        schema.tableList.remove(dropIndex);
        schema.indexLookup.removeParent(table.getName());
        schema.constraintLookup.removeParent(table.getName());
        this.removeTable(session, table);
        this.recompileDependentObjects(tableSet);
    }

    private void removeTable(Session session, Table table) {
        this.database.getGranteeManager().removeDbObject(table.getName());
        table.releaseTriggers();
        if (table.hasLobColumn()) {
            RowIterator it = table.rowIterator(session);
            while (it.hasNext()) {
                Row row = it.getNextRow();
                Object[] data = row.getData();
                session.sessionData.adjustLobUsageCount(table, data, -1);
            }
        }
        this.database.persistentStoreCollection.releaseStore(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(int index, Table table) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
            schema.tableList.set(index, table.getName().name, table);
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTableIndex(Table table) {
        Schema schema;
        block3: {
            this.readLock.lock();
            try {
                schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
                if (schema != null) break block3;
                int n = -1;
                Object var6_5 = null;
                this.readLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        HsqlNameManager.HsqlName name = table.getName();
        int n = schema.tableList.getIndex(name.name);
        Object var6_6 = null;
        this.readLock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(OrderedHashSet tableSet) {
        this.writeLock.lock();
        try {
            OrderedHashSet set = new OrderedHashSet();
            for (int i = 0; i < tableSet.size(); ++i) {
                Table table = (Table)tableSet.get(i);
                set.addAll(this.getReferencingObjectNames(table.getName()));
            }
            Session session = this.database.sessionManager.getSysSession();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
                switch (name.type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        SchemaObject object = this.getSchemaObject(name);
                        object.compile(session, null);
                    }
                }
            }
            Object var8_9 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(Table table) {
        this.writeLock.lock();
        try {
            OrderedHashSet set = new OrderedHashSet();
            this.getCascadingReferencingObjectNames(table.getName(), set);
            Session session = this.database.sessionManager.getSysSession();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
                switch (name.type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        SchemaObject object = this.getSchemaObject(name);
                        object.compile(session, null);
                    }
                }
            }
            HsqlArrayList list = this.getAllTables(false);
            for (int i = 0; i < list.size(); ++i) {
                Table t = (Table)list.get(i);
                t.verifyConstraintsIntegrity();
            }
            Object var8_9 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberSequence getSequence(String name, String schemaName, boolean raise) {
        block4: {
            this.readLock.lock();
            try {
                NumberSequence object;
                Schema schema = (Schema)this.schemaMap.get(schemaName);
                if (schema == null || (object = (NumberSequence)schema.sequenceList.get(name)) == null) break block4;
                NumberSequence numberSequence = object;
                Object var8_7 = null;
                this.readLock.unlock();
                return numberSequence;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (raise) {
            throw Error.error(5501, name);
        }
        NumberSequence numberSequence = null;
        Object var8_8 = null;
        this.readLock.unlock();
        return numberSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getUserDefinedType(String name, String schemaName, boolean raise) {
        block4: {
            this.readLock.lock();
            try {
                SchemaObject object;
                Schema schema = (Schema)this.schemaMap.get(schemaName);
                if (schema == null || (object = schema.typeLookup.getObject(name)) == null) break block4;
                Type type = (Type)object;
                Object var8_7 = null;
                this.readLock.unlock();
                return type;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (raise) {
            throw Error.error(5501, name);
        }
        Type type = null;
        Object var8_8 = null;
        this.readLock.unlock();
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDomainOrUDT(String name, String schemaName, boolean raise) {
        block4: {
            this.readLock.lock();
            try {
                SchemaObject object;
                Schema schema = (Schema)this.schemaMap.get(schemaName);
                if (schema == null || (object = schema.typeLookup.getObject(name)) == null) break block4;
                Type type = (Type)object;
                Object var8_7 = null;
                this.readLock.unlock();
                return type;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (raise) {
            throw Error.error(5501, name);
        }
        Type type = null;
        Object var8_8 = null;
        this.readLock.unlock();
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDomain(String name, String schemaName, boolean raise) {
        block4: {
            this.readLock.lock();
            try {
                SchemaObject object;
                Schema schema = (Schema)this.schemaMap.get(schemaName);
                if (schema == null || (object = schema.typeLookup.getObject(name)) == null || !((Type)object).isDomainType()) break block4;
                Type type = (Type)object;
                Object var8_7 = null;
                this.readLock.unlock();
                return type;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (raise) {
            throw Error.error(5501, name);
        }
        Type type = null;
        Object var8_8 = null;
        this.readLock.unlock();
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDistinctType(String name, String schemaName, boolean raise) {
        block4: {
            this.readLock.lock();
            try {
                SchemaObject object;
                Schema schema = (Schema)this.schemaMap.get(schemaName);
                if (schema == null || (object = schema.typeLookup.getObject(name)) == null || !((Type)object).isDistinctType()) break block4;
                Type type = (Type)object;
                Object var8_7 = null;
                this.readLock.unlock();
                return type;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (raise) {
            throw Error.error(5501, name);
        }
        Type type = null;
        Object var8_8 = null;
        this.readLock.unlock();
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject getSchemaObject(String name, String schemaName, int type) {
        this.readLock.lock();
        try {
            SchemaObject object = this.findSchemaObject(name, schemaName, type);
            if (object == null) {
                throw Error.error(SchemaObjectSet.getGetErrorCode(type), name);
            }
            SchemaObject schemaObject = object;
            Object var7_6 = null;
            this.readLock.unlock();
            return schemaObject;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SchemaObject findSchemaObject(String name, String schemaName, int type) {
        TriggerDef triggerDef;
        block45: {
            SchemaObject schemaObject;
            block44: {
                Constraint constraint;
                block43: {
                    SchemaObject schemaObject2;
                    block42: {
                        SchemaObject schemaObject3;
                        block41: {
                            Index index;
                            block40: {
                                SchemaObject schemaObject4;
                                block39: {
                                    SchemaObject schemaObject5;
                                    block38: {
                                        SchemaObject schemaObject6;
                                        block37: {
                                            SchemaObject schemaObject7;
                                            block36: {
                                                SchemaObject schemaObject8;
                                                block35: {
                                                    SchemaObject schemaObject9;
                                                    block34: {
                                                        SchemaObject schemaObject10;
                                                        block33: {
                                                            SchemaObject schemaObject11;
                                                            block32: {
                                                                Charset charset;
                                                                block31: {
                                                                    Charset charset2;
                                                                    block30: {
                                                                        Charset charset3;
                                                                        block29: {
                                                                            Charset charset4;
                                                                            block28: {
                                                                                SchemaObject schemaObject12;
                                                                                block27: {
                                                                                    SchemaObject schemaObject13;
                                                                                    this.readLock.lock();
                                                                                    try {
                                                                                        Schema schema = (Schema)this.schemaMap.get(schemaName);
                                                                                        if (schema == null) {
                                                                                            SchemaObject schemaObject14 = null;
                                                                                            Object var11_7 = null;
                                                                                            this.readLock.unlock();
                                                                                            return schemaObject14;
                                                                                        }
                                                                                        SchemaObjectSet set = null;
                                                                                        switch (type) {
                                                                                            case 7: {
                                                                                                schemaObject13 = schema.sequenceLookup.getObject(name);
                                                                                                break;
                                                                                            }
                                                                                            case 3: 
                                                                                            case 4: {
                                                                                                schemaObject12 = schema.tableLookup.getObject(name);
                                                                                                break block27;
                                                                                            }
                                                                                            case 14: {
                                                                                                if (name.equals("SQL_IDENTIFIER")) {
                                                                                                    charset4 = TypeInvariants.SQL_IDENTIFIER_CHARSET;
                                                                                                    break block28;
                                                                                                }
                                                                                                if (name.equals("SQL_TEXT")) {
                                                                                                    charset3 = TypeInvariants.SQL_TEXT;
                                                                                                    break block29;
                                                                                                }
                                                                                                if (name.equals("LATIN1")) {
                                                                                                    charset2 = TypeInvariants.LATIN1;
                                                                                                    break block30;
                                                                                                }
                                                                                                if (name.equals("ASCII_GRAPHIC")) {
                                                                                                    charset = TypeInvariants.ASCII_GRAPHIC;
                                                                                                    break block31;
                                                                                                }
                                                                                                schemaObject11 = schema.charsetLookup.getObject(name);
                                                                                                break block32;
                                                                                            }
                                                                                            case 15: {
                                                                                                schemaObject10 = schema.collationLookup.getObject(name);
                                                                                                break block33;
                                                                                            }
                                                                                            case 17: {
                                                                                                schemaObject9 = schema.procedureLookup.getObject(name);
                                                                                                break block34;
                                                                                            }
                                                                                            case 16: {
                                                                                                schemaObject8 = schema.functionLookup.getObject(name);
                                                                                                break block35;
                                                                                            }
                                                                                            case 18: {
                                                                                                SchemaObject object = schema.procedureLookup.getObject(name);
                                                                                                if (object == null) {
                                                                                                    object = schema.functionLookup.getObject(name);
                                                                                                }
                                                                                                schemaObject7 = object;
                                                                                                break block36;
                                                                                            }
                                                                                            case 24: {
                                                                                                schemaObject6 = schema.specificRoutineLookup.getObject(name);
                                                                                                break block37;
                                                                                            }
                                                                                            case 12: 
                                                                                            case 13: {
                                                                                                schemaObject5 = schema.typeLookup.getObject(name);
                                                                                                break block38;
                                                                                            }
                                                                                            case 20: {
                                                                                                set = schema.indexLookup;
                                                                                                HsqlNameManager.HsqlName objectName = set.getName(name);
                                                                                                if (objectName == null) {
                                                                                                    schemaObject4 = null;
                                                                                                    break block39;
                                                                                                }
                                                                                                Table table = (Table)schema.tableList.get(objectName.parent.name);
                                                                                                index = table.getIndex(name);
                                                                                                break block40;
                                                                                            }
                                                                                            case 5: {
                                                                                                set = schema.constraintLookup;
                                                                                                HsqlNameManager.HsqlName objectName = set.getName(name);
                                                                                                if (objectName == null) {
                                                                                                    schemaObject3 = null;
                                                                                                    break block41;
                                                                                                }
                                                                                                Table table = (Table)schema.tableList.get(objectName.parent.name);
                                                                                                if (table == null) {
                                                                                                    schemaObject2 = null;
                                                                                                    break block42;
                                                                                                }
                                                                                                constraint = table.getConstraint(name);
                                                                                                break block43;
                                                                                            }
                                                                                            case 8: {
                                                                                                set = schema.indexLookup;
                                                                                                HsqlNameManager.HsqlName objectName = set.getName(name);
                                                                                                if (objectName == null) {
                                                                                                    schemaObject = null;
                                                                                                    break block44;
                                                                                                }
                                                                                                Table table = (Table)schema.tableList.get(objectName.parent.name);
                                                                                                triggerDef = table.getTrigger(name);
                                                                                                break block45;
                                                                                            }
                                                                                            default: {
                                                                                                throw Error.runtimeError(201, "SchemaManager");
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    catch (Throwable throwable) {
                                                                                        Object var11_28 = null;
                                                                                        this.readLock.unlock();
                                                                                        throw throwable;
                                                                                    }
                                                                                    Object var11_8 = null;
                                                                                    this.readLock.unlock();
                                                                                    return schemaObject13;
                                                                                }
                                                                                Object var11_9 = null;
                                                                                this.readLock.unlock();
                                                                                return schemaObject12;
                                                                            }
                                                                            Object var11_10 = null;
                                                                            this.readLock.unlock();
                                                                            return charset4;
                                                                        }
                                                                        Object var11_11 = null;
                                                                        this.readLock.unlock();
                                                                        return charset3;
                                                                    }
                                                                    Object var11_12 = null;
                                                                    this.readLock.unlock();
                                                                    return charset2;
                                                                }
                                                                Object var11_13 = null;
                                                                this.readLock.unlock();
                                                                return charset;
                                                            }
                                                            Object var11_14 = null;
                                                            this.readLock.unlock();
                                                            return schemaObject11;
                                                        }
                                                        Object var11_15 = null;
                                                        this.readLock.unlock();
                                                        return schemaObject10;
                                                    }
                                                    Object var11_16 = null;
                                                    this.readLock.unlock();
                                                    return schemaObject9;
                                                }
                                                Object var11_17 = null;
                                                this.readLock.unlock();
                                                return schemaObject8;
                                            }
                                            Object var11_18 = null;
                                            this.readLock.unlock();
                                            return schemaObject7;
                                        }
                                        Object var11_19 = null;
                                        this.readLock.unlock();
                                        return schemaObject6;
                                    }
                                    Object var11_20 = null;
                                    this.readLock.unlock();
                                    return schemaObject5;
                                }
                                Object var11_21 = null;
                                this.readLock.unlock();
                                return schemaObject4;
                            }
                            Object var11_22 = null;
                            this.readLock.unlock();
                            return index;
                        }
                        Object var11_23 = null;
                        this.readLock.unlock();
                        return schemaObject3;
                    }
                    Object var11_24 = null;
                    this.readLock.unlock();
                    return schemaObject2;
                }
                Object var11_25 = null;
                this.readLock.unlock();
                return constraint;
            }
            Object var11_26 = null;
            this.readLock.unlock();
            return schemaObject;
        }
        Object var11_27 = null;
        this.readLock.unlock();
        return triggerDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Table findUserTableForIndex(Session session, String name, String schemaName) {
        HsqlNameManager.HsqlName indexName;
        block3: {
            this.readLock.lock();
            try {
                Schema schema = (Schema)this.schemaMap.get(schemaName);
                indexName = schema.indexLookup.getName(name);
                if (indexName != null) break block3;
                Table table = null;
                Object var8_8 = null;
                this.readLock.unlock();
                return table;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        Table table = this.findUserTable(session, indexName.parent.name, schemaName);
        Object var8_9 = null;
        this.readLock.unlock();
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropIndex(Session session, HsqlNameManager.HsqlName name) {
        this.writeLock.lock();
        try {
            Table t = this.getTable(session, name.parent.name, name.parent.schema.name);
            TableWorks tw = new TableWorks(session, t);
            tw.dropIndex(name.name);
            Object var6_5 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropConstraint(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        this.writeLock.lock();
        try {
            Table t = this.getTable(session, name.parent.name, name.parent.schema.name);
            TableWorks tw = new TableWorks(session, t);
            tw.dropConstraint(name.name, cascade);
            Object var7_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDependentObjects(HsqlNameManager.HsqlName name) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            schema.indexLookup.removeParent(name);
            schema.constraintLookup.removeParent(name);
            schema.triggerLookup.removeParent(name);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExportedKeys(Table toDrop) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(toDrop.getSchemaName().name);
            for (int i = 0; i < schema.tableList.size(); ++i) {
                Table table = (Table)schema.tableList.get(i);
                Constraint[] constraints = table.getConstraints();
                for (int j = constraints.length - 1; j >= 0; --j) {
                    Table refTable = constraints[j].getRef();
                    if (toDrop != refTable) continue;
                    table.removeConstraint(j);
                }
            }
            Object var9_8 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public Iterator databaseObjectIterator(String schemaName, int type) {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        return schema.schemaObjectIterator(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator databaseObjectIterator(int type) {
        this.readLock.lock();
        try {
            Iterator it = this.schemaMap.values().iterator();
            WrapperIterator objects = new WrapperIterator();
            while (it.hasNext()) {
                int targetType = type;
                if (type == 18) {
                    targetType = 16;
                }
                Schema temp = (Schema)it.next();
                SchemaObjectSet set = temp.getObjectSet(targetType);
                Object[] values = new Object[set.map.size()];
                set.map.valuesToArray(values);
                objects = new WrapperIterator(objects, new WrapperIterator(values));
                if (type != 18) continue;
                set = temp.getObjectSet(17);
                values = new Object[set.map.size()];
                set.map.valuesToArray(values);
                objects = new WrapperIterator(objects, new WrapperIterator(values));
            }
            WrapperIterator wrapperIterator = objects;
            Object var9_9 = null;
            this.readLock.unlock();
            return wrapperIterator;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    private void addReferences(SchemaObject object) {
        OrderedHashSet set = object.getReferences();
        if (set == null) {
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName referenced = (HsqlNameManager.HsqlName)set.get(i);
            HsqlNameManager.HsqlName name = object.getName();
            if (object instanceof Routine) {
                name = ((Routine)object).getSpecificName();
            }
            this.referenceMap.put(referenced, name);
        }
    }

    private void removeReferencedObject(HsqlNameManager.HsqlName referenced) {
        this.referenceMap.remove(referenced);
    }

    private void removeReferencingObject(SchemaObject object) {
        OrderedHashSet set = object.getReferences();
        if (set == null) {
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName referenced = (HsqlNameManager.HsqlName)set.get(i);
            HsqlNameManager.HsqlName name = object.getName();
            if (object instanceof Routine) {
                name = ((Routine)object).getSpecificName();
            }
            this.referenceMap.remove(referenced, name);
            if (name.parent == null) continue;
            this.referenceMap.remove(referenced, name.parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet getReferencingObjectNames(HsqlNameManager.HsqlName object) {
        this.readLock.lock();
        try {
            OrderedHashSet set = new OrderedHashSet();
            Iterator it = this.referenceMap.get(object);
            while (it.hasNext()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
                set.add(name);
            }
            OrderedHashSet orderedHashSet = set;
            Object var6_5 = null;
            this.readLock.unlock();
            return orderedHashSet;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet getReferencingObjectNames(HsqlNameManager.HsqlName table, HsqlNameManager.HsqlName column) {
        this.readLock.lock();
        try {
            OrderedHashSet set = new OrderedHashSet();
            Iterator it = this.referenceMap.get(table);
            while (it.hasNext()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
                SchemaObject object = this.getSchemaObject(name);
                OrderedHashSet references = object.getReferences();
                if (!references.contains(column)) continue;
                set.add(name);
            }
            OrderedHashSet orderedHashSet = set;
            Object var9_8 = null;
            this.readLock.unlock();
            return orderedHashSet;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReferenced(HsqlNameManager.HsqlName object) {
        this.writeLock.lock();
        try {
            boolean bl = this.referenceMap.containsKey(object);
            Object var4_3 = null;
            this.writeLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCascadingReferencingObjectNames(HsqlNameManager.HsqlName object, OrderedHashSet set) {
        this.readLock.lock();
        try {
            OrderedHashSet newSet = new OrderedHashSet();
            Iterator it = this.referenceMap.get(object);
            while (it.hasNext()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
                boolean added = set.add(name);
                if (!added) continue;
                newSet.add(name);
            }
            for (int i = 0; i < newSet.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)newSet.get(i);
                this.getCascadingReferencingObjectNames(name, set);
            }
            Object var8_9 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    private void getCascadingSchemaReferences(HsqlNameManager.HsqlName schema, OrderedHashSet set) {
        Iterator mainIterator = this.referenceMap.keySet().iterator();
        while (mainIterator.hasNext()) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)mainIterator.next();
            if (name.schema != schema) continue;
            this.getCascadingReferencingObjectNames(name, set);
        }
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            if (name.schema != schema) continue;
            set.remove(i);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getSchemaObjectName(HsqlNameManager.HsqlName schemaName, String name, int type, boolean raise) {
        SchemaObjectSet set;
        Schema schema;
        block8: {
            this.readLock.lock();
            try {
                schema = (Schema)this.schemaMap.get(schemaName.name);
                set = null;
                if (schema != null) break block8;
                if (raise) {
                    throw Error.error(SchemaObjectSet.getGetErrorCode(type));
                }
                HsqlNameManager.HsqlName hsqlName = null;
                Object var9_9 = null;
                this.readLock.unlock();
                return hsqlName;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (type == 18) {
            set = schema.functionLookup;
            SchemaObject object = schema.functionLookup.getObject(name);
            if (object == null) {
                set = schema.procedureLookup;
                object = schema.procedureLookup.getObject(name);
            }
        } else {
            set = this.getSchemaObjectSet(schema, type);
        }
        if (raise) {
            set.checkExists(name);
        }
        HsqlNameManager.HsqlName hsqlName = set.getName(name);
        Object var9_10 = null;
        this.readLock.unlock();
        return hsqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SchemaObject getSchemaObject(HsqlNameManager.HsqlName name) {
        SchemaObject schemaObject;
        block38: {
            Index index;
            block37: {
                SchemaObject tableName22;
                block36: {
                    SchemaObject tableName22;
                    block35: {
                        Constraint constraint;
                        block34: {
                            SchemaObject tableName32;
                            block33: {
                                TriggerDef triggerDef;
                                block32: {
                                    SchemaObject schemaObject2;
                                    block31: {
                                        SchemaObject schemaObject3;
                                        block30: {
                                            SchemaObject schemaObject4;
                                            block29: {
                                                SchemaObject schemaObject5;
                                                block28: {
                                                    SchemaObject schemaObject6;
                                                    block27: {
                                                        SchemaObject schemaObject7;
                                                        block26: {
                                                            SchemaObject schemaObject8;
                                                            block25: {
                                                                SchemaObject schemaObject9;
                                                                block24: {
                                                                    SchemaObject schemaObject10;
                                                                    block23: {
                                                                        SchemaObject schemaObject11;
                                                                        block22: {
                                                                            this.readLock.lock();
                                                                            try {
                                                                                Schema schema = (Schema)this.schemaMap.get(name.schema.name);
                                                                                if (schema == null) {
                                                                                    SchemaObject schemaObject12 = null;
                                                                                    Object var8_13 = null;
                                                                                    this.readLock.unlock();
                                                                                    return schemaObject12;
                                                                                }
                                                                                switch (name.type) {
                                                                                    case 7: {
                                                                                        schemaObject11 = (SchemaObject)schema.sequenceList.get(name.name);
                                                                                        break block22;
                                                                                    }
                                                                                    case 3: 
                                                                                    case 4: {
                                                                                        schemaObject10 = (SchemaObject)schema.tableList.get(name.name);
                                                                                        break block23;
                                                                                    }
                                                                                    case 14: {
                                                                                        schemaObject9 = schema.charsetLookup.getObject(name.name);
                                                                                        break block24;
                                                                                    }
                                                                                    case 15: {
                                                                                        schemaObject8 = schema.collationLookup.getObject(name.name);
                                                                                        break block25;
                                                                                    }
                                                                                    case 17: {
                                                                                        schemaObject7 = schema.procedureLookup.getObject(name.name);
                                                                                        break block26;
                                                                                    }
                                                                                    case 16: {
                                                                                        schemaObject6 = schema.functionLookup.getObject(name.name);
                                                                                        break block27;
                                                                                    }
                                                                                    case 24: {
                                                                                        schemaObject5 = schema.specificRoutineLookup.getObject(name.name);
                                                                                        break block28;
                                                                                    }
                                                                                    case 18: {
                                                                                        SchemaObject object = schema.functionLookup.getObject(name.name);
                                                                                        if (object == null) {
                                                                                            object = schema.procedureLookup.getObject(name.name);
                                                                                        }
                                                                                        schemaObject4 = object;
                                                                                        break block29;
                                                                                    }
                                                                                    case 12: 
                                                                                    case 13: {
                                                                                        schemaObject3 = schema.typeLookup.getObject(name.name);
                                                                                        break block30;
                                                                                    }
                                                                                    case 8: {
                                                                                        name = schema.triggerLookup.getName(name.name);
                                                                                        if (name == null) {
                                                                                            schemaObject2 = null;
                                                                                            break block31;
                                                                                        }
                                                                                        HsqlNameManager.HsqlName tableName32 = name.parent;
                                                                                        Table table = (Table)schema.tableList.get(tableName32.name);
                                                                                        triggerDef = table.getTrigger(name.name);
                                                                                        break block32;
                                                                                    }
                                                                                    case 5: {
                                                                                        name = schema.constraintLookup.getName(name.name);
                                                                                        if (name == null) {
                                                                                            tableName32 = null;
                                                                                            break block33;
                                                                                        }
                                                                                        HsqlNameManager.HsqlName tableName22 = name.parent;
                                                                                        Table table = (Table)schema.tableList.get(tableName22.name);
                                                                                        constraint = table.getConstraint(name.name);
                                                                                        break block34;
                                                                                    }
                                                                                    case 6: {
                                                                                        tableName22 = null;
                                                                                        break block35;
                                                                                    }
                                                                                    case 20: {
                                                                                        name = schema.indexLookup.getName(name.name);
                                                                                        if (name == null) {
                                                                                            tableName22 = null;
                                                                                            break block36;
                                                                                        }
                                                                                        HsqlNameManager.HsqlName tableName4 = name.parent;
                                                                                        Table table = (Table)schema.tableList.get(tableName4.name);
                                                                                        index = table.getIndex(name.name);
                                                                                        break block37;
                                                                                    }
                                                                                    default: {
                                                                                        schemaObject = null;
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break block38;
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                Object var8_31 = null;
                                                                                this.readLock.unlock();
                                                                                throw throwable;
                                                                            }
                                                                        }
                                                                        Object var8_14 = null;
                                                                        this.readLock.unlock();
                                                                        return schemaObject11;
                                                                    }
                                                                    Object var8_15 = null;
                                                                    this.readLock.unlock();
                                                                    return schemaObject10;
                                                                }
                                                                Object var8_16 = null;
                                                                this.readLock.unlock();
                                                                return schemaObject9;
                                                            }
                                                            Object var8_17 = null;
                                                            this.readLock.unlock();
                                                            return schemaObject8;
                                                        }
                                                        Object var8_18 = null;
                                                        this.readLock.unlock();
                                                        return schemaObject7;
                                                    }
                                                    Object var8_19 = null;
                                                    this.readLock.unlock();
                                                    return schemaObject6;
                                                }
                                                Object var8_20 = null;
                                                this.readLock.unlock();
                                                return schemaObject5;
                                            }
                                            Object var8_21 = null;
                                            this.readLock.unlock();
                                            return schemaObject4;
                                        }
                                        Object var8_22 = null;
                                        this.readLock.unlock();
                                        return schemaObject3;
                                    }
                                    Object var8_23 = null;
                                    this.readLock.unlock();
                                    return schemaObject2;
                                }
                                Object var8_24 = null;
                                this.readLock.unlock();
                                return triggerDef;
                            }
                            Object var8_25 = null;
                            this.readLock.unlock();
                            return tableName32;
                        }
                        Object var8_26 = null;
                        this.readLock.unlock();
                        return constraint;
                    }
                    Object var8_27 = null;
                    this.readLock.unlock();
                    return tableName22;
                }
                Object var8_28 = null;
                this.readLock.unlock();
                return tableName22;
            }
            Object var8_29 = null;
            this.readLock.unlock();
            return index;
        }
        Object var8_30 = null;
        this.readLock.unlock();
        return schemaObject;
    }

    public void checkColumnIsReferenced(HsqlNameManager.HsqlName tableName, HsqlNameManager.HsqlName name) {
        OrderedHashSet set = this.getReferencingObjectNames(tableName, name);
        if (!set.isEmpty()) {
            HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
    }

    public void checkObjectIsReferenced(HsqlNameManager.HsqlName name) {
        OrderedHashSet set = this.getReferencingObjectNames(name);
        HsqlNameManager.HsqlName refName = null;
        for (int i = 0; i < set.size(); ++i) {
            refName = (HsqlNameManager.HsqlName)set.get(i);
            if (refName.parent != name) break;
            refName = null;
        }
        if (refName == null) {
            return;
        }
        throw Error.error(5502, refName.getSchemaQualifiedStatementName());
    }

    public void checkSchemaNameCanChange(HsqlNameManager.HsqlName name) {
        this.readLock.lock();
        try {
            Iterator it = this.referenceMap.values().iterator();
            HsqlNameManager.HsqlName refName = null;
            block5: while (it.hasNext()) {
                refName = (HsqlNameManager.HsqlName)it.next();
                switch (refName.type) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        if (refName.schema == name) break block5;
                    }
                    default: {
                        refName = null;
                        continue block5;
                    }
                }
            }
            if (refName == null) {
                Object var5_4 = null;
                this.readLock.unlock();
                return;
            }
            throw Error.error(5502, refName.getSchemaQualifiedStatementName());
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSchemaObject(SchemaObject object) {
        block13: {
            block12: {
                this.writeLock.lock();
                try {
                    HsqlNameManager.HsqlName name = object.getName();
                    Schema schema = (Schema)this.schemaMap.get(name.schema.name);
                    SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
                    switch (name.type) {
                        case 16: 
                        case 17: {
                            RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                            if (routine == null) {
                                routine = new RoutineSchema(name.type, name);
                                routine.addSpecificRoutine(this.database, (Routine)object);
                                set.checkAdd(name);
                                SchemaObjectSet specificSet = this.getSchemaObjectSet(schema, 24);
                                specificSet.checkAdd(((Routine)object).getSpecificName());
                                set.add(routine);
                                specificSet.add(object);
                            } else {
                                SchemaObjectSet specificSet = this.getSchemaObjectSet(schema, 24);
                                HsqlNameManager.HsqlName specificName = ((Routine)object).getSpecificName();
                                if (specificName != null) {
                                    specificSet.checkAdd(specificName);
                                }
                                routine.addSpecificRoutine(this.database, (Routine)object);
                                specificSet.add(object);
                            }
                            this.addReferences(object);
                            Object var11_12 = null;
                            this.writeLock.unlock();
                            return;
                        }
                        case 3: {
                            OrderedHashSet refs = object.getReferences();
                            for (int i = 0; i < refs.size(); ++i) {
                                HsqlNameManager.HsqlName ref = (HsqlNameManager.HsqlName)refs.get(i);
                                if (ref.type != 9) continue;
                                int index = ((Table)object).findColumn(ref.name);
                                ColumnSchema column = ((Table)object).getColumn(index);
                                this.addSchemaObject(column);
                            }
                            break;
                        }
                        case 9: {
                            if (!object.getReferences().isEmpty()) break;
                            break block12;
                        }
                    }
                    if (set != null) {
                        set.add(object);
                    }
                    this.addReferences(object);
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            Object var11_13 = null;
            this.writeLock.unlock();
            return;
        }
        Object var11_14 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(HsqlNameManager.HsqlName name, boolean cascade) {
        this.writeLock.lock();
        try {
            OrderedHashSet objectSet = new OrderedHashSet();
            switch (name.type) {
                case 16: 
                case 17: 
                case 18: {
                    RoutineSchema routine = (RoutineSchema)this.getSchemaObject(name);
                    if (routine == null) break;
                    Routine[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.getCascadingReferencingObjectNames(specifics[i].getSpecificName(), objectSet);
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 12: 
                case 14: 
                case 15: 
                case 24: {
                    this.getCascadingReferencingObjectNames(name, objectSet);
                    break;
                }
                case 13: {
                    OrderedHashSet set = this.getReferencingObjectNames(name);
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        HsqlNameManager.HsqlName ref = (HsqlNameManager.HsqlName)it.next();
                        if (ref.type != 9) continue;
                        it.remove();
                    }
                    if (set.isEmpty()) break;
                    HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(0);
                    throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
                }
            }
            if (objectSet.isEmpty()) {
                this.removeSchemaObject(name);
                Object var8_9 = null;
                this.writeLock.unlock();
                return;
            }
            if (!cascade) {
                HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)objectSet.get(0);
                throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
            }
            objectSet.add(name);
            this.removeSchemaObjects(objectSet);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var8_10 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObjects(OrderedHashSet set) {
        this.writeLock.lock();
        try {
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
                this.removeSchemaObject(name);
            }
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(HsqlNameManager.HsqlName name) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            SchemaObject object = null;
            SchemaObjectSet set = null;
            switch (name.type) {
                case 7: {
                    set = schema.sequenceLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 3: 
                case 4: {
                    set = schema.tableLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 9: {
                    Table table = (Table)this.getSchemaObject(name.parent);
                    if (table == null) break;
                    object = table.getColumn(table.getColumnIndex(name.name));
                    break;
                }
                case 14: {
                    set = schema.charsetLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 15: {
                    set = schema.collationLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 17: {
                    set = schema.procedureLookup;
                    RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                    object = routine;
                    Routine[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.removeSchemaObject(specifics[i].getSpecificName());
                    }
                    break;
                }
                case 16: {
                    set = schema.functionLookup;
                    RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                    object = routine;
                    Routine[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.removeSchemaObject(specifics[i].getSpecificName());
                    }
                    break;
                }
                case 24: {
                    set = schema.specificRoutineLookup;
                    Routine routine = (Routine)set.getObject(name.name);
                    object = routine;
                    routine.routineSchema.removeSpecificRoutine(routine);
                    if (routine.routineSchema.getSpecificRoutines().length != 0) break;
                    this.removeSchemaObject(routine.getName());
                    break;
                }
                case 12: 
                case 13: {
                    set = schema.typeLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 20: {
                    set = schema.indexLookup;
                    break;
                }
                case 5: {
                    set = schema.constraintLookup;
                    if (name.parent.type == 3) {
                        Table table = (Table)schema.tableList.get(name.parent.name);
                        object = table.getConstraint(name.name);
                        table.removeConstraint(name.name);
                        break;
                    }
                    if (name.parent.type != 13) break;
                    Type type = (Type)schema.typeLookup.getObject(name.parent.name);
                    object = type.userTypeModifier.getConstraint(name.name);
                    type.userTypeModifier.removeConstraint(name.name);
                    break;
                }
                case 8: {
                    set = schema.triggerLookup;
                    Table table = (Table)schema.tableList.get(name.parent.name);
                    object = table.getTrigger(name.name);
                    if (object == null) break;
                    table.removeTrigger((TriggerDef)object);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "SchemaManager");
                }
            }
            if (object != null) {
                this.database.getGranteeManager().removeDbObject(name);
                this.removeReferencingObject(object);
            }
            if (set != null) {
                set.remove(name.name);
            }
            this.removeReferencedObject(name);
            Object var9_16 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchemaObject(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName newName) {
        this.writeLock.lock();
        try {
            if (name.schema != newName.schema) {
                throw Error.error(5505, newName.schema.name);
            }
            this.checkObjectIsReferenced(name);
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
            set.rename(name, newName);
            Object var6_5 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceReferences(SchemaObject oldObject, SchemaObject newObject) {
        this.writeLock.lock();
        try {
            this.removeReferencingObject(oldObject);
            this.addReferences(newObject);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSQLArray() {
        this.readLock.lock();
        try {
            Schema schema;
            SchemaObject object;
            OrderedHashSet newResolved;
            Iterator it;
            Schema schema2;
            OrderedHashSet resolved = new OrderedHashSet();
            OrderedHashSet unresolved = new OrderedHashSet();
            HsqlArrayList list = new HsqlArrayList();
            Iterator schemas = this.schemaMap.values().iterator();
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema2 = (Schema)schemas.next();
                if (SqlInvariants.isSystemSchemaName(schema2.getName().name) || SqlInvariants.isLobsSchemaName(schema2.getName().name)) continue;
                list.add(schema2.getSQL());
                schema2.addSimpleObjects(unresolved);
            }
            while ((it = unresolved.iterator()).hasNext()) {
                newResolved = new OrderedHashSet();
                SchemaObjectSet.addAllSQL(resolved, unresolved, list, it, newResolved);
                unresolved.removeAll(newResolved);
                if (newResolved.size() != 0) continue;
                break;
            }
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema2 = (Schema)schemas.next();
                if (SqlInvariants.isLobsSchemaName(schema2.getName().name) || SqlInvariants.isSystemSchemaName(schema2.getName().name)) continue;
                list.addAll(schema2.getSQLArray(resolved, unresolved));
            }
            while ((it = unresolved.iterator()).hasNext()) {
                newResolved = new OrderedHashSet();
                SchemaObjectSet.addAllSQL(resolved, unresolved, list, it, newResolved);
                unresolved.removeAll(newResolved);
                if (newResolved.size() != 0) continue;
                break;
            }
            it = unresolved.iterator();
            while (it.hasNext()) {
                object = (SchemaObject)it.next();
                if (!(object instanceof Routine)) continue;
                list.add(((Routine)object).getSQLDeclaration());
            }
            it = unresolved.iterator();
            while (it.hasNext()) {
                object = (SchemaObject)it.next();
                if (object instanceof Routine) {
                    list.add(((Routine)object).getSQLAlter());
                    continue;
                }
                list.add(object.getSQL());
            }
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                Object[] t;
                schema = (Schema)schemas.next();
                if (SqlInvariants.isLobsSchemaName(schema.getName().name) || SqlInvariants.isSystemSchemaName(schema.getName().name) || (t = schema.getTriggerSQL()).length <= 0) continue;
                list.add(Schema.getSetSchemaSQL(schema.getName()));
                list.addAll(t);
            }
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema = (Schema)schemas.next();
                list.addAll(schema.getSequenceRestartSQL());
            }
            if (this.defaultSchemaHsqlName != null) {
                StringBuffer sb = new StringBuffer();
                sb.append("SET").append(' ').append("DATABASE");
                sb.append(' ').append("DEFAULT").append(' ');
                sb.append("INITIAL").append(' ').append("SCHEMA");
                sb.append(' ').append(this.defaultSchemaHsqlName.statementName);
                list.add(sb.toString());
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            Object var9_8 = null;
            this.readLock.unlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTablePropsSQL(boolean withHeader) {
        this.readLock.lock();
        try {
            HsqlArrayList tableList = this.getAllTables(false);
            HsqlArrayList list = new HsqlArrayList();
            for (int i = 0; i < tableList.size(); ++i) {
                Object ddl;
                Table t = (Table)tableList.get(i);
                if (t.isText()) {
                    ddl = t.getSQLForTextSource(withHeader);
                    list.addAll((Object[])ddl);
                }
                if ((ddl = t.getSQLForReadOnly()) != null) {
                    list.add(ddl);
                }
                if (!t.isCached() || (ddl = t.getSQLForClustered()) == null) continue;
                list.add(ddl);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            Object var8_8 = null;
            this.readLock.unlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIndexRootsSQL() {
        this.readLock.lock();
        try {
            Session sysSession = this.database.sessionManager.getSysSession();
            int[][] rootsArray = this.getIndexRoots(sysSession);
            HsqlArrayList tableList = this.getAllTables(true);
            HsqlArrayList list = new HsqlArrayList();
            for (int i = 0; i < rootsArray.length; ++i) {
                Table t = (Table)tableList.get(i);
                if (rootsArray[i] == null || rootsArray[i].length <= 0 || rootsArray[i][0] == -1) continue;
                String ddl = ((Table)tableList.get(i)).getIndexRootsSQL(rootsArray[i]);
                list.add(ddl);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            Object var9_9 = null;
            this.readLock.unlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCommentsArray() {
        this.readLock.lock();
        try {
            HsqlArrayList tableList = this.getAllTables(false);
            HsqlArrayList list = new HsqlArrayList();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < tableList.size(); ++i) {
                Table table = (Table)tableList.get(i);
                if (table.getTableType() == 1) continue;
                int colCount = table.getColumnCount();
                for (int j = 0; j < colCount; ++j) {
                    ColumnSchema column = table.getColumn(j);
                    if (column.getName().comment == null) continue;
                    sb.setLength(0);
                    sb.append("COMMENT").append(' ').append("ON");
                    sb.append(' ').append("COLUMN").append(' ');
                    sb.append(table.getName().getSchemaQualifiedStatementName());
                    sb.append('.').append(column.getName().statementName);
                    sb.append(' ').append("IS").append(' ');
                    sb.append(StringConverter.toQuotedString(column.getName().comment, '\'', true));
                    list.add(sb.toString());
                }
                if (table.getName().comment == null) continue;
                sb.setLength(0);
                sb.append("COMMENT").append(' ').append("ON");
                sb.append(' ').append("TABLE").append(' ');
                sb.append(table.getName().getSchemaQualifiedStatementName());
                sb.append(' ').append("IS").append(' ');
                sb.append(StringConverter.toQuotedString(table.getName().comment, '\'', true));
                list.add(sb.toString());
            }
            Iterator it = this.databaseObjectIterator(18);
            while (it.hasNext()) {
                SchemaObject object = (SchemaObject)it.next();
                if (object.getName().comment == null) continue;
                sb.setLength(0);
                sb.append("COMMENT").append(' ').append("ON");
                sb.append(' ').append("ROUTINE").append(' ');
                sb.append(object.getName().getSchemaQualifiedStatementName());
                sb.append(' ').append("IS").append(' ');
                sb.append(StringConverter.toQuotedString(object.getName().comment, '\'', true));
                list.add(sb.toString());
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            Object var10_11 = null;
            this.readLock.unlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public void setTempIndexRoots(int[][] roots) {
        this.tempIndexRoots = roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getIndexRoots(Session session) {
        block5: {
            this.readLock.lock();
            if (this.tempIndexRoots == null) break block5;
            int[][] roots = this.tempIndexRoots;
            this.tempIndexRoots = null;
            int[][] nArray = roots;
            Object var9_6 = null;
            this.readLock.unlock();
            return nArray;
        }
        try {
            HsqlArrayList allTables = this.getAllTables(true);
            HsqlArrayList list = new HsqlArrayList();
            int size = allTables.size();
            for (int i = 0; i < size; ++i) {
                Table t = (Table)allTables.get(i);
                if (t.getTableType() == 5) {
                    int[] roots = t.getIndexRootsArray();
                    list.add(roots);
                    continue;
                }
                list.add(null);
            }
            int[][] array = new int[list.size()][];
            list.toArray(array);
            int[][] nArrayArray = array;
            Object var9_7 = null;
            this.readLock.unlock();
            return nArrayArray;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexRoots(int[][] roots) {
        this.readLock.lock();
        try {
            HsqlArrayList allTables = this.database.schemaManager.getAllTables(true);
            int size = allTables.size();
            for (int i = 0; i < size; ++i) {
                Table t = (Table)allTables.get(i);
                if (t.getTableType() != 5) continue;
                int[] rootsArray = roots[i];
                if (roots == null) continue;
                t.setIndexRoots(rootsArray);
            }
            Object var8_7 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public void setDefaultTableType(int type) {
        this.defaultTableType = type;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }

    public void createSystemTables() {
        this.dualTable = TableUtil.newLookupTable(this.database, SqlInvariants.DUAL_TABLE_HSQLNAME, 12, SqlInvariants.DUAL_COLUMN_HSQLNAME, Type.SQL_VARCHAR);
        this.dualTable.insertSys(this.database.sessionManager.getSysSession(), this.dualTable.getRowStore(null), new Object[]{"X"});
        this.dualTable.setDataReadOnly(true);
    }
}

