/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.concurrent.ThrowableAwareRunnable;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class VerifyUUID
extends VerifyProcess {
    private static final String[][] _MODELS = new String[][]{{"Address", "addressId"}, {"DLFileVersion", "fileVersionId"}, {"EmailAddress", "emailAddressId"}, {"Group_", "groupId"}, {"JournalArticleResource", "resourcePrimKey"}, {"JournalFeed", "id_"}, {"Layout", "plid"}, {"LayoutPrototype", "layoutPrototypeId"}, {"LayoutSetPrototype", "layoutSetPrototypeId"}, {"MBBan", "banId"}, {"MBDiscussion", "discussionId"}, {"MBThread", "threadId"}, {"MBThreadFlag", "threadFlagId"}, {"Organization_", "organizationId"}, {"PasswordPolicy", "passwordPolicyId"}, {"Phone", "phoneId"}, {"PollsVote", "voteId"}, {"Role_", "roleId"}, {"UserGroup", "userGroupId"}, {"Website", "websiteId"}, {"WikiPageResource", "resourcePrimKey"}};

    public static void verifyModel(String modelName, String pkColumnName) throws Exception {
        VerifyUUID verifyUUID = new VerifyUUID();
        verifyUUID.doVerify(modelName, pkColumnName);
    }

    @Override
    protected void doVerify() throws Exception {
        ArrayList<VerifyUUIDRunnable> verifyUUIDRunnables = new ArrayList<VerifyUUIDRunnable>(_MODELS.length);
        String[][] stringArray = _MODELS;
        int n = _MODELS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] model = stringArray[n2];
            VerifyUUIDRunnable verifyUUIDRunnable = new VerifyUUIDRunnable(model[0], model[1]);
            verifyUUIDRunnables.add(verifyUUIDRunnable);
            ++n2;
        }
        this.doVerify(verifyUUIDRunnables);
    }

    protected void doVerify(String modelName, String pkColumnName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select " + pkColumnName + " from " + modelName + " where uuid_ is null or uuid_ = ''");
            rs = ps.executeQuery();
            while (rs.next()) {
                long pk = rs.getLong(pkColumnName);
                this.doVerify(modelName, pkColumnName, pk);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void doVerify(String modelName, String pkColumnName, long pk) throws Exception {
        String uuid = PortalUUIDUtil.generate();
        DB db = DBFactoryUtil.getDB();
        db.runSQL("update " + modelName + " set uuid_ = '" + uuid + "' where " + pkColumnName + " = " + pk);
    }

    private class VerifyUUIDRunnable
    extends ThrowableAwareRunnable {
        private final String _pkColumn;
        private final String _modelName;

        public VerifyUUIDRunnable(String modelName, String pkColumn) {
            this._modelName = modelName;
            this._pkColumn = pkColumn;
        }

        protected void doRun() throws Exception {
            VerifyUUID.this.doVerify(this._modelName, this._pkColumn);
        }
    }
}

