/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.format;

import com.liferay.portal.kernel.format.PhoneNumberFormat;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;

public class USAPhoneNumberFormatImpl
implements PhoneNumberFormat {
    public String format(String phoneNumber) {
        if (Validator.isNull((String)phoneNumber)) {
            return "";
        }
        if (phoneNumber.length() > 10) {
            StringBundler sb = new StringBundler(8);
            sb.append("(");
            sb.append(phoneNumber.substring(0, 3));
            sb.append(") ");
            sb.append(phoneNumber.substring(3, 6));
            sb.append("-");
            sb.append(phoneNumber.substring(6, 10));
            sb.append(" x");
            sb.append(phoneNumber.substring(10));
            return sb.toString();
        }
        if (phoneNumber.length() == 10) {
            StringBundler sb = new StringBundler(6);
            sb.append("(");
            sb.append(phoneNumber.substring(0, 3));
            sb.append(") ");
            sb.append(phoneNumber.substring(3, 6));
            sb.append("-");
            sb.append(phoneNumber.substring(6));
            return sb.toString();
        }
        if (phoneNumber.length() == 7) {
            return phoneNumber.substring(0, 3).concat("-").concat(phoneNumber.substring(3));
        }
        return phoneNumber;
    }

    public String strip(String phoneNumber) {
        return StringUtil.extractDigits((String)phoneNumber);
    }

    public boolean validate(String phoneNumber) {
        if (Validator.isNull((String)phoneNumber)) {
            return false;
        }
        return phoneNumber.matches(PropsValues.PHONE_NUMBER_FORMAT_USA_REGEXP);
    }
}

