/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.staging.server;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import org.gcube.portal.custom.communitymanager.SiteManagerUtil;
import org.gcube.portal.custom.communitymanager.components.GCUBELayoutTab;
import org.gcube.portal.custom.communitymanager.components.GCUBEPortlet;
import org.gcube.portal.custom.communitymanager.components.GCUBESiteLayout;
import org.gcube.portal.custom.communitymanager.impl.GCubeSiteManagerImpl;
import org.gcube.portal.custom.communitymanager.types.GCUBELayoutType;
import org.gcube.portal.staging.server.PortalStaging;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;

public class CommunityCreator {
    private static Log _log = LogFactoryUtil.getLog(PortalStaging.class);
    public static final String DEFAULT_COMPANY_WEB_ID = "liferay.com";
    public static final String USERNAME = "test";
    private static CommunityCreator instance = null;

    protected CommunityCreator() {
    }

    public static CommunityCreator getInstance() {
        if (instance == null) {
            instance = new CommunityCreator();
        }
        return instance;
    }

    private User validateUser(String email) throws PortalException, SystemException {
        Company company = CommunityCreator.getCompany();
        return UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)email);
    }

    public static Company getCompany() throws PortalException, SystemException {
        return CompanyLocalServiceUtil.getCompanyByWebId((String)CommunityCreator.getDefaultCompanyWebId());
    }

    public static String getDefaultCompanyWebId() {
        String defaultWebId = "";
        try {
            defaultWebId = GetterUtil.getString((String)PropsUtil.get((String)"company.default.web.id"));
        }
        catch (NullPointerException e) {
            _log.info((Object)"Cound not find property company.default.web.id in portal.ext file returning default web id: liferay.com");
            return DEFAULT_COMPANY_WEB_ID;
        }
        return defaultWebId;
    }

    protected Group createDefaultCommunity(ActionRequest request) throws Exception {
        User currentUser = PortalUtil.getUser((PortletRequest)request);
        String defaultCommunityName = this.getDefaultCommunityName();
        _log.info((Object)("Creating Default Site " + defaultCommunityName));
        Group toReturn = this.createGroup(defaultCommunityName, "Default Site", -1L);
        _log.info((Object)("GROUP created  id:" + toReturn.getGroupId()));
        this.associateLayout(currentUser, toReturn, defaultCommunityName, "desc", 0L);
        _log.info((Object)("Layout Associated correctly for " + defaultCommunityName));
        String themid = "";
        themid = SiteManagerUtil.getgCubeThemeId((String)"gcubeportaltheme");
        LiferayGroupManager gm = new LiferayGroupManager();
        long groupId = gm.getGroupId(defaultCommunityName);
        Theme themeToApply = ThemeLocalServiceUtil.getTheme((long)SiteManagerUtil.getCompany().getCompanyId(), (String)themid, (boolean)false);
        LayoutSetLocalServiceUtil.updateLookAndFeel((long)groupId, (String)themeToApply.getThemeId(), (String)"", (String)"", (boolean)false);
        _log.debug((Object)("LayoutSet Theme with id " + themid + " Applied Correctly to Default Community = " + defaultCommunityName));
        LiferayUserManager uman = new LiferayUserManager();
        long uid = currentUser.getUserId();
        uman.assignUserToGroup(toReturn.getGroupId(), uid);
        _log.debug((Object)("Added user " + currentUser.getFullName() + " to group " + toReturn.getName() + " with Success"));
        InputStream is = GCubeSiteManagerImpl.class.getResourceAsStream("/org/gcube/portal/custom/communitymanager/resources/default_logo.png");
        LayoutSetLocalServiceUtil.updateLogo((long)toReturn.getGroupId(), (boolean)true, (boolean)true, (InputStream)is);
        return toReturn;
    }

    private Group createGroup(String groupName, String description, long parentGroupId) {
        Group group = null;
        if (parentGroupId < 0L) {
            parentGroupId = 0L;
        }
        try {
            Company company = CompanyLocalServiceUtil.getCompanyByMx((String)PropsUtil.get((String)"company.default.web.id"));
            long companyId = company.getCompanyId();
            long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
            group = GroupLocalServiceUtil.addGroup((long)defaultUserId, (long)parentGroupId, (String)Group.class.getName(), (long)0L, (long)0L, (String)groupName, (String)description, (int)1, (boolean)true, (int)0, (String)("/" + groupName), (boolean)true, (boolean)true, (ServiceContext)new ServiceContext());
            _log.info((Object)("Created Group with name " + groupName));
            return group;
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return group;
    }

    public long associateLayout(User currentUser, Group group, String communityName, String communityDesc, long parentID) throws PortalException, SystemException {
        GCUBESiteLayout siteLayout = new GCUBESiteLayout(SiteManagerUtil.getCompany(), communityName, currentUser.getEmailAddress());
        siteLayout.addTab(new GCUBELayoutTab("Home", GCUBELayoutType.ONE_COL, this.getGCUBELoginPorlet()));
        this.createLayout(group, this.validateUser(currentUser.getEmailAddress()), siteLayout);
        return 1L;
    }

    private List<GCUBEPortlet> getGCUBELoginPorlet() {
        ArrayList<GCUBEPortlet> toReturn = new ArrayList<GCUBEPortlet>();
        toReturn.add(new GCUBEPortlet("gCube Login", this.getLPortletName("gCubeLogin")));
        return toReturn;
    }

    private String getLPortletName(String gCubePortletName) {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = System.getenv("CATALINA_HOME") + "/conf/gcube-portlets.properties";
            _log.info((Object)("Loading gCube-portlets list from " + propertyfile));
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty(gCubePortletName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private long createLayout(Group group, User user, GCUBESiteLayout siteLayout) throws PortalException, SystemException {
        Layout layout = null;
        for (GCUBELayoutTab tab : siteLayout.getTabs()) {
            String layoutName = siteLayout.getName().replaceAll(" ", "-");
            String friendlyURL = "/" + tab.getCaption().replaceAll(" ", "-");
            _log.debug((Object)("Trying creating layout " + layoutName + " url:" + friendlyURL + " userid:" + user.getUserId() + " groupid:" + group.getGroupId()));
            ServiceContext ctx = new ServiceContext();
            layout = LayoutLocalServiceUtil.addLayout((long)user.getUserId(), (long)group.getGroupId(), (boolean)true, (long)0L, (String)tab.getCaption(), (String)layoutName, (String)group.getDescription(), (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)ctx);
            _log.debug((Object)("Trying creating tab " + tab.getCaption()));
            String typeSettings = tab.getLayoutTypeSettings();
            layout.setTypeSettings(typeSettings);
            LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
            _log.debug((Object)("Added tab " + tab.getCaption() + " to layout for community: " + siteLayout.getName()));
            for (GCUBEPortlet gPortlet : tab.getPortlets()) {
                long companyId = CommunityCreator.getCompany().getCompanyId();
                Portlet lPortlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)("" + gPortlet.getPortletId()));
                long ownerId = 0L;
                int ownerType = 3;
                String portletPreferencesString = "<portlet-preferences><preference><name>lfr-wap-initial-window-state</name><value>NORMAL</value></preference><preference><name>portlet-setup-show-borders</name><value>false</value></preference><preference><name>\tportlet-setup-use-custom-title</name><value>false</value></preference></portlet-preferences>";
                PortletPreferencesLocalServiceUtil.addPortletPreferences((long)companyId, (long)ownerId, (int)ownerType, (long)layout.getPlid(), (String)lPortlet.getPortletId(), (Portlet)lPortlet, (String)portletPreferencesString);
                _log.debug((Object)("Added Preference for portlet " + lPortlet.getPortletName() + " for layout plid:" + layout.getPlid()));
            }
        }
        return layout.getLayoutId();
    }

    public String getDefaultCommunityName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = SiteManagerUtil.getTomcatFolder() + "conf" + File.separator + "gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("defaultcommunity");
        }
        catch (IOException e) {
            toReturn = "D4science Gateway";
            _log.error((Object)("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default Portal Name " + toReturn));
            return toReturn;
        }
        _log.debug((Object)("Returning Gateway Name: " + toReturn));
        return toReturn;
    }
}

