/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.TransformFilter;
import com.jhlabs.math.Noise;

public class MarbleFilter
extends TransformFilter {
    static final long serialVersionUID = -3658170437130333021L;
    public float[] sinTable;
    public float[] cosTable;
    public double xScale = 4.0;
    public double yScale = 4.0;
    public double amount = 1.0;
    public double turbulence = 1.0;

    public MarbleFilter() {
        this.setEdgeAction(1);
    }

    public void setXScale(double d) {
        this.xScale = d;
    }

    public double getXScale() {
        return this.xScale;
    }

    public void setYScale(double d) {
        this.yScale = d;
    }

    public double getYScale() {
        return this.yScale;
    }

    public void setAmount(double d) {
        this.amount = d;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setTurbulence(double d) {
        this.turbulence = d;
    }

    public double getTurbulence() {
        return this.turbulence;
    }

    private void initialize() {
        this.sinTable = new float[256];
        this.cosTable = new float[256];
        int n = 0;
        while (n < 256) {
            double d = Math.PI * 2 * (double)n / 256.0 * this.turbulence;
            this.sinTable[n] = (float)(-this.yScale * Math.sin(d));
            this.cosTable[n] = (float)(this.yScale * Math.cos(d));
            ++n;
        }
    }

    private int displacementMap(int n, int n2) {
        return PixelUtils.clamp((int)(127.0 * (1.0 + Noise.noise2((double)n / this.xScale, (double)n2 / this.xScale))));
    }

    protected void transformInverse(int n, int n2, double[] dArray) {
        int n3 = this.displacementMap(n, n2);
        dArray[0] = (float)n + this.sinTable[n3];
        dArray[1] = (float)n2 + this.cosTable[n3];
    }

    public void imageComplete(int n) {
        this.initialize();
        super.imageComplete(n);
    }

    public String toString() {
        return "Distort/Marble...";
    }
}

