/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeVariable;
import org.hsqldb.SchemaObject;
import org.hsqldb.types.Type;

public class Token {
    String tokenString = "";
    int tokenType = -1;
    Type dataType;
    Object tokenValue;
    String namePrefix;
    String namePrePrefix;
    String namePrePrePrefix;
    String charsetSchema;
    String charsetName;
    String fullString;
    int lobMultiplierType = -1;
    boolean isDelimiter;
    boolean isDelimitedIdentifier;
    boolean isDelimitedPrefix;
    boolean isDelimitedPrePrefix;
    boolean isDelimitedPrePrePrefix;
    boolean isUndelimitedIdentifier;
    boolean isReservedIdentifier;
    boolean isCoreReservedIdentifier;
    boolean isHostParameter;
    boolean isMalformed;
    int position;
    Object expression;

    void reset() {
        this.tokenString = "";
        this.tokenType = -1;
        this.dataType = null;
        this.tokenValue = null;
        this.namePrefix = null;
        this.namePrePrefix = null;
        this.namePrePrePrefix = null;
        this.charsetSchema = null;
        this.charsetName = null;
        this.fullString = null;
        this.expression = null;
        this.lobMultiplierType = -1;
        this.isDelimiter = false;
        this.isDelimitedIdentifier = false;
        this.isDelimitedPrefix = false;
        this.isDelimitedPrePrefix = false;
        this.isDelimitedPrePrePrefix = false;
        this.isUndelimitedIdentifier = false;
        this.isReservedIdentifier = false;
        this.isCoreReservedIdentifier = false;
        this.isHostParameter = false;
        this.isMalformed = false;
    }

    Token duplicate() {
        Token token = new Token();
        token.tokenString = this.tokenString;
        token.tokenType = this.tokenType;
        token.dataType = this.dataType;
        token.tokenValue = this.tokenValue;
        token.namePrefix = this.namePrefix;
        token.namePrePrefix = this.namePrePrefix;
        token.namePrePrePrefix = this.namePrePrePrefix;
        token.charsetSchema = this.charsetSchema;
        token.charsetName = this.charsetName;
        token.fullString = this.fullString;
        token.lobMultiplierType = this.lobMultiplierType;
        token.isDelimiter = this.isDelimiter;
        token.isDelimitedIdentifier = this.isDelimitedIdentifier;
        token.isDelimitedPrefix = this.isDelimitedPrefix;
        token.isDelimitedPrePrefix = this.isDelimitedPrePrefix;
        token.isDelimitedPrePrePrefix = this.isDelimitedPrePrePrefix;
        token.isUndelimitedIdentifier = this.isUndelimitedIdentifier;
        token.isReservedIdentifier = this.isReservedIdentifier;
        token.isCoreReservedIdentifier = this.isCoreReservedIdentifier;
        token.isHostParameter = this.isHostParameter;
        token.isMalformed = this.isMalformed;
        return token;
    }

    public String getFullString() {
        return this.fullString;
    }

    public void setExpression(Object expression) {
        this.expression = expression;
    }

    String getSQL() {
        if (this.expression instanceof ExpressionColumn) {
            if (this.tokenType == 771) {
                StringBuffer sb = new StringBuffer();
                Expression expression = (Expression)this.expression;
                if (expression != null && expression.opType == 97 && expression.nodes.length > 0) {
                    sb.append(' ');
                    for (int i = 0; i < expression.nodes.length; ++i) {
                        String name;
                        Expression e = expression.nodes[i];
                        ColumnSchema c = e.getColumn();
                        if (e.opType == 3) {
                            if (i > 0) {
                                sb.append(',');
                            }
                            sb.append(e.getColumnName());
                            continue;
                        }
                        if (e.getRangeVariable().tableAlias == null) {
                            name = c.getName().getSchemaQualifiedStatementName();
                        } else {
                            RangeVariable range = e.getRangeVariable();
                            name = range.tableAlias.getStatementName() + '.' + c.getName().statementName;
                        }
                        if (i > 0) {
                            sb.append(',');
                        }
                        sb.append(name);
                    }
                } else {
                    return this.tokenString;
                }
                sb.append(' ');
                return sb.toString();
            }
        } else {
            if (this.expression instanceof Type) {
                this.isDelimiter = false;
                Type type = (Type)this.expression;
                if (type.isDistinctType() || type.isDomainType()) {
                    return type.getName().getSchemaQualifiedStatementName();
                }
                return type.getNameString();
            }
            if (this.expression instanceof SchemaObject) {
                this.isDelimiter = false;
                return ((SchemaObject)this.expression).getName().getSchemaQualifiedStatementName();
            }
        }
        if (this.namePrefix == null && this.isUndelimitedIdentifier) {
            return this.tokenString;
        }
        if (this.tokenType == 845) {
            return this.dataType.convertToSQLString(this.tokenValue);
        }
        StringBuffer sb = new StringBuffer();
        if (this.namePrePrefix != null) {
            if (this.isDelimitedPrePrefix) {
                sb.append('\"');
                sb.append(this.namePrePrefix);
                sb.append('\"');
            } else {
                sb.append(this.namePrePrefix);
                this.isDelimiter = false;
            }
            sb.append('.');
        }
        if (this.namePrefix != null) {
            if (this.isDelimitedPrefix) {
                sb.append('\"');
                sb.append(this.namePrefix);
                sb.append('\"');
            } else {
                sb.append(this.namePrefix);
                this.isDelimiter = false;
            }
            sb.append('.');
        }
        if (this.isDelimitedIdentifier) {
            sb.append('\"');
            sb.append(this.tokenString);
            sb.append('\"');
            sb.append(' ');
        } else {
            sb.append(this.tokenString);
        }
        return sb.toString();
    }

    static String getSQL(Token[] statement) {
        boolean wasDelimiter = true;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < statement.length; ++i) {
            String sql = statement[i].getSQL();
            if (!statement[i].isDelimiter && !wasDelimiter) {
                sb.append(' ');
            }
            sb.append(sql);
            wasDelimiter = statement[i].isDelimiter;
        }
        return sb.toString();
    }

    static Object[] getSimplifiedTokens(Token[] tokens) {
        Object[] array = new Object[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            array[i] = tokens[i].expression == null ? tokens[i].getSQL() : tokens[i].expression;
        }
        return array;
    }
}

