/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.permission.PermissionChecker;
import java.util.HashSet;
import java.util.Set;

public class PermissionThreadLocal {
    private static ThreadLocal<Boolean> _addResource = new AutoResetThreadLocal<Boolean>(PermissionThreadLocal.class + "._addResource", true);
    private static final ThreadLocal<Set<String>> _flushResourceBlockEnabled = new AutoResetThreadLocal(PermissionThreadLocal.class + "._flushResourceBlockEnabled", new HashSet());
    private static final ThreadLocal<Set<String>> _flushResourcePermissionEnabled = new AutoResetThreadLocal(PermissionThreadLocal.class + "._flushResourcePermissionEnabled", new HashSet());
    private static ThreadLocal<Boolean> _flushEnabled = new AutoResetThreadLocal<Boolean>(PermissionThreadLocal.class + "._flushEnabled", true);
    private static ThreadLocal<PermissionChecker> _permissionChecker = new AutoResetThreadLocal<PermissionChecker>(PermissionThreadLocal.class + "._permissionChecker"){

        @Override
        protected PermissionChecker copy(PermissionChecker permissionChecker) {
            return permissionChecker;
        }
    };

    public static PermissionChecker getPermissionChecker() {
        return _permissionChecker.get();
    }

    public static boolean isAddResource() {
        return _addResource.get();
    }

    @Deprecated
    public static boolean isFlushEnabled() {
        Set<String> flushBlockSet = _flushResourceBlockEnabled.get();
        if (!flushBlockSet.isEmpty()) {
            return false;
        }
        Set<String> flushPermissionSet = _flushResourcePermissionEnabled.get();
        if (!flushPermissionSet.isEmpty()) {
            return false;
        }
        return _flushEnabled.get();
    }

    public static boolean isFlushResourceBlockEnabled(long companyId, long groupId, String name) {
        Set<String> set = _flushResourceBlockEnabled.get();
        StringBundler sb = new StringBundler(5);
        sb.append(companyId);
        sb.append("_");
        sb.append(groupId);
        sb.append("_");
        sb.append(name);
        return !set.contains(sb.toString());
    }

    public static boolean isFlushResourcePermissionEnabled(String resourceName, String primKey) {
        Set<String> set = _flushResourcePermissionEnabled.get();
        return !set.contains(String.valueOf(resourceName) + "_" + primKey);
    }

    public static void setAddResource(boolean addResource) {
        _addResource.set(addResource);
    }

    public static void setFlushResourceBlockEnabled(long companyId, long groupId, String name, boolean enabled) {
        Set<String> set = _flushResourceBlockEnabled.get();
        StringBundler sb = new StringBundler(5);
        sb.append(companyId);
        sb.append("_");
        sb.append(groupId);
        sb.append("_");
        sb.append(name);
        if (enabled) {
            set.remove(sb.toString());
        } else {
            set.add(sb.toString());
        }
    }

    public static void setFlushResourcePermissionEnabled(String resourceName, String primKey, boolean enabled) {
        Set<String> set = _flushResourcePermissionEnabled.get();
        if (enabled) {
            set.remove(String.valueOf(resourceName) + "_" + primKey);
        } else {
            set.add(String.valueOf(resourceName) + "_" + primKey);
        }
    }

    @Deprecated
    public static void setIndexEnabled(boolean indexEnabled) {
        _flushEnabled.set(indexEnabled);
    }

    public static void setPermissionChecker(PermissionChecker permissionChecker) {
        _permissionChecker.set(permissionChecker);
    }
}

