/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ThreadLocalBinder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultThreadLocalBinder
implements ThreadLocalBinder {
    private static Log _log = LogFactoryUtil.getLog(DefaultThreadLocalBinder.class);
    private static ThreadLocal<Map<ThreadLocal<?>, ?>> _threadLocalValues = new AutoResetThreadLocal<Map<ThreadLocal<?>, ?>>(DefaultThreadLocalBinder.class + "._threadLocalValueMap"){

        @Override
        protected Map<ThreadLocal<?>, ?> copy(Map<ThreadLocal<?>, ?> threadLocalValueMap) {
            return threadLocalValueMap;
        }
    };
    private ClassLoader _classLoader;
    private Set<ThreadLocal<?>> _threadLocals = new HashSet();
    private Map<String, String> _threadLocalSources;

    public void afterPropertiesSet() throws Exception {
        if (this._threadLocalSources == null) {
            throw new IllegalArgumentException("Thread local sources is null");
        }
        this.init(this.getClassLoader());
    }

    @Override
    public void bind() {
        Map<ThreadLocal<?>, ?> threadLocalValues = _threadLocalValues.get();
        for (Map.Entry<ThreadLocal<?>, ?> entry : threadLocalValues.entrySet()) {
            ThreadLocal<?> threadLocal = entry.getKey();
            Object value = entry.getValue();
            threadLocal.set(value);
        }
    }

    @Override
    public void cleanUp() {
        for (ThreadLocal<?> threadLocal : this._threadLocals) {
            threadLocal.remove();
        }
    }

    public ClassLoader getClassLoader() {
        if (this._classLoader == null) {
            Thread currentThread = Thread.currentThread();
            this._classLoader = currentThread.getContextClassLoader();
        }
        return this._classLoader;
    }

    public void init(ClassLoader classLoader) throws Exception {
        for (Map.Entry<String, String> entry : this._threadLocalSources.entrySet()) {
            String className = entry.getKey();
            String fieldName = entry.getValue();
            Class<?> clazz = classLoader.loadClass(className);
            Field field = ReflectionUtil.getDeclaredField(clazz, fieldName);
            if (!ThreadLocal.class.isAssignableFrom(field.getType())) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(String.valueOf(fieldName) + " is not of type ThreadLocal. Skip binding.");
                continue;
            }
            if (!Modifier.isStatic(field.getModifiers())) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(String.valueOf(fieldName) + " is not a static ThreadLocal. Skip binding.");
                continue;
            }
            ThreadLocal threadLocal = (ThreadLocal)field.get(null);
            if (threadLocal == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(String.valueOf(fieldName) + " is not initialized. Skip binding.");
                continue;
            }
            this._threadLocals.add(threadLocal);
        }
    }

    @Override
    public void record() {
        HashMap threadLocalValues = new HashMap();
        for (ThreadLocal<?> threadLocal : this._threadLocals) {
            Object value = threadLocal.get();
            threadLocalValues.put(threadLocal, value);
        }
        _threadLocalValues.set(threadLocalValues);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setThreadLocalSources(Map<String, String> threadLocalSources) {
        this._threadLocalSources = threadLocalSources;
    }
}

