/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTypeNameMapper {
    private static final Logger log = LoggerFactory.getLogger(JdbcTypeNameMapper.class);
    private static Map<Integer, String> JDBC_TYPE_MAP = JdbcTypeNameMapper.buildJdbcTypeMap();

    private static Map<Integer, String> buildJdbcTypeMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        Field[] fields = Types.class.getFields();
        if (fields == null) {
            throw new HibernateException("Unexpected problem extracting JDBC type mapping codes from java.sql.Types");
        }
        for (Field field : fields) {
            try {
                int code = field.getInt(null);
                String old = map.put(code, field.getName());
                if (old == null) continue;
                log.info("java.sql.Types mapped the same code [" + code + "] multiple times; was [" + old + "]; now [" + field.getName() + "]");
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Unable to access JDBC type mapping [" + field.getName() + "]", e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static String getTypeName(int code) {
        return JdbcTypeNameMapper.getTypeName((Integer)code);
    }

    public static String getTypeName(Integer code) {
        String name = JDBC_TYPE_MAP.get(code);
        if (name == null) {
            return "UNKNOWN(" + code + ")";
        }
        return name;
    }
}

