/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.util.Calendar;
import java.util.Date;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.serializer.BaseSerializer;
import org.apache.abdera.ext.serializer.ConventionSerializationContext;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.DefaultConventions;
import org.apache.abdera.ext.serializer.ObjectContext;
import org.apache.abdera.ext.serializer.SerializationContext;
import org.apache.abdera.ext.serializer.annotation.EntityTag;
import org.apache.abdera.ext.serializer.annotation.LastModified;
import org.apache.abdera.ext.serializer.annotation.MediaType;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.protocol.server.context.StreamWriterResponseContext;
import org.apache.abdera.writer.StreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectResponseContext
extends StreamWriterResponseContext {
    private final Object object;
    private final ObjectContext objectContext;
    private final Conventions conventions;
    private final Class<? extends SerializationContext> context;

    public ObjectResponseContext(Object object, Abdera abdera, String encoding, String sw) {
        this(object, null, null, abdera, encoding, sw);
    }

    public ObjectResponseContext(Object object, Class<? extends SerializationContext> context, Conventions conventions, Abdera abdera, String encoding, String sw) {
        super(abdera, encoding, sw);
        this.object = object;
        this.objectContext = new ObjectContext(object);
        this.conventions = conventions != null ? conventions : new DefaultConventions();
        this.context = context != null ? context : ConventionSerializationContext.class;
        this.init();
    }

    public ObjectResponseContext(Object object, Abdera abdera, String encoding) {
        this(object, null, null, abdera, encoding, null);
    }

    public ObjectResponseContext(Object object, Class<? extends SerializationContext> context, Conventions conventions, Abdera abdera, String encoding) {
        this(object, context, conventions, abdera, encoding, null);
    }

    public ObjectResponseContext(Object object, Abdera abdera) {
        this(object, null, null, abdera, null, null);
    }

    public ObjectResponseContext(Object object, Class<? extends SerializationContext> context, Conventions conventions, Abdera abdera) {
        this(object, context, null, abdera, null, null);
    }

    private void init() {
        this.setContentType(this.getObjectContentType());
        this.setEntityTag(this.getObjectEntityTag());
        this.setLastModified(this.getObjectLastModified());
    }

    private Date getObjectLastModified() {
        Date date = null;
        AccessibleObject accessor = this.objectContext.getAccessor(LastModified.class, this.conventions);
        if (accessor != null) {
            Object value = BaseSerializer.eval(accessor, this.object);
            date = this.getDate(value);
        }
        return date;
    }

    private Date getDate(Object value) {
        Date date = null;
        if (value == null) {
            return null;
        }
        date = value instanceof Date ? (Date)value : (value instanceof Calendar ? ((Calendar)value).getTime() : (value instanceof Long ? new Date((Long)value) : (value instanceof String ? AtomDate.parse((String)value) : AtomDate.parse(value.toString()))));
        return date;
    }

    private String getObjectEntityTag() {
        String etag = null;
        AccessibleObject accessor = this.objectContext.getAccessor(EntityTag.class, this.conventions);
        if (accessor != null) {
            Object value = BaseSerializer.eval(accessor, this.object);
            etag = value != null ? BaseSerializer.toString(value) : null;
        }
        return etag;
    }

    private String getObjectContentType() {
        MediaType content_type;
        String ctype = null;
        AccessibleObject accessor = this.objectContext.getAccessor(MediaType.class, this.conventions);
        if (accessor != null) {
            Object value = BaseSerializer.eval(accessor, this.object);
            String string = ctype = value != null ? BaseSerializer.toString(value) : null;
        }
        if (ctype == null && (content_type = this.objectContext.getAnnotation(MediaType.class)) != null && !content_type.value().equals("##default")) {
            ctype = content_type.value();
        }
        return ctype;
    }

    @Override
    protected void writeTo(StreamWriter sw) throws IOException {
        SerializationContext context = this.newSerializationContext(this.getAbdera(), this.conventions, sw);
        sw.startDocument();
        context.serialize(this.object, this.objectContext);
        sw.endDocument();
    }

    private SerializationContext newSerializationContext(Abdera abdera, Conventions conventions, StreamWriter sw) {
        try {
            return this.context.getConstructor(Abdera.class, Conventions.class, StreamWriter.class).newInstance(abdera, conventions, sw);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

