/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.MultiplexedOutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.zip.ZipEntry;
import java.io.IOException;
import java.io.OutputStream;

public class OdfOutputArchive
extends MultiplexedOutputArchive {
    private static final String MIMETYPE = "mimetype";
    private boolean mimetype;

    public OdfOutputArchive(OutputArchive target) {
        super(target);
    }

    public OutputStream getOutputStream(ArchiveEntry entry, ArchiveEntry srcEntry) throws IOException {
        ZipEntry zipEntry = (ZipEntry)entry;
        if (MIMETYPE.equals(zipEntry.getName())) {
            this.mimetype = true;
            if (zipEntry.getMethod() == -1) {
                zipEntry.setMethod(0);
            }
        }
        return super.getOutputStream(zipEntry, srcEntry);
    }

    public boolean isTargetBusy() {
        return !this.mimetype || super.isTargetBusy();
    }

    public void close() throws IOException {
        this.mimetype = true;
        super.close();
    }
}

