/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.channel.rendezvous;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.rendezvous.Rendezvous;
import org.walluck.oscar.handlers.SNACHandler;

public class AddInsRendezvous
extends Rendezvous {
    private String url;
    private String message;
    private int code;
    private byte[] uuid;
    private String addIn;
    private String computer;
    private int flags;

    public AddInsRendezvous() {
        this.setService(64);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public byte[] getUUID() {
        return this.uuid;
    }

    public void setUUID(byte[] uuid) {
        this.uuid = uuid;
    }

    public String getAddIn() {
        return this.addIn;
    }

    public void setAddIn(String addIn) {
        this.addIn = addIn;
    }

    public String getCompter() {
        return this.computer;
    }

    public void setComputer(String computer) {
        this.computer = computer;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setRequest() throws IOException {
        TLVChain tlvchain = new TLVChain(3);
        tlvchain.addShort(10, 1);
        tlvchain.addNull(15);
        AIMOutputStream buffer = new AIMOutputStream(2 + this.uuid.length + 2 + 2 + this.addIn.length() + 1 + this.computer.length() + 1 + 4);
        buffer.writeShort(this.code);
        buffer.writeBytes(this.uuid);
        buffer.writeShort(this.addIn.length());
        buffer.writeShort(this.computer.length());
        buffer.writeString0(this.addIn);
        buffer.writeString0(this.computer);
        buffer.writeInt(this.flags);
        tlvchain.addBytes(10001, buffer.getBytes());
        this.setType(0);
        this.setServiceData(tlvchain);
    }

    public void handleServiceData(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, UserInfo userinfo, IncomingIMCH2 args, AIMInputStream buffer) throws IOException {
        TLVChain tlvchain;
        TLV tlv;
        String gamesURL = args.getGamesURL();
        short code = buffer.readShort();
        byte[] uuid = buffer.readBytes(16);
        short gamelen = buffer.readShort();
        short computerlen = buffer.readShort();
        String game = buffer.readString0((short)(gamelen + 1));
        String computer = buffer.readString0((short)(computerlen + 1));
        int flags = buffer.readInt();
        if (buffer.available() > 2 && (tlv = (tlvchain = buffer.readTLVChain(buffer.available())).getTLV(4, 1)) != null) {
            AIMInputStream buffer2 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
            String verifiedIP = buffer2.readIP();
        }
        args.getInfo().setGame(game);
        args.getInfo().setComputer(computer);
    }
}

