/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint.methods;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.sharepoint.Property;
import com.liferay.portal.sharepoint.ResponseElement;
import com.liferay.portal.sharepoint.SharepointException;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.methods.Method;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseMethodImpl
implements Method {
    private static Log _log = LogFactoryUtil.getLog(BaseMethodImpl.class);

    @Override
    public String getRootPath(SharepointRequest sharepointRequest) {
        return "";
    }

    @Override
    public void process(SharepointRequest sharepointRequest) throws SharepointException {
        try {
            this.doProcess(sharepointRequest);
        }
        catch (Exception e2) {
            throw new SharepointException(e2);
        }
    }

    protected void doProcess(SharepointRequest sharepointRequest) throws Exception {
        ServletResponseUtil.write((HttpServletResponse)sharepointRequest.getHttpServletResponse(), (String)this.getResponse(sharepointRequest, false));
    }

    protected abstract List<ResponseElement> getElements(SharepointRequest var1) throws Exception;

    protected String getResponse(SharepointRequest sharepointRequest, boolean appendNewline) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("<html><head><title>vermeer RPC packet</title></head>");
        sb.append("\n");
        sb.append("<body>");
        sb.append("\n");
        Property property = new Property("method", String.valueOf(this.getMethodName()) + ":" + "6.0.2.8117");
        sb.append(property.parse());
        List<ResponseElement> elements = this.getElements(sharepointRequest);
        for (ResponseElement element : elements) {
            sb.append(element.parse());
        }
        sb.append("</body>");
        sb.append("\n");
        sb.append("</html>");
        if (appendNewline) {
            sb.append("\n");
        }
        String html = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Response HTML\n" + html));
        }
        return html;
    }
}

