/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.notifications.thread;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Like;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentNotificationsThread
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(CommentNotificationsThread.class);
    String commenterUserId;
    String commentedFeedId;
    private String commentText;
    private String postOwnerId;
    private NotificationsManager nm;
    private String commentKey;
    private HashSet<String> userIdsToNotify;
    private ArrayList<Like> likes;
    private UserManager userManager;

    public CommentNotificationsThread(DatabookStore storeInstance, UserManager userManager, String commenterUserId, String commentedPostId, String commentText, NotificationsManager nm, String postOwnerId, String commentKey, ArrayList<Like> likes) {
        this.nm = nm;
        this.commenterUserId = commenterUserId;
        this.commentedFeedId = commentedPostId;
        this.commentText = commentText;
        this.postOwnerId = postOwnerId;
        this.commentKey = commentKey;
        this.likes = likes;
        this.userManager = userManager;
        this.userIdsToNotify = new HashSet();
        List postComments = storeInstance.getAllCommentByFeed(commentedPostId);
        for (Comment comment : postComments) {
            if (comment.getUserid().compareTo(commenterUserId) == 0) continue;
            this.userIdsToNotify.add(comment.getUserid());
        }
    }

    @Override
    public void run() {
        String postOwnerFullName = "";
        try {
            postOwnerFullName = this.userManager.getUserByUsername(this.postOwnerId).getFullname();
        }
        catch (Exception e) {
            postOwnerFullName = this.postOwnerId;
        }
        ArrayList<String> favoriteUserIds = new ArrayList<String>();
        for (Like favorite : this.likes) {
            favoriteUserIds.add(favorite.getUserid());
        }
        if (this.userIdsToNotify != null) {
            for (String userId : this.userIdsToNotify) {
                if (userId.compareTo(this.postOwnerId) == 0 || favoriteUserIds.contains(userId)) continue;
                boolean result = this.nm.notifyCommentReply(userId, this.commentedFeedId, this.commentText, postOwnerFullName, this.postOwnerId, this.commentKey);
                _log.trace("Sending Notification for also commented to: " + postOwnerFullName + " result?" + result);
            }
        }
    }
}

