/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatalists.NoSuchRecordVersionException;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordConstants;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.base.DDLRecordLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatalists.util.comparator.DDLRecordVersionVersionComparator;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDLRecordLocalServiceImpl
extends DDLRecordLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public DDLRecord addRecord(long userId, long groupId, long recordSetId, int displayIndex, Fields fields, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        long recordId = this.counterLocalService.increment();
        DDLRecord record = this.ddlRecordPersistence.create(recordId);
        record.setUuid(serviceContext.getUuid());
        record.setGroupId(groupId);
        record.setCompanyId(user.getCompanyId());
        record.setUserId(user.getUserId());
        record.setUserName(user.getFullName());
        record.setVersionUserId(user.getUserId());
        record.setVersionUserName(user.getFullName());
        record.setCreateDate(serviceContext.getCreateDate(now));
        record.setModifiedDate(serviceContext.getModifiedDate(now));
        long ddmStorageId = StorageEngineUtil.create((long)recordSet.getCompanyId(), (long)recordSet.getDDMStructureId(), (Fields)fields, (ServiceContext)serviceContext);
        record.setDDMStorageId(ddmStorageId);
        record.setRecordSetId(recordSetId);
        record.setVersion("1.0");
        record.setDisplayIndex(displayIndex);
        this.ddlRecordPersistence.update((BaseModel)record);
        DDLRecordVersion recordVersion = this.addRecordVersion(user, record, ddmStorageId, "1.0", displayIndex, 2);
        Locale locale = serviceContext.getLocale();
        this.updateAsset(userId, record, recordVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), locale);
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)DDLRecord.class.getName(), (long)recordVersion.getRecordVersionId(), (Object)recordVersion, (ServiceContext)serviceContext);
        return record;
    }

    public DDLRecord addRecord(long userId, long groupId, long recordSetId, int displayIndex, Map<String, Serializable> fieldsMap, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this.toFields(ddmStructure.getStructureId(), fieldsMap);
        return this.ddlRecordLocalService.addRecord(userId, groupId, recordSetId, displayIndex, fields, serviceContext);
    }

    public void deleteRecord(DDLRecord record) throws PortalException, SystemException {
        this.ddlRecordPersistence.remove((BaseModel)record);
        List recordVersions = this.ddlRecordVersionPersistence.findByRecordId(record.getRecordId());
        for (DDLRecordVersion recordVersion : recordVersions) {
            this.ddlRecordVersionPersistence.remove((BaseModel)recordVersion);
            StorageEngineUtil.deleteByClass((long)recordVersion.getDDMStorageId());
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(record.getCompanyId(), record.getGroupId(), DDLRecord.class.getName(), recordVersion.getPrimaryKey());
        }
        this.assetEntryLocalService.deleteEntry(DDLRecord.class.getName(), record.getRecordId());
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DDLRecord.class);
        indexer.delete((Object)record);
    }

    public void deleteRecord(long recordId) throws PortalException, SystemException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        this.deleteRecord(record);
    }

    public DDLRecord deleteRecordLocale(long recordId, Locale locale, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        Fields fields = StorageEngineUtil.getFields((long)record.getDDMStorageId());
        for (Field field : fields) {
            Map valuesMap = field.getValuesMap();
            valuesMap.remove(locale);
        }
        return this.ddlRecordLocalService.updateRecord(serviceContext.getUserId(), recordId, false, 0, fields, false, serviceContext);
    }

    public void deleteRecords(long recordSetId) throws PortalException, SystemException {
        List records = this.ddlRecordPersistence.findByRecordSetId(recordSetId);
        for (DDLRecord record : records) {
            this.deleteRecord(record);
        }
    }

    public DDLRecord fetchRecord(long recordId) throws SystemException {
        return this.ddlRecordPersistence.fetchByPrimaryKey(recordId);
    }

    public List<DDLRecord> getCompanyRecords(long companyId, int status, int scope, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddlRecordFinder.findByC_S_S(companyId, status, scope, start, end, orderByComparator);
    }

    public List<DDLRecord> getCompanyRecords(long companyId, int scope, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.getCompanyRecords(companyId, -1, scope, start, end, orderByComparator);
    }

    public int getCompanyRecordsCount(long companyId, int scope) throws SystemException {
        return this.getCompanyRecordsCount(companyId, -1, scope);
    }

    public int getCompanyRecordsCount(long companyId, int status, int scope) throws SystemException {
        return this.ddlRecordFinder.countByC_S_S(companyId, status, scope);
    }

    public DDLRecordVersion getLatestRecordVersion(long recordId) throws PortalException, SystemException {
        List recordVersions = this.ddlRecordVersionPersistence.findByRecordId(recordId);
        if (recordVersions.isEmpty()) {
            throw new NoSuchRecordVersionException("No record versions found for recordId " + recordId);
        }
        recordVersions = ListUtil.copy((List)recordVersions);
        Collections.sort(recordVersions, new DDLRecordVersionVersionComparator());
        return (DDLRecordVersion)recordVersions.get(0);
    }

    public Long[] getMinAndMaxCompanyRecordIds(long companyId, int status, int scope) throws SystemException {
        return this.ddlRecordFinder.findByC_S_S_MinAndMax(companyId, status, scope);
    }

    public List<DDLRecord> getMinAndMaxCompanyRecords(long companyId, int status, int scope, long minRecordId, long maxRecordId) throws SystemException {
        return this.ddlRecordFinder.findByC_S_S_MinAndMax(companyId, status, scope, minRecordId, maxRecordId);
    }

    public DDLRecord getRecord(long recordId) throws PortalException, SystemException {
        return this.ddlRecordPersistence.findByPrimaryKey(recordId);
    }

    public List<DDLRecord> getRecords(long recordSetId) throws SystemException {
        return this.ddlRecordPersistence.findByRecordSetId(recordSetId);
    }

    public List<DDLRecord> getRecords(long recordSetId, int status, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddlRecordFinder.findByR_S(recordSetId, status, start, end, orderByComparator);
    }

    public List<DDLRecord> getRecords(long recordSetId, long userId) throws SystemException {
        return this.ddlRecordPersistence.findByR_U(recordSetId, userId);
    }

    public int getRecordsCount(long recordSetId, int status) throws SystemException {
        return this.ddlRecordFinder.countByR_S(recordSetId, status);
    }

    public DDLRecordVersion getRecordVersion(long recordVersionId) throws PortalException, SystemException {
        return this.ddlRecordVersionPersistence.findByPrimaryKey(recordVersionId);
    }

    public DDLRecordVersion getRecordVersion(long recordId, String version) throws PortalException, SystemException {
        return this.ddlRecordVersionPersistence.findByR_V(recordId, version);
    }

    public List<DDLRecordVersion> getRecordVersions(long recordId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddlRecordVersionPersistence.findByRecordId(recordId, start, end, orderByComparator);
    }

    public int getRecordVersionsCount(long recordId) throws SystemException {
        return this.ddlRecordVersionPersistence.countByRecordId(recordId);
    }

    public void revertRecordVersion(long userId, long recordId, String version, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordVersion recordVersion = this.getRecordVersion(recordId, version);
        if (!recordVersion.isApproved()) {
            return;
        }
        Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
        this.ddlRecordLocalService.updateRecord(userId, recordId, true, recordVersion.getDisplayIndex(), fields, false, serviceContext);
    }

    public Hits search(SearchContext searchContext) throws SystemException {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DDLRecord.class);
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public void updateAsset(long userId, DDLRecord record, DDLRecordVersion recordVersion, long[] assetCategoryIds, String[] assetTagNames, Locale locale) throws PortalException, SystemException {
        boolean addDraftAssetEntry = false;
        boolean visible = true;
        if (recordVersion != null && !recordVersion.isApproved()) {
            int approvedRecordVersionsCount;
            String version = recordVersion.getVersion();
            if (!version.equals("1.0") && (approvedRecordVersionsCount = this.ddlRecordVersionPersistence.countByR_S(record.getRecordId(), 0)) > 0) {
                addDraftAssetEntry = true;
            }
            visible = false;
        }
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        String ddmStructureName = ddmStructure.getName(locale);
        String recordSetName = recordSet.getName(locale);
        String title = LanguageUtil.format((Locale)locale, (String)"new-x-for-list-x", (Object[])new Object[]{ddmStructureName, recordSetName});
        if (addDraftAssetEntry) {
            this.assetEntryLocalService.updateEntry(userId, record.getGroupId(), record.getCreateDate(), record.getModifiedDate(), DDLRecordConstants.getClassName(), recordVersion.getRecordVersionId(), record.getUuid(), 0L, assetCategoryIds, assetTagNames, false, null, null, null, "text/html", title, null, "", null, null, 0, 0, null, false);
        } else {
            this.assetEntryLocalService.updateEntry(userId, record.getGroupId(), record.getCreateDate(), record.getModifiedDate(), DDLRecordConstants.getClassName(), record.getRecordId(), record.getUuid(), 0L, assetCategoryIds, assetTagNames, visible, null, null, null, "text/html", title, null, "", null, null, 0, 0, null, false);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDLRecord updateRecord(long userId, long recordId, boolean majorVersion, int displayIndex, Fields fields, boolean mergeFields, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        record.setModifiedDate(serviceContext.getModifiedDate(null));
        this.ddlRecordPersistence.update((BaseModel)record);
        DDLRecordVersion recordVersion = record.getLatestRecordVersion();
        if (recordVersion.isApproved()) {
            DDLRecordSet recordSet = record.getRecordSet();
            if (mergeFields) {
                Fields existingFields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
                fields = DDMUtil.mergeFields((Fields)fields, (Fields)existingFields);
            }
            long ddmStorageId = StorageEngineUtil.create((long)recordSet.getCompanyId(), (long)recordSet.getDDMStructureId(), (Fields)fields, (ServiceContext)serviceContext);
            String version = this.getNextVersion(recordVersion.getVersion(), majorVersion, serviceContext.getWorkflowAction());
            recordVersion = this.addRecordVersion(user, record, ddmStorageId, version, displayIndex, 2);
        } else {
            StorageEngineUtil.update((long)recordVersion.getDDMStorageId(), (Fields)fields, (boolean)mergeFields, (ServiceContext)serviceContext);
            String version = recordVersion.getVersion();
            this.updateRecordVersion(user, recordVersion, version, displayIndex, recordVersion.getStatus(), serviceContext);
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)record.getGroupId(), (long)userId, (String)DDLRecord.class.getName(), (long)recordVersion.getRecordVersionId(), (Object)recordVersion, (ServiceContext)serviceContext);
        return record;
    }

    public DDLRecord updateRecord(long userId, long recordId, int displayIndex, Map<String, Serializable> fieldsMap, boolean mergeFields, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this.toFields(ddmStructure.getStructureId(), fieldsMap);
        return this.ddlRecordLocalService.updateRecord(userId, recordId, false, displayIndex, fields, mergeFields, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDLRecord updateStatus(long userId, long recordVersionId, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DDLRecordVersion recordVersion = this.ddlRecordVersionPersistence.findByPrimaryKey(recordVersionId);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(new Date());
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion);
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordVersion.getRecordId());
        if (status == 0) {
            if (DLUtil.compareVersions((String)record.getVersion(), (String)recordVersion.getVersion()) <= 0) {
                record.setDDMStorageId(recordVersion.getDDMStorageId());
                record.setVersion(recordVersion.getVersion());
                record.setRecordSetId(recordVersion.getRecordSetId());
                record.setDisplayIndex(recordVersion.getDisplayIndex());
                record.setVersion(recordVersion.getVersion());
                record.setVersionUserId(recordVersion.getUserId());
                record.setVersionUserName(recordVersion.getUserName());
                record.setModifiedDate(recordVersion.getCreateDate());
                this.ddlRecordPersistence.update((BaseModel)record);
            }
        } else if (Validator.equals((Object)record.getVersion(), (Object)recordVersion.getVersion())) {
            String newVersion = "1.0";
            List approvedRecordVersions = this.ddlRecordVersionPersistence.findByR_S(record.getRecordId(), 0);
            if (!approvedRecordVersions.isEmpty()) {
                newVersion = ((DDLRecordVersion)approvedRecordVersions.get(0)).getVersion();
            }
            record.setVersion(newVersion);
            this.ddlRecordPersistence.update((BaseModel)record);
        }
        return record;
    }

    protected DDLRecordVersion addRecordVersion(User user, DDLRecord record, long ddmStorageId, String version, int displayIndex, int status) throws SystemException {
        long recordVersionId = this.counterLocalService.increment();
        DDLRecordVersion recordVersion = this.ddlRecordVersionPersistence.create(recordVersionId);
        recordVersion.setGroupId(record.getGroupId());
        recordVersion.setCompanyId(record.getCompanyId());
        recordVersion.setUserId(user.getUserId());
        recordVersion.setUserName(user.getFullName());
        recordVersion.setCreateDate(record.getModifiedDate());
        recordVersion.setDDMStorageId(ddmStorageId);
        recordVersion.setRecordSetId(record.getRecordSetId());
        recordVersion.setRecordId(record.getRecordId());
        recordVersion.setVersion(version);
        recordVersion.setDisplayIndex(displayIndex);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(record.getModifiedDate());
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion);
        return recordVersion;
    }

    protected String getNextVersion(String version, boolean majorVersion, int workflowAction) {
        if (workflowAction == 2) {
            majorVersion = false;
        }
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return String.valueOf(versionParts[0]) + "." + versionParts[1];
    }

    protected Fields toFields(long ddmStructureId, Map<String, Serializable> fieldsMap) {
        Fields fields = new Fields();
        for (String name : fieldsMap.keySet()) {
            String value = String.valueOf(fieldsMap.get(name));
            Field field = new Field(ddmStructureId, name, (Serializable)((Object)value));
            fields.put(field);
        }
        return fields;
    }

    protected void updateRecordVersion(User user, DDLRecordVersion recordVersion, String version, int displayIndex, int status, ServiceContext serviceContext) throws SystemException {
        recordVersion.setUserId(user.getUserId());
        recordVersion.setUserName(user.getFullName());
        recordVersion.setVersion(version);
        recordVersion.setDisplayIndex(displayIndex);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(serviceContext.getModifiedDate(null));
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion);
    }
}

