/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.PluginSetting;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.PluginSettingImpl;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.base.PluginSettingLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;

public class PluginSettingLocalServiceImpl
extends PluginSettingLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(PluginSettingLocalServiceImpl.class);

    public void checkPermission(long userId, String pluginId, String pluginType) throws PortalException {
        if (!this.hasPermission(userId, pluginId, pluginType)) {
            throw new PrincipalException();
        }
    }

    public PluginSetting getDefaultPluginSetting() {
        PluginSettingImpl pluginSetting = new PluginSettingImpl();
        pluginSetting.setRoles("");
        pluginSetting.setActive(true);
        return pluginSetting;
    }

    public PluginSetting getPluginSetting(long companyId, String pluginId, String pluginType) throws SystemException {
        PluginSetting pluginSetting = this.pluginSettingPersistence.fetchByC_I_T(companyId, pluginId, pluginType);
        if (pluginSetting != null) {
            return pluginSetting;
        }
        LayoutTemplate plugin = null;
        if (pluginType.equals("layouttpl")) {
            plugin = this.layoutTemplateLocalService.getLayoutTemplate(pluginId, false, null);
        } else if (pluginType.equals("theme")) {
            boolean wapTheme = true;
            plugin = this.themeLocalService.getTheme(companyId, pluginId, wapTheme);
        }
        if (plugin == null || plugin.getDefaultPluginSetting() == null) {
            pluginSetting = this.getDefaultPluginSetting();
            pluginSetting.setCompanyId(companyId);
        } else {
            pluginSetting = plugin.getDefaultPluginSetting(companyId);
        }
        return pluginSetting;
    }

    public boolean hasPermission(long userId, String pluginId, String pluginType) {
        try {
            User user = this.userPersistence.findByPrimaryKey(userId);
            PluginSetting pluginSetting = this.getPluginSetting(user.getCompanyId(), pluginId, pluginType);
            return pluginSetting.hasPermission(userId);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Could not check permissions for " + pluginId), (Throwable)e2);
            }
            return false;
        }
    }

    public PluginSetting updatePluginSetting(long companyId, String pluginId, String pluginType, String roles, boolean active) throws SystemException {
        PluginSetting pluginSetting = this.pluginSettingPersistence.fetchByC_I_T(companyId, pluginId = PortalUtil.getJsSafePortletId((String)pluginId), pluginType);
        if (pluginSetting == null) {
            long pluginSettingId = this.counterLocalService.increment();
            pluginSetting = this.pluginSettingPersistence.create(pluginSettingId);
            pluginSetting.setCompanyId(companyId);
            pluginSetting.setPluginId(pluginId);
            pluginSetting.setPluginType(pluginType);
        }
        pluginSetting.setRoles(roles);
        pluginSetting.setActive(active);
        this.pluginSettingPersistence.update((BaseModel)pluginSetting);
        return pluginSetting;
    }
}

