/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LayoutPrototypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.MissingReferenceException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchLayoutPrototypeException;
import com.liferay.portal.NoSuchLayoutSetPrototypeException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataContextListener;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.DeletionSystemEventImporter;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionImporter;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.lar.PortletImporter;
import com.liferay.portal.lar.ThemeImporter;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;

public class LayoutImporter {
    private static Log _log = LogFactoryUtil.getLog(LayoutImporter.class);
    private DeletionSystemEventImporter _deletionSystemEventImporter = new DeletionSystemEventImporter();
    private Element _headerElement;
    private List<Element> _layoutElements;
    private Element _layoutsElement;
    private PermissionImporter _permissionImporter = new PermissionImporter();
    private PortletImporter _portletImporter = new PortletImporter();
    private Element _rootElement;
    private ThemeImporter _themeImporter = new ThemeImporter();

    public static Map<String, Boolean> getImportPortletControlsMap(long companyId, String portletId, Map<String, String[]> parameterMap, Element portletDataElement, ManifestSummary manifestSummary) throws Exception {
        boolean importPortletConfiguration = MapUtil.getBoolean(parameterMap, (String)"PORTLET_CONFIGURATION");
        boolean importPortletConfigurationAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_CONFIGURATION_ALL");
        boolean importPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean importPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Import portlet data " + importPortletData));
            _log.debug((Object)("Import all portlet data " + importPortletDataAll));
            _log.debug((Object)("Import portlet configuration " + importPortletConfiguration));
        }
        boolean importCurPortletData = importPortletData;
        String rootPortletId = ExportImportHelperUtil.getExportableRootPortletId((long)companyId, (String)portletId);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null || portletDataElement == null && !portletDataHandler.isDisplayPortlet()) {
            importCurPortletData = false;
        } else if (importPortletDataAll) {
            importCurPortletData = true;
        } else if (rootPortletId != null) {
            importCurPortletData = importPortletData && MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + rootPortletId));
        }
        boolean importCurPortletArchivedSetups = importPortletConfiguration;
        boolean importCurPortletConfiguration = importPortletConfiguration;
        boolean importCurPortletSetup = importPortletConfiguration;
        boolean importCurPortletUserPreferences = importPortletConfiguration;
        if (importPortletConfigurationAll) {
            importCurPortletConfiguration = true;
            if (manifestSummary != null && manifestSummary.getConfigurationPortletOptions(rootPortletId) == null) {
                importCurPortletConfiguration = false;
            }
            importCurPortletArchivedSetups = importCurPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS_ALL");
            importCurPortletSetup = importCurPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP_ALL");
            importCurPortletUserPreferences = importCurPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES_ALL");
        } else if (rootPortletId != null) {
            importCurPortletConfiguration = importPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)("PORTLET_CONFIGURATION_" + rootPortletId));
            importCurPortletArchivedSetups = importCurPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)("PORTLET_ARCHIVED_SETUPS_" + rootPortletId));
            importCurPortletSetup = importCurPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)("PORTLET_SETUP_" + rootPortletId));
            importCurPortletUserPreferences = importCurPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)("PORTLET_USER_PREFERENCES_" + rootPortletId));
        }
        HashMap<String, Boolean> importPortletControlsMap = new HashMap<String, Boolean>();
        importPortletControlsMap.put("PORTLET_ARCHIVED_SETUPS", importCurPortletArchivedSetups);
        importPortletControlsMap.put("PORTLET_CONFIGURATION", importCurPortletConfiguration);
        importPortletControlsMap.put("PORTLET_DATA", importCurPortletData);
        importPortletControlsMap.put("PORTLET_SETUP", importCurPortletSetup);
        importPortletControlsMap.put("PORTLET_USER_PREFERENCES", importCurPortletUserPreferences);
        return importPortletControlsMap;
    }

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        try {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)true);
            this.doImportLayouts(userId, groupId, privateLayout, parameterMap, file);
        }
        finally {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
            CacheUtil.clearCache();
            JournalContentUtil.clearCache();
            PermissionCacheUtil.clearCache();
        }
    }

    public MissingReferences validateFile(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        ZipReader zipReader = null;
        try {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)true);
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
            zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
            PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)layoutSet.getCompanyId(), (long)groupId, parameterMap, null, (ZipReader)zipReader);
            this.validateFile(portletDataContext);
            MissingReferences missingReferences = ExportImportHelperUtil.validateMissingReferences((long)userId, (long)groupId, parameterMap, (File)file);
            Map dependencyMissingReferences = missingReferences.getDependencyMissingReferences();
            if (!dependencyMissingReferences.isEmpty()) {
                throw new MissingReferenceException(missingReferences);
            }
            MissingReferences missingReferences2 = missingReferences;
            return missingReferences2;
        }
        finally {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)false);
            if (zipReader != null) {
                zipReader.close();
            }
        }
    }

    protected void deleteMissingLayouts(List<String> sourceLayoutUuids, List<Layout> previousLayouts, ServiceContext serviceContext) throws Exception {
        if (_log.isDebugEnabled() && !sourceLayoutUuids.isEmpty()) {
            _log.debug((Object)"Delete missing layouts");
        }
        for (Layout layout : previousLayouts) {
            if (sourceLayoutUuids.contains(layout.getUuid())) continue;
            try {
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)false, (ServiceContext)serviceContext);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
    }

    protected void doImportLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        UnicodeProperties settingsProperties;
        String mergeFailFriendlyURLLayouts;
        Element missingReferencesElement;
        boolean deleteMissingLayouts = MapUtil.getBoolean(parameterMap, (String)"DELETE_MISSING_LAYOUTS", (boolean)Boolean.TRUE);
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean importPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importLogo = MapUtil.getBoolean(parameterMap, (String)"LOGO");
        boolean importLayoutSetSettings = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_SETTINGS");
        boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED");
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isLayoutSetPrototype()) {
            layoutSetPrototypeLinkEnabled = false;
        }
        String layoutsImportMode = MapUtil.getString(parameterMap, (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete portlet data " + deletePortletData));
            _log.debug((Object)("Import categories " + importCategories));
            _log.debug((Object)("Import permissions " + importPermissions));
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LayoutCache layoutCache = new LayoutCache();
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        User user = UserUtil.findByPrimaryKey((long)userId);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(userId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        UserIdStrategy strategy = this._portletImporter.getUserIdStrategy(user, userIdStrategy);
        ManifestSummary manifestSummary = ExportImportHelperUtil.getManifestSummary((long)userId, (long)groupId, parameterMap, (File)file);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)companyId, (long)groupId, parameterMap, (UserIdStrategy)strategy, (ZipReader)zipReader);
        portletDataContext.setManifestSummary(manifestSummary);
        portletDataContext.setPortetDataContextListener((PortletDataContextListener)new PortletDataContextListenerImpl(portletDataContext));
        portletDataContext.setPrivateLayout(privateLayout);
        this.validateFile(portletDataContext);
        long sourceCompanyId = GetterUtil.getLong((String)this._headerElement.attributeValue("company-id"));
        portletDataContext.setSourceCompanyId(sourceCompanyId);
        long sourceCompanyGroupId = GetterUtil.getLong((String)this._headerElement.attributeValue("company-group-id"));
        portletDataContext.setSourceCompanyGroupId(sourceCompanyGroupId);
        long sourceGroupId = GetterUtil.getLong((String)this._headerElement.attributeValue("group-id"));
        portletDataContext.setSourceGroupId(sourceGroupId);
        long sourceUserPersonalSiteGroupId = GetterUtil.getLong((String)this._headerElement.attributeValue("user-personal-site-group-id"));
        portletDataContext.setSourceUserPersonalSiteGroupId(sourceUserPersonalSiteGroupId);
        String layoutSetPrototypeUuid = this._layoutsElement.attributeValue("layout-set-prototype-uuid");
        String larType = this._headerElement.attributeValue("type");
        if (group.isLayoutPrototype() && larType.equals("layout-prototype")) {
            deleteMissingLayouts = false;
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototype((long)group.getClassPK());
            String layoutPrototypeUuid = GetterUtil.getString((String)this._headerElement.attributeValue("type-uuid"));
            LayoutPrototype existingLayoutPrototype = null;
            if (Validator.isNotNull((String)layoutPrototypeUuid)) {
                try {
                    existingLayoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId((String)layoutPrototypeUuid, (long)companyId);
                }
                catch (NoSuchLayoutPrototypeException noSuchLayoutPrototypeException) {}
            }
            if (existingLayoutPrototype == null) {
                List layouts = LayoutLocalServiceUtil.getLayoutsByLayoutPrototypeUuid((String)layoutPrototype.getUuid());
                layoutPrototype.setUuid(layoutPrototypeUuid);
                LayoutPrototypeLocalServiceUtil.updateLayoutPrototype((LayoutPrototype)layoutPrototype);
                for (Layout layout : layouts) {
                    layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
                    LayoutLocalServiceUtil.updateLayout((Layout)layout);
                }
            }
        } else if (group.isLayoutSetPrototype() && larType.equals("layout-set-prototype")) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            String importedLayoutSetPrototypeUuid = GetterUtil.getString((String)this._headerElement.attributeValue("type-uuid"));
            LayoutSetPrototype existingLayoutSetPrototype = null;
            if (Validator.isNotNull((String)importedLayoutSetPrototypeUuid)) {
                try {
                    existingLayoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)importedLayoutSetPrototypeUuid, (long)companyId);
                }
                catch (NoSuchLayoutSetPrototypeException noSuchLayoutSetPrototypeException) {}
            }
            if (existingLayoutSetPrototype == null) {
                layoutSetPrototype.setUuid(importedLayoutSetPrototypeUuid);
                LayoutSetPrototypeLocalServiceUtil.updateLayoutSetPrototype((LayoutSetPrototype)layoutSetPrototype);
            }
        } else if (larType.equals("layout-set-prototype")) {
            layoutSetPrototypeUuid = GetterUtil.getString((String)this._headerElement.attributeValue("type-uuid"));
        }
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            layoutSet.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
            layoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
        if ((missingReferencesElement = this._rootElement.element("missing-references")) != null) {
            portletDataContext.setMissingReferencesElement(missingReferencesElement);
        }
        this._deletionSystemEventImporter.importDeletionSystemEvents(portletDataContext);
        if (importLogo) {
            String logoPath = this._headerElement.attributeValue("logo-path");
            byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(logoPath);
            if (ArrayUtil.isNotEmpty((byte[])iconBytes)) {
                LayoutSetLocalServiceUtil.updateLogo((long)groupId, (boolean)privateLayout, (boolean)true, (byte[])iconBytes);
            } else {
                LayoutSetLocalServiceUtil.updateLogo((long)groupId, (boolean)privateLayout, (boolean)false, null);
            }
        }
        this._themeImporter.importTheme(portletDataContext, layoutSet);
        if (importLayoutSetSettings) {
            String settings = GetterUtil.getString((String)this._headerElement.elementText("settings"));
            LayoutSetLocalServiceUtil.updateSettings((long)groupId, (boolean)privateLayout, (String)settings);
        }
        Element portletsElement = this._rootElement.element("portlets");
        List portletElements = portletsElement.elements("portlet");
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            ArrayList<String> portletIds = new ArrayList<String>();
            for (Element portletElement : portletElements) {
                String portletId = portletElement.attributeValue("portlet-id");
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
                if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
                portletIds.add(portletId);
            }
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"layout", (String[])portletIds.toArray(new String[portletIds.size()]), (ManifestSummary)manifestSummary);
        }
        if (importPermissions) {
            for (Element portletElement : portletElements) {
                String portletPath = portletElement.attributeValue("path");
                Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
                this._permissionImporter.checkRoles(layoutCache, companyId, groupId, userId, portletDocument.getRootElement());
            }
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        this._portletImporter.readAssetCategories(portletDataContext);
        this._portletImporter.readAssetTags(portletDataContext);
        this._portletImporter.readComments(portletDataContext);
        this._portletImporter.readExpandoTables(portletDataContext);
        this._portletImporter.readLocks(portletDataContext);
        this._portletImporter.readRatingsEntries(portletDataContext);
        List previousLayouts = LayoutUtil.findByG_P((long)groupId, (boolean)privateLayout);
        if (Validator.isNotNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)companyId);
            for (Layout layout : previousLayouts) {
                Layout sourcePrototypeLayout;
                String sourcePrototypeLayoutUuid = layout.getSourcePrototypeLayoutUuid();
                if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid()) || (sourcePrototypeLayout = LayoutUtil.fetchByUUID_G_P((String)sourcePrototypeLayoutUuid, (long)layoutSetPrototype.getGroupId(), (boolean)true)) != null) continue;
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)false, (ServiceContext)serviceContext);
            }
        }
        ArrayList<String> sourceLayoutsUuids = new ArrayList<String>();
        ArrayList<Layout> newLayouts = new ArrayList<Layout>();
        if (_log.isDebugEnabled() && this._layoutElements.size() > 0) {
            _log.debug((Object)"Importing layouts");
        }
        for (Element layoutElement : this._layoutElements) {
            this.importLayout(portletDataContext, sourceLayoutsUuids, newLayouts, layoutElement);
        }
        Map newLayoutsMap = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        if (deletePortletData) {
            if (_log.isDebugEnabled() && portletElements.size() > 0) {
                _log.debug((Object)"Deleting portlet data");
            }
            for (Element portletElement : portletElements) {
                String portletId = portletElement.attributeValue("portlet-id");
                long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
                long plid = 0L;
                Layout layout = (Layout)newLayoutsMap.get(layoutId);
                if (layout != null) {
                    plid = layout.getPlid();
                }
                portletDataContext.setPlid(plid);
                this._portletImporter.deletePortletData(portletDataContext, portletId, plid);
            }
        }
        if (_log.isDebugEnabled() && portletElements.size() > 0) {
            _log.debug((Object)"Importing portlets");
        }
        for (Element portletElement : portletElements) {
            String portletPath = portletElement.attributeValue("path");
            String portletId = portletElement.attributeValue("portlet-id");
            long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
            long oldPlid = GetterUtil.getLong((String)portletElement.attributeValue("old-plid"));
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
            if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
            Layout layout = (Layout)newLayoutsMap.get(layoutId);
            long plid = 0L;
            if (layout != null) {
                plid = layout.getPlid();
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setOldPlid(oldPlid);
            if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"portlet", (String)portletId, (ManifestSummary)manifestSummary);
            }
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
            portletElement = portletDocument.getRootElement();
            this.setPortletScope(portletDataContext, portletElement);
            long portletPreferencesGroupId = groupId;
            Element portletDataElement = portletElement.element("portlet-data");
            Map<String, Boolean> importPortletControlsMap = LayoutImporter.getImportPortletControlsMap(companyId, portletId, parameterMap, portletDataElement, manifestSummary);
            try {
                portletDataContext.setRootPortletId(PortletConstants.getRootPortletId((String)portletId));
                if (layout != null) {
                    portletPreferencesGroupId = layout.getGroupId();
                }
                this._portletImporter.importPortletPreferences(portletDataContext, layoutSet.getCompanyId(), portletPreferencesGroupId, layout, null, portletElement, false, importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), importPortletControlsMap.get("PORTLET_DATA"), importPortletControlsMap.get("PORTLET_SETUP"), importPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
                if (importPortletControlsMap.get("PORTLET_DATA").booleanValue()) {
                    this._portletImporter.importPortletData(portletDataContext, portletId, plid, portletDataElement);
                }
            }
            finally {
                portletDataContext.setRootPortletId("");
                this._portletImporter.resetPortletScope(portletDataContext, portletPreferencesGroupId);
            }
            if (importPermissions) {
                this._permissionImporter.importPortletPermissions(layoutCache, companyId, groupId, userId, layout, portletElement, portletId);
            }
            this._portletImporter.importPortletPreferences(portletDataContext, layoutSet.getCompanyId(), groupId, null, null, portletElement, false, importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), importPortletControlsMap.get("PORTLET_DATA"), importPortletControlsMap.get("PORTLET_SETUP"), importPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
        }
        this._portletImporter.readAssetLinks(portletDataContext);
        if (deleteMissingLayouts) {
            this.deleteMissingLayouts(sourceLayoutsUuids, previousLayouts, serviceContext);
        }
        layoutSet = LayoutSetLocalServiceUtil.updatePageCount((long)groupId, (boolean)privateLayout);
        GroupLocalServiceUtil.updateSite((long)groupId, (boolean)true);
        long lastMergeTime = System.currentTimeMillis();
        for (Layout layout : newLayouts) {
            boolean modifiedTypeSettingsProperties = false;
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            String articleId = typeSettingsProperties.getProperty("article-id");
            if (Validator.isNotNull((String)articleId)) {
                Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
                typeSettingsProperties.setProperty("article-id", MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId));
                modifiedTypeSettingsProperties = true;
            }
            if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
                typeSettingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
                modifiedTypeSettingsProperties = true;
            }
            if (!modifiedTypeSettingsProperties) continue;
            LayoutUtil.update((Layout)layout);
        }
        if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE") && Validator.isNull((String)(mergeFailFriendlyURLLayouts = (settingsProperties = layoutSet.getSettingsProperties()).getProperty("merge-fail-friendly-url-layouts")))) {
            settingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
        this.updateLayoutPriorities(portletDataContext, this._layoutElements, privateLayout);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing layouts takes " + stopWatch.getTime() + " ms"));
        }
        zipReader.close();
        ExportImportHelperUtil.reindex((PortletDataContext)portletDataContext, (long)userId);
    }

    protected void importLayout(PortletDataContext portletDataContext, List<String> sourceLayoutsUuids, List<Layout> newLayouts, Element layoutElement) throws Exception {
        String action = layoutElement.attributeValue("action");
        if (!action.equals("skip")) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)layoutElement);
            List portletDataContextNewLayouts = portletDataContext.getNewLayouts();
            newLayouts.addAll(portletDataContextNewLayouts);
            portletDataContextNewLayouts.clear();
        }
        if (!action.equals("delete")) {
            sourceLayoutsUuids.add(layoutElement.attributeValue("uuid"));
        }
    }

    protected void readXML(PortletDataContext portletDataContext) throws Exception {
        if (this._rootElement != null && this._headerElement != null && this._layoutsElement != null && this._layoutElements != null) {
            return;
        }
        String xml = portletDataContext.getZipEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException("manifest.xml not found in the LAR");
        }
        try {
            Document document = SAXReaderUtil.read((String)xml);
            this._rootElement = document.getRootElement();
            portletDataContext.setImportDataRootElement(this._rootElement);
        }
        catch (Exception e2) {
            throw new LARFileException((Throwable)e2);
        }
        this._headerElement = this._rootElement.element("header");
        this._layoutsElement = portletDataContext.getImportDataGroupElement(Layout.class);
        this._layoutElements = this._layoutsElement.elements();
    }

    protected void setPortletScope(PortletDataContext portletDataContext, Element portletElement) {
        String scopeLayoutUuid = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-uuid"));
        String scopeLayoutType = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-type"));
        portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
        portletDataContext.setScopeType(scopeLayoutType);
        try {
            Group scopeGroup;
            block14: {
                scopeGroup = null;
                if (scopeLayoutType.equals("company")) {
                    scopeGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                } else if (Validator.isNotNull((String)scopeLayoutUuid)) {
                    Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)portletDataContext.getGroupId(), (boolean)portletDataContext.isPrivateLayout());
                    if (scopeLayout.hasScopeGroup()) {
                        scopeGroup = scopeLayout.getScopeGroup();
                    } else {
                        String name = String.valueOf(scopeLayout.getPlid());
                        scopeGroup = GroupLocalServiceUtil.addGroup((long)portletDataContext.getUserId(null), (long)0L, (String)Layout.class.getName(), (long)scopeLayout.getPlid(), (long)0L, (String)name, null, (int)0, (boolean)true, (int)0, null, (boolean)false, (boolean)true, null);
                    }
                    Group group = scopeLayout.getGroup();
                    if (group.isStaged() && !group.isStagedRemotely()) {
                        try {
                            boolean privateLayout = GetterUtil.getBoolean((String)portletElement.attributeValue("private-layout"));
                            Layout oldLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)portletDataContext.getSourceGroupId(), (boolean)privateLayout);
                            Group oldScopeGroup = oldLayout.getScopeGroup();
                            if (group.isStagingGroup()) {
                                scopeGroup.setLiveGroupId(oldScopeGroup.getGroupId());
                                GroupLocalServiceUtil.updateGroup((Group)scopeGroup);
                            } else {
                                oldScopeGroup.setLiveGroupId(scopeGroup.getGroupId());
                                GroupLocalServiceUtil.updateGroup((Group)oldScopeGroup);
                            }
                        }
                        catch (NoSuchLayoutException nsle) {
                            if (!_log.isWarnEnabled()) break block14;
                            _log.warn((Throwable)nsle);
                        }
                    }
                }
            }
            if (scopeGroup != null) {
                portletDataContext.setScopeGroupId(scopeGroup.getGroupId());
            }
        }
        catch (PortalException portalException) {
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected void updateLayoutPriorities(PortletDataContext portletDataContext, List<Element> layoutElements, boolean privateLayout) throws SystemException {
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        HashMap<Long, Integer> layoutPriorities = new HashMap<Long, Integer>();
        int maxPriority = Integer.MIN_VALUE;
        for (Element layoutElement : layoutElements) {
            long layoutId;
            Layout layout;
            String action = layoutElement.attributeValue("action");
            if (action.equals("skip")) {
                return;
            }
            if (!action.equals("add") || (layout = (Layout)layouts.get(layoutId = GetterUtil.getLong((String)layoutElement.attributeValue("layout-id")))) == null) continue;
            int layoutPriority = GetterUtil.getInteger((String)layoutElement.attributeValue("layout-priority"));
            layoutPriorities.put(layout.getPlid(), layoutPriority);
            if (maxPriority >= layoutPriority) continue;
            maxPriority = layoutPriority;
        }
        List layoutSetLayouts = LayoutLocalServiceUtil.getLayouts((long)portletDataContext.getGroupId(), (boolean)privateLayout);
        for (Layout layout : layoutSetLayouts) {
            if (layoutPriorities.containsKey(layout.getPlid())) {
                layout.setPriority(((Integer)layoutPriorities.get(layout.getPlid())).intValue());
            } else {
                layout.setPriority(++maxPriority);
            }
            LayoutLocalServiceUtil.updateLayout((Layout)layout);
        }
    }

    protected void validateFile(PortletDataContext portletDataContext) throws Exception {
        this.readXML(portletDataContext);
        int buildNumber = ReleaseInfo.getBuildNumber();
        int importBuildNumber = GetterUtil.getInteger((String)this._headerElement.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String larType = this._headerElement.attributeValue("type");
        if (!(larType.equals("layout-prototype") || larType.equals("layout-set") || larType.equals("layout-set-prototype"))) {
            throw new LARTypeException(larType);
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)portletDataContext.getGroupId());
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE");
        if (larType.equals("layout-prototype") && !group.isLayoutPrototype() && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            throw new LARTypeException("A page template can only be imported to a page template");
        }
        if (larType.equals("layout-set") && (group.isLayoutPrototype() || group.isLayoutSetPrototype())) {
            throw new LARTypeException("A site can only be imported to a site");
        }
        if (larType.equals("layout-set-prototype") && !group.isLayoutSetPrototype() && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            throw new LARTypeException("A site template can only be imported to a site template");
        }
        Locale[] sourceAvailableLocales = LocaleUtil.fromLanguageIds((String[])StringUtil.split((String)this._headerElement.attributeValue("available-locales")));
        Object[] targetAvailableLocales = LanguageUtil.getAvailableLocales((long)portletDataContext.getScopeGroupId());
        Locale[] localeArray = sourceAvailableLocales;
        int n = sourceAvailableLocales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale sourceAvailableLocale = localeArray[n2];
            if (!ArrayUtil.contains((Object[])targetAvailableLocales, (Object)sourceAvailableLocale)) {
                LocaleException le = new LocaleException(2);
                le.setSourceAvailableLocales(sourceAvailableLocales);
                le.setTargetAvailableLocales((Locale[])targetAvailableLocales);
                throw le;
            }
            ++n2;
        }
        this.validateLayoutPrototypes(portletDataContext.getCompanyId(), this._layoutsElement, this._layoutElements);
    }

    protected void validateLayoutPrototypes(long companyId, Element layoutsElement, List<Element> layoutElements) throws Exception {
        ArrayList<Tuple> missingLayoutPrototypes = new ArrayList<Tuple>();
        String layoutSetPrototypeUuid = layoutsElement.attributeValue("layout-set-prototype-uuid");
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            try {
                LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)companyId);
            }
            catch (NoSuchLayoutSetPrototypeException noSuchLayoutSetPrototypeException) {
                String layoutSetPrototypeName = layoutsElement.attributeValue("layout-set-prototype-name");
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutSetPrototype.class.getName(), layoutSetPrototypeUuid, layoutSetPrototypeName}));
            }
        }
        for (Element layoutElement : layoutElements) {
            String layoutPrototypeUuid;
            String action = layoutElement.attributeValue("action");
            if (action.equals("skip") || !Validator.isNotNull((String)(layoutPrototypeUuid = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-uuid"))))) continue;
            try {
                LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId((String)layoutPrototypeUuid, (long)companyId);
            }
            catch (NoSuchLayoutPrototypeException noSuchLayoutPrototypeException) {
                String layoutPrototypeName = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-name"));
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutPrototype.class.getName(), layoutPrototypeUuid, layoutPrototypeName}));
            }
        }
        if (!missingLayoutPrototypes.isEmpty()) {
            throw new LayoutPrototypeException(missingLayoutPrototypes);
        }
    }
}

