/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.user;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.user.DefaultUserProfile;
import com.ecyrd.jspwiki.auth.user.UserDatabase;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import com.ecyrd.jspwiki.util.CryptoUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Properties;
import java.util.UUID;
import org.apache.catalina.util.HexUtils;
import org.apache.log4j.Logger;

public abstract class AbstractUserDatabase
implements UserDatabase {
    protected static final Logger log = Logger.getLogger(AbstractUserDatabase.class);
    protected static final String SHA_PREFIX = "{SHA}";
    protected static final String SSHA_PREFIX = "{SSHA}";

    public synchronized void commit() throws WikiSecurityException {
    }

    public UserProfile find(String index) throws NoSuchPrincipalException {
        UserProfile profile = null;
        try {
            profile = this.findByFullName(index);
        }
        catch (NoSuchPrincipalException e) {
            // empty catch block
        }
        if (profile != null) {
            return profile;
        }
        try {
            profile = this.findByWikiName(index);
        }
        catch (NoSuchPrincipalException e) {
            // empty catch block
        }
        if (profile != null) {
            return profile;
        }
        try {
            profile = this.findByLoginName(index);
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        if (profile != null) {
            return profile;
        }
        throw new NoSuchPrincipalException("Not in database: " + index);
    }

    public abstract UserProfile findByEmail(String var1) throws NoSuchPrincipalException;

    public abstract UserProfile findByFullName(String var1) throws NoSuchPrincipalException;

    public abstract UserProfile findByLoginName(String var1) throws NoSuchPrincipalException;

    public abstract UserProfile findByWikiName(String var1) throws NoSuchPrincipalException;

    public Principal[] getPrincipals(String identifier) throws NoSuchPrincipalException {
        UserProfile profile = this.findByLoginName(identifier);
        ArrayList<WikiPrincipal> principals = new ArrayList<WikiPrincipal>();
        if (profile.getLoginName() != null && profile.getLoginName().length() > 0) {
            principals.add(new WikiPrincipal(profile.getLoginName(), "loginName"));
        }
        if (profile.getFullname() != null && profile.getFullname().length() > 0) {
            principals.add(new WikiPrincipal(profile.getFullname(), "fullName"));
        }
        if (profile.getWikiName() != null && profile.getWikiName().length() > 0) {
            principals.add(new WikiPrincipal(profile.getWikiName(), "wikiName"));
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    public abstract void initialize(WikiEngine var1, Properties var2) throws NoRequiredPropertyException;

    public UserProfile newProfile() {
        return DefaultUserProfile.newProfile(this);
    }

    public abstract void save(UserProfile var1) throws WikiSecurityException;

    public boolean validatePassword(String loginName, String password) {
        try {
            String hashedPassword;
            boolean verified;
            UserProfile profile = this.findByLoginName(loginName);
            String storedPassword = profile.getPassword();
            boolean newPasswordFormat = storedPassword.startsWith(SSHA_PREFIX);
            if (newPasswordFormat) {
                String hashedPassword2 = this.getHash(password);
                return CryptoUtil.verifySaltedPassword(password.getBytes("UTF-8"), storedPassword);
            }
            if (storedPassword.startsWith(SHA_PREFIX)) {
                storedPassword = storedPassword.substring(SHA_PREFIX.length());
            }
            if (verified = (hashedPassword = this.getOldHash(password)).equals(storedPassword)) {
                profile.setPassword(password);
                this.save(profile);
            }
            return verified;
        }
        catch (NoSuchPrincipalException e) {
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Unsupported algorithm: " + e.getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)"You do not have UTF-8!?!");
        }
        catch (WikiSecurityException e) {
            log.error((Object)("Could not upgrade SHA password to SSHA because profile could not be saved. Reason: " + e.getMessage()));
            e.printStackTrace();
        }
        return false;
    }

    protected static String generateUid(UserDatabase db) {
        boolean collision;
        String uid = null;
        do {
            uid = UUID.randomUUID().toString();
            collision = true;
            try {
                db.findByUid(uid);
            }
            catch (NoSuchPrincipalException e) {
                collision = false;
            }
        } while (collision || uid == null);
        return uid;
    }

    protected String getHash(String text) {
        String hash = null;
        try {
            hash = CryptoUtil.getSaltedPassword(text.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Error creating salted SHA password hash:" + e.getMessage()));
            hash = text;
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)"You do not have UTF-8!?!");
        }
        return hash;
    }

    protected String getOldHash(String text) {
        String hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(text.getBytes("UTF-8"));
            byte[] digestedBytes = md.digest();
            hash = HexUtils.convert(digestedBytes);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Error creating SHA password hash:" + e.getMessage()));
            hash = text;
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)"UTF-8 not supported!?!");
        }
        return hash;
    }

    protected long parseLong(String value) {
        if (value == null || value.length() == 0) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

