/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Type {
    private final String name;
    private final Type nestedType;
    private final boolean primitive;
    private static final Set primitives;

    public static Type newSimpleType(String name) {
        if (name == null) {
            throw new NullPointerException("type");
        }
        if (name.indexOf("[") >= 0 || name.indexOf("]") >= 0) {
            throw new IllegalArgumentException("Name can not contain '[' or ']' " + name);
        }
        return new Type(name, null);
    }

    public static Type newArrayType(String type, int dimensions) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (dimensions < 1) {
            throw new IllegalArgumentException("dimensions must be atleast one");
        }
        StringBuffer buf = new StringBuffer(type.length() + dimensions * 2);
        buf.append(type);
        for (int i = 0; i < dimensions; ++i) {
            buf.append("[]");
        }
        return new Type(buf.toString(), Type.newSimpleType(type));
    }

    public static Type newCollectionType(String collectionType, Type elementType) {
        if (collectionType == null) {
            throw new NullPointerException("collectionType");
        }
        if (elementType == null) {
            throw new NullPointerException("elementType");
        }
        return new Type(collectionType, elementType);
    }

    private Type(String name, Type nestedType) {
        this.name = name;
        this.nestedType = nestedType;
        this.primitive = nestedType == null && primitives.contains(name);
    }

    public String getName() {
        return this.name;
    }

    public Type getNestedType() {
        return this.nestedType;
    }

    public boolean isCollection() {
        return this.nestedType != null;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("boolean");
        set.add("byte");
        set.add("char");
        set.add("short");
        set.add("int");
        set.add("long");
        set.add("float");
        set.add("double");
        primitives = Collections.unmodifiableSet(set);
    }
}

