/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.persistence;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryActionableDynamicQuery;

public class DLFileEntryExportActionableDynamicQuery
extends DLFileEntryActionableDynamicQuery {
    private PortletDataContext _portletDataContext;

    public DLFileEntryExportActionableDynamicQuery(PortletDataContext portletDataContext) throws SystemException {
        this._portletDataContext = portletDataContext;
        this.setCompanyId(this._portletDataContext.getCompanyId());
        this.setGroupId(this._portletDataContext.getScopeGroupId());
    }

    @Override
    public long performCount() throws PortalException, SystemException {
        ManifestSummary manifestSummary = this._portletDataContext.getManifestSummary();
        StagedModelType stagedModelType = this.getStagedModelType();
        long modelAdditionCount = super.performCount();
        manifestSummary.addModelAdditionCount(stagedModelType.toString(), modelAdditionCount);
        long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount(this._portletDataContext, stagedModelType);
        manifestSummary.addModelDeletionCount(stagedModelType.toString(), modelDeletionCount);
        return modelAdditionCount;
    }

    @Override
    protected void addCriteria(DynamicQuery dynamicQuery) {
        this._portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
        if (this.getStagedModelType().getReferrerClassNameId() >= 0L) {
            Property classNameIdProperty = PropertyFactoryUtil.forName("classNameId");
            dynamicQuery.add(classNameIdProperty.eq(this.getStagedModelType().getReferrerClassNameId()));
        }
    }

    protected StagedModelType getStagedModelType() {
        return new StagedModelType(PortalUtil.getClassNameId(DLFileEntry.class.getName()));
    }

    @Override
    protected void performAction(Object object) throws PortalException, SystemException {
        DLFileEntry stagedModel = (DLFileEntry)object;
        StagedModelDataHandlerUtil.exportStagedModel(this._portletDataContext, stagedModel);
    }
}

