/*
 * Decompiled with CFR 0.152.
 */
package com.megginson.sax.rdf;

import com.megginson.sax.rdf.RDFFilter;
import com.megginson.sax.rdf.RDFHandler;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class RDFReader
implements ErrorHandler {
    StringBuffer xmlBuffer;
    XMLReader rdfReader;
    RDFHandler rdfHandler;
    ContentHandler contentHandler;
    ErrorHandler errorHandler;

    public RDFReader() {
        String string = System.getProperty("org.xml.sax.driver");
        if (string == null) {
            String string2 = System.getProperty("org.xml.sax.parser", "com.microstar.xml.SAXDriver");
            try {
                Parser parser = ParserFactory.makeParser(string2);
                this.init(new ParserAdapter(parser));
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot create SAX parser");
            }
        }
        try {
            this.init(XMLReaderFactory.createXMLReader(string));
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Cannot create SAX parser");
        }
    }

    public RDFReader(XMLReader xMLReader) {
        this.init(xMLReader);
    }

    public RDFReader(Parser parser) {
        this.init(new ParserAdapter(parser));
    }

    private void init(XMLReader xMLReader) {
        this.rdfReader = xMLReader;
        try {
            this.rdfReader.setFeature("http://megginson.com/sax/features/rdf", true);
        }
        catch (SAXException sAXException) {
            this.rdfReader = new RDFFilter(xMLReader);
        }
        this.contentHandler = null;
        this.errorHandler = null;
        this.rdfHandler = null;
    }

    public void readRDF(String string) throws IOException, SAXException {
        this.setupParse();
        this.rdfReader.parse(string);
    }

    public void readRDF(Reader reader) throws IOException, SAXException {
        this.setupParse();
        this.rdfReader.parse(new InputSource(reader));
    }

    private void setupParse() throws SAXException {
        if (this.rdfHandler != null) {
            this.rdfReader.setProperty("http://megginson.com/sax/properties/rdf-handler", this.rdfHandler);
        }
        if (this.contentHandler != null) {
            this.rdfReader.setContentHandler(this.contentHandler);
        }
        this.rdfReader.setErrorHandler(this);
    }

    public void setRDFHandler(RDFHandler rDFHandler) {
        this.rdfHandler = rDFHandler;
    }

    public RDFHandler getRDFHandler() {
        return this.rdfHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(sAXParseException);
        } else {
            System.err.println("*** WARNING: " + sAXParseException.getMessage());
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler == null) {
            throw sAXParseException;
        }
        this.errorHandler.error(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler == null) {
            throw sAXParseException;
        }
        this.errorHandler.error(sAXParseException);
    }
}

