/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.policies;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceAccess {
    private String serviceClass;
    private String name;
    private String serviceId;
    private HashMap<String, String> serviceSpecificPolices;

    public ServiceAccess() {
    }

    public ServiceAccess(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public ServiceAccess(String name, String serviceClass) {
        this(serviceClass);
        this.name = name;
    }

    public ServiceAccess(String name, String serviceClass, String serviceId) {
        this(name, serviceClass);
        this.serviceId = serviceId;
    }

    public boolean isSubsetOf(ServiceAccess access) {
        if (this.equals(access)) {
            return true;
        }
        if (access.getServiceClass() == null) {
            return true;
        }
        if (access.getServiceClass().equals(this.serviceClass)) {
            if (access.getName() == null) {
                return true;
            }
            if (access.getName().equals(this.name) && access.getServiceId() == null) {
                return true;
            }
        }
        return false;
    }

    public String getAsString() {
        if (this.serviceClass == null) {
            return "*";
        }
        StringBuilder toReturn = new StringBuilder(this.serviceClass);
        if (this.name == null) {
            return toReturn.append(":").append("*").toString();
        }
        toReturn.append(":").append(this.name);
        if (this.serviceId == null && (this.serviceSpecificPolices == null || this.serviceSpecificPolices.size() == 0)) {
            return toReturn.append(":").append("*").toString();
        }
        if (this.serviceId != null) {
            toReturn.append(":").append(this.serviceId);
        }
        if (this.serviceSpecificPolices != null && this.serviceSpecificPolices.size() != 0) {
            toReturn.append("{");
            for (Map.Entry<String, String> entry : this.serviceSpecificPolices.entrySet()) {
                toReturn.append(entry.getKey()).append(":").append(entry.getValue());
            }
            toReturn.append("}");
        }
        return toReturn.toString();
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.serviceClass == null ? 0 : this.serviceClass.hashCode());
        result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        result = 31 * result + (this.serviceSpecificPolices == null ? 0 : this.serviceSpecificPolices.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceAccess other = (ServiceAccess)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.serviceClass == null ? other.serviceClass != null : !this.serviceClass.equals(other.serviceClass)) {
            return false;
        }
        if (this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId)) {
            return false;
        }
        return !(this.serviceSpecificPolices == null ? other.serviceSpecificPolices != null : !this.serviceSpecificPolices.equals(other.serviceSpecificPolices));
    }

    public String toString() {
        return this.getAsString();
    }
}

