/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.calls.interceptors;

import java.util.Base64;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.calls.Call;
import org.gcube.common.calls.Interceptor;
import org.gcube.common.calls.Request;
import org.gcube.common.calls.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(AuthorizationInterceptor.class);
    public static final String token_header = "gcube-token";
    public static final String uma_token_header = "Authorization";
    public static final String user_header = "d4s-user";

    @Override
    public void handleRequest(Request request, Call call) {
        String token = SecurityTokenProvider.instance.get();
        String accessToken = AccessTokenProvider.instance.get();
        if (accessToken != null) {
            request.addHeader(uma_token_header, "Bearer " + accessToken);
            this.logger.trace("uma token set");
            try {
                request.addHeader(user_header, AuthorizationInterceptor.getUserFromToken(accessToken));
            }
            catch (Throwable e) {
                this.logger.warn("errror setting {} header", (Object)user_header);
            }
        } else {
            this.logger.warn("uma token is not set");
        }
        if (token == null) {
            this.logger.warn("security token is not set");
        } else {
            request.addHeader(token_header, token);
            this.logger.trace("security token set in the header is  " + token);
        }
    }

    @Override
    public void handleResponse(Response context, Call callContext) {
    }

    private static String getUserFromToken(String accessToken) throws Exception {
        String realAccessTokenEncoded = accessToken.split("\\.")[1];
        String decodedAccessPart = new String(Base64.getDecoder().decode(realAccessTokenEncoded.getBytes()));
        ObjectMapper mapper = new ObjectMapper();
        AccessTokenJSON tokenMapped = (AccessTokenJSON)mapper.readValue(decodedAccessPart, AccessTokenJSON.class);
        String userName = Base64.getEncoder().encodeToString(tokenMapped.getUsername().getBytes());
        return userName;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class AccessTokenJSON {
        @JsonProperty(value="preferred_username")
        private String username;

        private AccessTokenJSON() {
        }

        public String getUsername() {
            return this.username;
        }
    }
}

