/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.logging.Log;

public class JDKLogImpl
implements Log {
    private final Logger logger;

    public JDKLogImpl(String category) {
        this.logger = Logger.getLogger(category);
    }

    public JDKLogImpl(Class category) {
        this.logger = Logger.getLogger(category.getName());
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void trace(String msg) {
        this.logger.log(Level.FINER, msg);
    }

    @Override
    public void trace(Object msg) {
        this.logger.log(Level.FINER, msg.toString());
    }

    @Override
    public void debug(String msg) {
        this.logger.log(Level.FINE, msg);
    }

    @Override
    public void info(String msg) {
        this.logger.log(Level.INFO, msg);
    }

    @Override
    public void warn(String msg) {
        this.logger.log(Level.WARNING, msg);
    }

    @Override
    public void error(String msg) {
        this.logger.log(Level.SEVERE, msg);
    }

    @Override
    public void fatal(String msg) {
        this.logger.log(Level.SEVERE, msg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logger.log(Level.FINER, msg, t);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logger.log(Level.FINE, msg, t);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logger.log(Level.WARNING, msg, t);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logger.log(Level.SEVERE, msg, t);
    }

    @Override
    public void fatal(String msg, Throwable t) {
        this.logger.log(Level.SEVERE, msg, t);
    }

    @Override
    public String getLevel() {
        Level level = this.logger.getLevel();
        return level != null ? level.toString() : "off";
    }

    @Override
    public void setLevel(String level) {
        Level new_level = JDKLogImpl.strToLevel(level);
        if (new_level != null) {
            this.logger.setLevel(new_level);
        }
    }

    private static Level strToLevel(String level) {
        if (level == null) {
            return null;
        }
        if ((level = level.toLowerCase().trim()).equals("fatal")) {
            return Level.SEVERE;
        }
        if (level.equals("error")) {
            return Level.SEVERE;
        }
        if (level.equals("warn")) {
            return Level.WARNING;
        }
        if (level.equals("warning")) {
            return Level.WARNING;
        }
        if (level.equals("info")) {
            return Level.INFO;
        }
        if (level.equals("debug")) {
            return Level.FINE;
        }
        if (level.equals("trace")) {
            return Level.FINER;
        }
        return null;
    }
}

