/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.operation.DownloadOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadAndLock
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String localPath;
    private String remotePath;
    private OutputStream os;

    public DownloadAndLock(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" DOWNLOAD " + myFile.getRemotePath() + " in bucket: " + this.getBucket());
        }
        DownloadOperator download = new DownloadOperator(this.getServer(), this.getUser(), this.getPassword(), this.getBucket(), this.getMonitor(), this.isChunk(), this.getBackendType(), this.getDbNames());
        try {
            this.get(download, myFile, true);
        }
        catch (Exception e) {
            TransportManager tm = this.getTransport(myFile);
            tm.close();
            throw new RemoteBackendException(" Error in downloadAndLock operation ", e.getCause());
        }
        return null;
    }

    @Override
    public String initOperation(MyFile file, String RemotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        this.localPath = file.getLocalPath();
        this.remotePath = this.remotePath;
        return this.getRemoteIdentifier(this.remotePath, rootArea);
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }
}

