/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.model.User;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpSession;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.portal.oidc.lr62.JWTCacheProxy;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;

public class IntraVMJWTCacheProxy
extends JWTCacheProxy {
    private Map<String, String> oidcTokens = Collections.synchronizedMap(new TreeMap());
    private Map<String, String> rptTokens = Collections.synchronizedMap(new TreeMap());

    protected IntraVMJWTCacheProxy() {
    }

    @Override
    public void setOIDCToken(User user, HttpSession session, JWTToken token) {
        this.oidcTokens.put(this.generateKey(user, session), JWTTokenUtil.getRawContent(token));
    }

    @Override
    public void setUMAToken(User user, HttpSession session, JWTToken token) {
        this.rptTokens.put(this.generateKey(user, session), JWTTokenUtil.getRawContent(token));
    }

    @Override
    public JWTToken getOIDCToken(User user, HttpSession session) {
        return JWTTokenUtil.fromString(this.oidcTokens.get(this.generateKey(user, session)));
    }

    @Override
    public JWTToken getUMAToken(User user, HttpSession session) {
        return JWTTokenUtil.fromString(this.rptTokens.get(this.generateKey(user, session)));
    }

    @Override
    public void removeOIDCToken(User user, HttpSession session) {
        this.oidcTokens.remove(this.generateKey(user, session));
    }

    @Override
    public void removeUMAToken(User user, HttpSession session) {
        this.rptTokens.remove(this.generateKey(user, session));
    }

    @Override
    public void clearOIDCTokens() {
        this.oidcTokens.clear();
    }

    @Override
    public void clearUMATokens() {
        this.rptTokens.clear();
    }

    @Override
    public void clearAllTokens() {
        this.clearOIDCTokens();
        this.clearUMATokens();
    }
}

