/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.management.DataStoreGarbageCollector;
import org.apache.jackrabbit.api.management.RepositoryManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.core.data.GarbageCollector;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;

public class RepositoryManagerImpl
implements RepositoryManager {
    private final TransientRepository tr;

    RepositoryManagerImpl(TransientRepository tr) {
        this.tr = tr;
    }

    public DataStoreGarbageCollector createDataStoreGarbageCollector() throws RepositoryException {
        RepositoryImpl rep = this.tr.getRepository();
        if (rep == null) {
            throw new RepositoryException("Repository is stopped");
        }
        ArrayList<PersistenceManager> pmList = new ArrayList<PersistenceManager>();
        InternalVersionManagerImpl vm = (InternalVersionManagerImpl)rep.getVersionManager();
        PersistenceManager pm = vm.getPersistenceManager();
        pmList.add(pm);
        String[] wspNames = rep.getWorkspaceNames();
        Session[] sessions = new Session[wspNames.length];
        for (int i = 0; i < wspNames.length; ++i) {
            String wspName = wspNames[i];
            RepositoryImpl.WorkspaceInfo wspInfo = rep.getWorkspaceInfo(wspName);
            SystemSession session = SystemSession.create(rep, wspInfo.getConfig());
            rep.onSessionCreated(session);
            wspInfo.initialize();
            sessions[i] = session;
            pm = wspInfo.getPersistenceManager();
            pmList.add(pm);
        }
        IterablePersistenceManager[] ipmList = new IterablePersistenceManager[pmList.size()];
        for (int i = 0; i < pmList.size(); ++i) {
            pm = (PersistenceManager)pmList.get(i);
            if (!(pm instanceof IterablePersistenceManager)) {
                ipmList = null;
                break;
            }
            ipmList[i] = (IterablePersistenceManager)pm;
        }
        GarbageCollector gc = new GarbageCollector(rep, null, ipmList, sessions);
        return gc;
    }

    public void stop() {
        this.tr.shutdown();
    }
}

