/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.amazonrankings.util;

import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.amazonrankings.util.AmazonRankingsUtil;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AmazonSignedRequestsUtil {
    private static final String _HMAC_SHA256_ALGORITHM = "HmacSHA256";

    public static String generateUrlWithSignature(Map<String, String> parameters) throws Exception {
        String canonicalizedParameters = AmazonSignedRequestsUtil._canonicalizeParameters(parameters);
        String signature = AmazonSignedRequestsUtil._generateSignature("GET\necs.amazonaws.com\n/onca/xml\n" + canonicalizedParameters);
        return "http://ecs.amazonaws.com/onca/xml?" + canonicalizedParameters + "&Signature=" + signature;
    }

    private static String _canonicalizeParameters(Map<String, String> parameters) throws Exception {
        if (parameters.isEmpty()) {
            return "";
        }
        parameters = new TreeMap<String, String>(parameters);
        Set<Map.Entry<String, String>> parametersSet = parameters.entrySet();
        StringBundler sb = new StringBundler(parametersSet.size() * 4);
        for (Map.Entry<String, String> parameter : parametersSet) {
            sb.append(AmazonSignedRequestsUtil._rfc3986Encode(parameter.getKey()));
            sb.append("=");
            sb.append(AmazonSignedRequestsUtil._rfc3986Encode(parameter.getValue()));
            sb.append("&");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    private static String _generateSignature(String data) throws Exception {
        String amazonSecretAccessKey = AmazonRankingsUtil.getAmazonSecretAccessKey();
        if (Validator.isNull((String)amazonSecretAccessKey)) {
            return "";
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(amazonSecretAccessKey.getBytes(), _HMAC_SHA256_ALGORITHM);
        Mac mac = Mac.getInstance(_HMAC_SHA256_ALGORITHM);
        mac.init(secretKeySpec);
        byte[] bytes = mac.doFinal(data.getBytes());
        String signature = Base64.encode((byte[])bytes);
        return StringUtil.replace((String)signature, (String[])new String[]{"=", "+"}, (String[])new String[]{"%3D", "%2B"});
    }

    private static String _rfc3986Encode(String string) throws Exception {
        if (Validator.isNull((String)string)) {
            return "";
        }
        string = URLEncoder.encode(string, "UTF-8");
        string = StringUtil.replace((String)string, (String[])new String[]{"*", "+", "%7E"}, (String[])new String[]{"%2A", "%2B", "~"});
        return string;
    }
}

