/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.Comparator;
import java.util.List;

public abstract class BinarySearch<E> {
    public static <T extends Comparable<T>> BinarySearch<T> forList(final List<T> list) {
        return new BinarySearch<T>(){

            @Override
            protected int compare(int index, T e) {
                return ((Comparable)list.get(index)).compareTo(e);
            }

            @Override
            protected int getLastIndex() {
                return list.size() - 1;
            }
        };
    }

    public static <T> BinarySearch<T> forList(final List<T> list, final Comparator<T> comparator) {
        return new BinarySearch<T>(){

            @Override
            protected int compare(int index, T e) {
                return comparator.compare(list.get(index), e);
            }

            @Override
            protected int getLastIndex() {
                return list.size() - 1;
            }
        };
    }

    public int find(E e) {
        return this.find(e, 0, this.getLastIndex());
    }

    public int find(E e, int low) {
        return this.find(e, low, this.getLastIndex());
    }

    public int find(E e, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            int delta = this.compare(mid, e);
            if (delta < 0) {
                low = mid + 1;
                continue;
            }
            if (delta > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int findFirst(E e) {
        return this.findFirst(e, 0, this.getLastIndex());
    }

    public int findFirst(E e, int low) {
        return this.findFirst(e, low, this.getLastIndex());
    }

    public int findFirst(E e, int low, int high) {
        int index = -1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int delta = this.compare(mid, e);
            if (delta < 0) {
                low = mid + 1;
                continue;
            }
            if (delta == 0) {
                index = mid;
            }
            high = mid - 1;
        }
        if (index == -1) {
            return -(low + 1);
        }
        return index;
    }

    public int findLast(E e) {
        return this.findLast(e, 0, this.getLastIndex());
    }

    public int findLast(E e, int low) {
        return this.findLast(e, low, this.getLastIndex());
    }

    public int findLast(E e, int low, int high) {
        int index = -1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int delta = this.compare(mid, e);
            if (delta > 0) {
                high = mid - 1;
                continue;
            }
            if (delta == 0) {
                index = mid;
            }
            low = mid + 1;
        }
        if (index == -1) {
            return -(low + 1);
        }
        return index;
    }

    protected abstract int compare(int var1, E var2);

    protected abstract int getLastIndex();
}

