/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.bsf;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.jruby.Ruby;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyEngine
extends BSFEngineImpl {
    private Ruby runtime;
    private RubyRuntimeAdapter evaler = JavaEmbedUtils.newRuntimeAdapter();

    public Object apply(String file2, int line, int col, Object funcBody, Vector paramNames, Vector args2) {
        ThreadContext context = this.runtime.getCurrentContext();
        try {
            String[] names2 = new String[paramNames.size()];
            paramNames.toArray(names2);
            context.preBsfApply(names2);
            DynamicScope scope = context.getCurrentScope();
            int size2 = args2.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                scope.setValue(i2, JavaEmbedUtils.javaToRuby(this.runtime, args2.get(i2)), 0);
            }
            Object object = JavaEmbedUtils.rubyToJava(this.evaler.parse(this.runtime, funcBody.toString(), file2, line).run());
            Object var13_14 = null;
            context.postBsfApply();
            return object;
        }
        catch (StackOverflowError soe) {
            try {
                throw context.getRuntime().newSystemStackError("stack level too deep", soe);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                context.postBsfApply();
                throw throwable;
            }
        }
    }

    public Object eval(String file2, int line, int col, Object expr) throws BSFException {
        try {
            return JavaEmbedUtils.rubyToJava(this.evaler.parse(this.runtime, expr.toString(), file2, line).run());
        }
        catch (Exception excptn) {
            throw new BSFException(100, "Exception", (Throwable)excptn);
        }
    }

    public void exec(String file2, int line, int col, Object expr) throws BSFException {
        try {
            this.evaler.parse(this.runtime, expr.toString(), file2, line).run();
        }
        catch (Exception excptn) {
            throw new BSFException(100, "Exception", (Throwable)excptn);
        }
    }

    public Object call(Object recv2, String method2, Object[] args2) throws BSFException {
        try {
            return JavaEmbedUtils.invokeMethod(this.runtime, recv2, method2, args2, Object.class);
        }
        catch (Exception excptn) {
            throw new BSFException(100, excptn.getMessage(), (Throwable)excptn);
        }
    }

    public void initialize(BSFManager manager, String language, Vector someDeclaredBeans) throws BSFException {
        super.initialize(manager, language, someDeclaredBeans);
        this.runtime = JavaEmbedUtils.initialize(this.getClassPath(manager));
        int size2 = someDeclaredBeans.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            BSFDeclaredBean bean = (BSFDeclaredBean)someDeclaredBeans.elementAt(i2);
            this.runtime.getGlobalVariables().define(GlobalVariable.variableName(bean.name), new BeanGlobalVariable(this.runtime, bean));
        }
        this.runtime.getGlobalVariables().defineReadonly("$bsf", new FunctionsGlobalVariable(this.runtime, new BSFFunctions(manager, (BSFEngine)this)));
    }

    private List getClassPath(BSFManager manager) {
        return Arrays.asList(manager.getClassPath().split(System.getProperty("path.separator")));
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        this.runtime.getGlobalVariables().define(GlobalVariable.variableName(bean.name), new BeanGlobalVariable(this.runtime, bean));
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.runtime.getGlobalVariables().set(GlobalVariable.variableName(bean.name), this.runtime.getNil());
    }

    public void handleException(BSFException bsfExcptn) {
        JRubyEngine.printException(this.runtime, (Exception)bsfExcptn.getTargetException());
    }

    private static void printException(Ruby runtime2, Exception exception2) {
        if (exception2 instanceof RaiseException) {
            JumpException je = (JumpException)exception2;
            if (je instanceof RaiseException) {
                runtime2.printError(((RaiseException)je).getException());
            } else if (je instanceof JumpException.BreakJump) {
                runtime2.getErrorStream().println("break without block.");
            } else if (je instanceof JumpException.ReturnJump) {
                runtime2.getErrorStream().println("return without block.");
            }
        }
    }

    public void terminate() {
        JavaEmbedUtils.terminate(this.runtime);
        this.runtime = null;
        super.terminate();
    }

    private static class FunctionsGlobalVariable
    implements IAccessor {
        private Ruby runtime;
        private BSFFunctions functions;

        public FunctionsGlobalVariable(Ruby runtime2, BSFFunctions functions) {
            this.runtime = runtime2;
            this.functions = functions;
        }

        public IRubyObject getValue() {
            IRubyObject result2 = JavaUtil.convertJavaToRuby(this.runtime, this.functions, BSFFunctions.class);
            return result2 instanceof JavaObject ? Java.wrap(this.runtime, result2) : result2;
        }

        public IRubyObject setValue(IRubyObject value2) {
            return value2;
        }
    }

    private static class BeanGlobalVariable
    implements IAccessor {
        private Ruby runtime;
        private BSFDeclaredBean bean;

        public BeanGlobalVariable(Ruby runtime2, BSFDeclaredBean bean) {
            this.runtime = runtime2;
            this.bean = bean;
        }

        public IRubyObject getValue() {
            IRubyObject result2 = JavaUtil.convertJavaToRuby(this.runtime, this.bean.bean, this.bean.type);
            return result2 instanceof JavaObject ? Java.wrap(this.runtime, result2) : result2;
        }

        public IRubyObject setValue(IRubyObject value2) {
            this.bean.bean = value2.toJava(Object.class);
            return value2;
        }
    }
}

