/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;

@JRubyModule(name={"Marshal"})
public class RubyMarshal {
    public static RubyModule createMarshalModule(Ruby runtime2) {
        RubyModule module = runtime2.defineModule("Marshal");
        runtime2.setMarshal(module);
        module.defineAnnotatedMethods(RubyMarshal.class);
        module.defineConstant("MAJOR_VERSION", runtime2.newFixnum(4));
        module.defineConstant("MINOR_VERSION", runtime2.newFixnum(8));
        return module;
    }

    @JRubyMethod(required=1, optional=2, module=true)
    public static IRubyObject dump(IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime2 = recv2.getRuntime();
        IRubyObject objectToDump = args2[0];
        IRubyObject io2 = null;
        int depthLimit = -1;
        if (args2.length >= 2) {
            if (args2[1].respondsTo("write")) {
                io2 = args2[1];
            } else if (args2[1] instanceof RubyFixnum) {
                depthLimit = (int)((RubyFixnum)args2[1]).getLongValue();
            } else {
                throw runtime2.newTypeError("Instance of IO needed");
            }
            if (args2.length == 3) {
                depthLimit = (int)args2[2].convertToInteger().getLongValue();
            }
        }
        try {
            if (io2 != null) {
                RubyMarshal.dumpToStream(runtime2, objectToDump, RubyMarshal.outputStream(runtime2.getCurrentContext(), io2), depthLimit);
                return io2;
            }
            ByteArrayOutputStream stringOutput = new ByteArrayOutputStream();
            boolean[] taintUntrust = RubyMarshal.dumpToStream(runtime2, objectToDump, stringOutput, depthLimit);
            RubyString result2 = RubyString.newString(runtime2, new ByteList(stringOutput.toByteArray()));
            if (taintUntrust[0]) {
                result2.setTaint(true);
            }
            if (taintUntrust[1]) {
                result2.setUntrusted(true);
            }
            return result2;
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    private static OutputStream outputStream(ThreadContext context, IRubyObject out) {
        RubyMarshal.setBinmodeIfPossible(context, out);
        return new IOOutputStream(out);
    }

    private static void setBinmodeIfPossible(ThreadContext context, IRubyObject io2) {
        if (io2.respondsTo("binmode")) {
            io2.callMethod(context, "binmode");
        }
    }

    @JRubyMethod(name={"load", "restore"}, required=1, optional=1, module=true)
    public static IRubyObject load(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject in = args2[0];
        IRubyObject proc2 = args2.length == 2 ? args2[1] : null;
        try {
            InputStream rawInput;
            boolean untrusted;
            boolean tainted;
            IRubyObject v = in.checkStringType();
            if (!v.isNil()) {
                tainted = in.isTaint();
                untrusted = in.isUntrusted();
                ByteList bytes2 = ((RubyString)v).getByteList();
                rawInput = new ByteArrayInputStream(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
            } else if (in.respondsTo("getc") && in.respondsTo("read")) {
                tainted = true;
                untrusted = true;
                rawInput = RubyMarshal.inputStream(context, in);
            } else {
                throw runtime2.newTypeError("instance of IO needed");
            }
            return new UnmarshalStream(runtime2, rawInput, proc2, tainted, untrusted).unmarshalObject();
        }
        catch (EOFException e) {
            if (in.respondsTo("to_str")) {
                throw runtime2.newArgumentError("marshal data too short");
            }
            throw runtime2.newEOFError();
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    private static InputStream inputStream(ThreadContext context, IRubyObject in) {
        RubyMarshal.setBinmodeIfPossible(context, in);
        return new IOInputStream(in);
    }

    private static boolean[] dumpToStream(Ruby runtime2, IRubyObject object, OutputStream rawOutput, int depthLimit) throws IOException {
        MarshalStream output = new MarshalStream(runtime2, rawOutput, depthLimit);
        output.dumpObject(object);
        return new boolean[]{output.isTainted(), output.isUntrusted()};
    }
}

