/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;

public class QueryState {
    private final ClientState clientState;
    private volatile UUID preparedTracingSession;

    public QueryState(ClientState clientState) {
        this.clientState = clientState;
    }

    public static QueryState forInternalCalls() {
        return new QueryState(ClientState.forInternalCalls());
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public long getTimestamp() {
        return this.clientState.getTimestamp();
    }

    public boolean traceNextQuery() {
        if (this.preparedTracingSession != null) {
            return true;
        }
        double traceProbability = StorageService.instance.getTraceProbability();
        return traceProbability != 0.0 && ThreadLocalRandom.current().nextDouble() < traceProbability;
    }

    public void prepareTracingSession(UUID sessionId) {
        this.preparedTracingSession = sessionId;
    }

    public void createTracingSession() {
        UUID session = this.preparedTracingSession;
        if (session == null) {
            Tracing.instance.newSession();
        } else {
            Tracing.instance.newSession(session);
            this.preparedTracingSession = null;
        }
    }

    public InetAddress getClientAddress() {
        return this.clientState.isInternal ? null : this.clientState.getRemoteAddress().getAddress();
    }
}

