/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.SortedMap;
import org.apache.cassandra.hadoop.AbstractColumnFamilyInputFormat;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.ReporterWrapper;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ColumnFamilyInputFormat
extends AbstractColumnFamilyInputFormat<ByteBuffer, SortedMap<ByteBuffer, ColumnFamilyRecordReader.Column>> {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilyInputFormat.class);

    public static Cassandra.Client createAuthenticatedClient(String location, int port, Configuration conf) throws Exception {
        TTransport transport;
        logger.trace("Creating authenticated client for CF input format");
        try {
            transport = ConfigHelper.getClientTransportFactory(conf).openTransport(location, port);
        }
        catch (Exception e) {
            throw new TTransportException("Failed to open a transport to " + location + ":" + port + ".", (Throwable)e);
        }
        TBinaryProtocol binaryProtocol = new TBinaryProtocol(transport, true, true);
        Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
        client.set_keyspace(ConfigHelper.getInputKeyspace(conf));
        if (ConfigHelper.getInputKeyspaceUserName(conf) != null && ConfigHelper.getInputKeyspacePassword(conf) != null) {
            HashMap<String, String> creds = new HashMap<String, String>();
            creds.put("username", ConfigHelper.getInputKeyspaceUserName(conf));
            creds.put("password", ConfigHelper.getInputKeyspacePassword(conf));
            AuthenticationRequest authRequest = new AuthenticationRequest(creds);
            client.login(authRequest);
        }
        logger.trace("Authenticated client for CF input format created successfully");
        return client;
    }

    public RecordReader<ByteBuffer, SortedMap<ByteBuffer, ColumnFamilyRecordReader.Column>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new ColumnFamilyRecordReader();
    }

    public org.apache.hadoop.mapred.RecordReader<ByteBuffer, SortedMap<ByteBuffer, ColumnFamilyRecordReader.Column>> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf jobConf, Reporter reporter) throws IOException {
        MapContext tac = HadoopCompat.newMapContext((Configuration)jobConf, TaskAttemptID.forName((String)jobConf.get("mapred.task.id")), null, null, null, new ReporterWrapper(reporter), null);
        ColumnFamilyRecordReader recordReader = new ColumnFamilyRecordReader(jobConf.getInt("cassandra.hadoop.max_key_size", 8192));
        recordReader.initialize((InputSplit)split, (TaskAttemptContext)tac);
        return recordReader;
    }

    @Override
    protected void validateConfiguration(Configuration conf) {
        super.validateConfiguration(conf);
        if (ConfigHelper.getInputSlicePredicate(conf) == null) {
            throw new UnsupportedOperationException("you must set the predicate with setInputSlicePredicate");
        }
    }
}

