/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.composites.CompositesBuilder;
import org.apache.cassandra.exceptions.InvalidRequestException;

abstract class AbstractRestriction
implements Restriction {
    AbstractRestriction() {
    }

    @Override
    public boolean isOnToken() {
        return false;
    }

    @Override
    public boolean isMultiColumn() {
        return false;
    }

    @Override
    public boolean isSlice() {
        return false;
    }

    @Override
    public boolean isEQ() {
        return false;
    }

    @Override
    public boolean isIN() {
        return false;
    }

    @Override
    public boolean isContains() {
        return false;
    }

    @Override
    public boolean hasBound(Bound b) {
        return true;
    }

    @Override
    public CompositesBuilder appendBoundTo(CompositesBuilder builder, Bound bound, QueryOptions options) {
        return this.appendTo(builder, options);
    }

    @Override
    public boolean isInclusive(Bound b) {
        return true;
    }

    protected static ByteBuffer validateIndexedValue(ColumnSpecification columnSpec, ByteBuffer value) throws InvalidRequestException {
        RequestValidations.checkNotNull(value, "Unsupported null value for indexed column %s", columnSpec.name);
        RequestValidations.checkBindValueSet(value, "Unsupported unset value for indexed column %s", columnSpec.name);
        RequestValidations.checkFalse(value.remaining() > 65535, "Index expression values may not be larger than 64K");
        return value;
    }
}

