/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.Environment;
import org.jamwiki.WikiBase;
import org.jamwiki.model.Namespace;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.utils.ImageUtil;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;

public class ParserFunctionUtil {
    private static final WikiLogger logger = WikiLogger.getLogger(ParserFunctionUtil.class.getName());
    private static final String PARSER_FUNCTION_ANCHOR_ENCODE = "anchorencode:";
    private static final String PARSER_FUNCTION_FILE_PATH = "filepath:";
    private static final String PARSER_FUNCTION_FULL_URL = "fullurl:";
    private static final String PARSER_FUNCTION_EXPR = "#expr:";
    private static final String PARSER_FUNCTION_IF = "#if:";
    private static final String PARSER_FUNCTION_IF_EQUAL = "#ifeq:";
    private static final String PARSER_FUNCTION_IF_EXIST = "#ifexist:";
    private static final String PARSER_FUNCTION_LOCAL_URL = "localurl:";
    private static final String PARSER_FUNCTION_LOWER_CASE = "lc:";
    private static final String PARSER_FUNCTION_LOWER_CASE_FIRST = "lcfirst:";
    private static final String PARSER_FUNCTION_NAMESPACE = "ns:";
    private static final String PARSER_FUNCTION_NAMESPACE_ESCAPED = "nse:";
    private static final String PARSER_FUNCTION_SWITCH = "#switch:";
    private static final String PARSER_FUNCTION_UPPER_CASE = "uc:";
    private static final String PARSER_FUNCTION_UPPER_CASE_FIRST = "ucfirst:";
    private static final String PARSER_FUNCTION_URL_ENCODE = "urlencode:";
    private static final String MAGIC_DISPLAY_TITLE = "DISPLAYTITLE:";
    private static List<String> PARSER_FUNCTIONS = new ArrayList<String>();

    protected static String[] parseParserFunctionInfo(ParserInput parserInput, int mode, String name) throws ParserException {
        int pos = name.indexOf(58);
        if (pos == -1 || pos + 2 > name.length()) {
            return null;
        }
        String parserFunction = name.substring(0, pos + 1).trim();
        String parserFunctionArguments = name.substring(pos + 1).trim();
        if (!PARSER_FUNCTIONS.contains(parserFunction)) {
            return null;
        }
        return new String[]{parserFunction, parserFunctionArguments};
    }

    protected static String processParserFunction(ParserInput parserInput, ParserOutput parserOutput, int mode, String parserFunction, String parserFunctionArguments) throws DataAccessException, ParserException {
        String[] parserFunctionArgumentArray = ParserFunctionUtil.parseParserFunctionArgumentArray(parserInput, parserOutput, mode, parserFunctionArguments);
        if (parserFunction.equals(PARSER_FUNCTION_ANCHOR_ENCODE)) {
            return Utilities.encodeAndEscapeTopicName(parserFunctionArgumentArray[0]);
        }
        if (parserFunction.equals(PARSER_FUNCTION_FILE_PATH)) {
            return ParserFunctionUtil.parseFilePath(parserInput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_FULL_URL)) {
            return ParserFunctionUtil.parseFileUrl(parserInput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_EXPR)) {
            return ParserFunctionUtil.parseExpr(parserInput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_IF)) {
            return ParserFunctionUtil.parseIf(parserInput, parserOutput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_IF_EQUAL)) {
            return ParserFunctionUtil.parseIfEqual(parserInput, parserOutput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_IF_EXIST)) {
            return ParserFunctionUtil.parseIfExist(parserInput, parserOutput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_LOCAL_URL)) {
            return ParserFunctionUtil.parseLocalUrl(parserInput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_LOWER_CASE)) {
            return ParserFunctionUtil.parseLowerCase(parserInput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_LOWER_CASE_FIRST)) {
            return ParserFunctionUtil.parseLowerCaseFirst(parserInput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_NAMESPACE)) {
            return ParserFunctionUtil.parseNamespace(parserInput, parserFunctionArgumentArray, false);
        }
        if (parserFunction.equals(PARSER_FUNCTION_NAMESPACE_ESCAPED)) {
            return ParserFunctionUtil.parseNamespace(parserInput, parserFunctionArgumentArray, true);
        }
        if (parserFunction.equals(PARSER_FUNCTION_SWITCH)) {
            return ParserFunctionUtil.parseSwitch(parserInput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_UPPER_CASE)) {
            return ParserFunctionUtil.parseUpperCase(parserInput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_UPPER_CASE_FIRST)) {
            return ParserFunctionUtil.parseUpperCaseFirst(parserInput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(PARSER_FUNCTION_URL_ENCODE)) {
            return ParserFunctionUtil.parseUrlEncode(parserInput, parserFunctionArgumentArray);
        }
        if (parserFunction.equals(MAGIC_DISPLAY_TITLE)) {
            return ParserFunctionUtil.parseDisplayTitle(parserInput, parserOutput, parserFunctionArgumentArray);
        }
        return null;
    }

    private static String parseFilePath(ParserInput parserInput, String[] parserFunctionArgumentArray) throws DataAccessException {
        String filename = Namespace.namespace(6).getLabel(parserInput.getVirtualWiki()) + ":" + parserFunctionArgumentArray[0];
        String result = ImageUtil.buildImageFileUrl(parserInput.getVirtualWiki(), filename);
        if (result == null) {
            return "";
        }
        result = LinkUtil.normalize(Environment.getValue("file-server-url") + result);
        if (parserFunctionArgumentArray.length > 1 && parserFunctionArgumentArray[1].equalsIgnoreCase("nowiki")) {
            result = "<nowiki>" + result + "</nowiki>";
        }
        return result;
    }

    private static String parseFileUrl(ParserInput parserInput, String[] parserFunctionArgumentArray) throws DataAccessException {
        String result = LinkUtil.buildTopicUrl(parserInput.getContext(), parserInput.getVirtualWiki(), parserFunctionArgumentArray[0], false);
        result = LinkUtil.normalize(Environment.getValue("server-url") + result);
        if (parserFunctionArgumentArray.length > 1 && !StringUtils.isBlank((String)parserFunctionArgumentArray[1])) {
            result = result + "?" + parserFunctionArgumentArray[1];
        }
        return result;
    }

    private static String parseExpr(ParserInput parserInput, String[] parserFunctionArgumentArray) throws DataAccessException, ParserException {
        String expr = parserFunctionArgumentArray[0];
        return ParserFunctionUtil.evaluateExpression(expr);
    }

    private static String evaluateExpression(String expr) {
        char part;
        int i;
        if (StringUtils.isBlank((String)expr)) {
            return "";
        }
        StringBuilder expression = new StringBuilder(expr);
        ArrayList<BigDecimal> stack = new ArrayList<BigDecimal>();
        String next = "";
        for (i = 0; i < expression.length(); ++i) {
            part = expression.charAt(i);
            if (Character.isDigit(part) || part == '.') {
                next = next + part;
                continue;
            }
            if (part == ')') {
                return (i > 0 ? expression.substring(0, i) : "") + "<strong class=\"error\">" + part + "</strong>" + (i < expression.length() - 1 ? expression.substring(i + 1) : "");
            }
            if (part == '(') {
                int end = Utilities.findMatchingEndTag(expression, i, "(", ")");
                if (end == -1) {
                    return (i > 0 ? expression.substring(0, i) : "") + "<strong class=\"error\">" + part + "</strong>" + (i < expression.length() - 1 ? expression.substring(i + 1) : "");
                }
                String result = ParserFunctionUtil.evaluateExpression(expression.substring(i + 1, end - 1));
                expression = expression.replace(i, end, "");
                try {
                    stack.add(new BigDecimal(result));
                    continue;
                }
                catch (NumberFormatException e) {
                    return result;
                }
            }
            if (StringUtils.isBlank((String)next)) continue;
            stack.add(new BigDecimal(next));
            next = "";
        }
        if (!StringUtils.isBlank((String)next)) {
            stack.add(new BigDecimal(next));
        }
        for (i = 0; i < expression.length(); ++i) {
            part = expression.charAt(i);
            try {
                switch (part) {
                    case '+': {
                        BigDecimal a = (BigDecimal)stack.remove(0);
                        BigDecimal b = (BigDecimal)stack.remove(0);
                        stack.add(0, a.add(b));
                        break;
                    }
                    case '-': {
                        BigDecimal a = (BigDecimal)stack.remove(0);
                        BigDecimal b = (BigDecimal)stack.remove(0);
                        stack.add(0, a.subtract(b));
                        break;
                    }
                    case '*': {
                        BigDecimal a = (BigDecimal)stack.remove(0);
                        BigDecimal b = (BigDecimal)stack.remove(0);
                        stack.add(0, a.multiply(b));
                        break;
                    }
                    case '/': {
                        BigDecimal a = (BigDecimal)stack.remove(0);
                        BigDecimal b = (BigDecimal)stack.remove(0);
                        stack.add(0, a.divide(b));
                    }
                }
                continue;
            }
            catch (ArithmeticException e) {
                return "<strong class=\"error\">" + expr + "</strong>";
            }
            catch (IndexOutOfBoundsException e) {
                return "<strong class=\"error\">" + expr + "</strong>";
            }
        }
        double result = ((BigDecimal)stack.get(0)).doubleValue();
        return (double)Math.round(result) == result ? Long.toString(Math.round(result)) : Double.toString(result);
    }

    private static String parseIf(ParserInput parserInput, ParserOutput parserOutput, String[] parserFunctionArgumentArray) throws DataAccessException, ParserException {
        boolean condition;
        boolean bl = parserFunctionArgumentArray.length >= 1 ? !StringUtils.isBlank((String)parserFunctionArgumentArray[0]) : (condition = false);
        if (condition) {
            return parserFunctionArgumentArray.length >= 2 ? JFlexParserUtil.parseFragment(parserInput, parserOutput, parserFunctionArgumentArray[1], 5) : "";
        }
        return parserFunctionArgumentArray.length >= 3 ? JFlexParserUtil.parseFragment(parserInput, parserOutput, parserFunctionArgumentArray[2], 5) : "";
    }

    private static String parseIfEqual(ParserInput parserInput, ParserOutput parserOutput, String[] parserFunctionArgumentArray) throws DataAccessException, ParserException {
        String arg1 = parserFunctionArgumentArray.length >= 1 ? parserFunctionArgumentArray[0] : "";
        String arg2 = parserFunctionArgumentArray.length >= 2 ? parserFunctionArgumentArray[1] : "";
        String result1 = parserFunctionArgumentArray.length >= 3 ? parserFunctionArgumentArray[2] : "";
        String result2 = parserFunctionArgumentArray.length >= 4 ? parserFunctionArgumentArray[3] : "";
        boolean equals = StringUtils.equals((String)arg1, (String)arg2);
        if (!equals && NumberUtils.isNumber((String)arg1) && NumberUtils.isNumber((String)arg2)) {
            BigDecimal bigDecimal1 = new BigDecimal(arg1);
            BigDecimal bigDecimal2 = new BigDecimal(arg2);
            boolean bl = equals = bigDecimal1.compareTo(bigDecimal2) == 0;
        }
        if (equals) {
            return JFlexParserUtil.parseFragment(parserInput, parserOutput, result1, 5);
        }
        return JFlexParserUtil.parseFragment(parserInput, parserOutput, result2, 5);
    }

    private static String parseIfExist(ParserInput parserInput, ParserOutput parserOutput, String[] parserFunctionArgumentArray) throws DataAccessException, ParserException {
        if (parserFunctionArgumentArray.length < 1) {
            return "";
        }
        String topicName = Utilities.decodeAndEscapeTopicName(parserFunctionArgumentArray[0], true);
        if (WikiBase.getDataHandler().lookupTopic(parserInput.getVirtualWiki(), topicName, false, null) != null) {
            return parserFunctionArgumentArray.length >= 2 ? JFlexParserUtil.parseFragment(parserInput, parserOutput, parserFunctionArgumentArray[1], 5) : "";
        }
        return parserFunctionArgumentArray.length >= 3 ? JFlexParserUtil.parseFragment(parserInput, parserOutput, parserFunctionArgumentArray[2], 5) : "";
    }

    private static String parseLocalUrl(ParserInput parserInput, String[] parserFunctionArgumentArray) throws DataAccessException {
        String result = LinkUtil.buildTopicUrl(parserInput.getContext(), parserInput.getVirtualWiki(), parserFunctionArgumentArray[0], false);
        if (parserFunctionArgumentArray.length > 1 && !StringUtils.isBlank((String)parserFunctionArgumentArray[1])) {
            result = result + "?" + parserFunctionArgumentArray[1];
        }
        return result;
    }

    private static String parseLowerCase(ParserInput parserInput, String[] parserFunctionArgumentArray) {
        return StringUtils.lowerCase((String)parserFunctionArgumentArray[0]);
    }

    private static String parseLowerCaseFirst(ParserInput parserInput, String[] parserFunctionArgumentArray) {
        return StringUtils.uncapitalize((String)parserFunctionArgumentArray[0]);
    }

    private static String parseNamespace(ParserInput parserInput, String[] parserFunctionArgumentArray, boolean escape) throws DataAccessException {
        String result;
        int namespaceId = NumberUtils.toInt((String)parserFunctionArgumentArray[0], (int)-10);
        Namespace namespace = null;
        namespace = namespaceId != -10 ? WikiBase.getDataHandler().lookupNamespaceById(namespaceId) : WikiBase.getDataHandler().lookupNamespace(parserInput.getVirtualWiki(), Utilities.decodeAndEscapeTopicName(parserFunctionArgumentArray[0], true));
        String string = result = namespace == null ? "" : namespace.getLabel(parserInput.getVirtualWiki());
        if (StringUtils.isBlank((String)result)) {
            return "";
        }
        return escape ? Utilities.encodeAndEscapeTopicName(result) : result;
    }

    private static String parseSwitch(ParserInput parserInput, String[] parserFunctionArgumentArray) {
        String condition = parserFunctionArgumentArray.length >= 1 ? parserFunctionArgumentArray[0].trim() : "#default";
        String defaultCondition = null;
        int pos = 0;
        for (int i = 1; i < parserFunctionArgumentArray.length; ++i) {
            String caseResult;
            pos = parserFunctionArgumentArray[i].indexOf(61);
            if (pos == -1 && i == parserFunctionArgumentArray.length - 1) {
                defaultCondition = parserFunctionArgumentArray[i].trim();
                continue;
            }
            if (pos == -1 || pos == 0) continue;
            String caseCondition = parserFunctionArgumentArray[i].substring(0, pos).trim();
            String string = caseResult = pos < parserFunctionArgumentArray[i].length() - 1 ? parserFunctionArgumentArray[i].substring(pos + 1).trim() : "";
            if (StringUtils.equals((String)condition, (String)caseCondition)) {
                return caseResult;
            }
            if (!StringUtils.equals((String)caseCondition, (String)"#default")) continue;
            defaultCondition = caseResult;
        }
        return defaultCondition != null ? defaultCondition : "";
    }

    private static String parseUpperCase(ParserInput parserInput, String[] parserFunctionArgumentArray) {
        return StringUtils.upperCase((String)parserFunctionArgumentArray[0]);
    }

    private static String parseUpperCaseFirst(ParserInput parserInput, String[] parserFunctionArgumentArray) {
        return StringUtils.capitalize((String)parserFunctionArgumentArray[0]);
    }

    private static String parseUrlEncode(ParserInput parserInput, String[] parserFunctionArgumentArray) {
        try {
            return URLEncoder.encode(parserFunctionArgumentArray[0], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupporting encoding UTF-8");
        }
    }

    private static String parseDisplayTitle(ParserInput parserInput, ParserOutput parserOutput, String[] parserFunctionArgumentArray) {
        String pageTitle = parserFunctionArgumentArray[0];
        if (pageTitle != null && StringUtils.equals((String)Utilities.decodeAndEscapeTopicName(pageTitle, true), (String)parserInput.getTopicName())) {
            parserOutput.setPageTitle(parserFunctionArgumentArray[0]);
        }
        return "";
    }

    private static String[] parseParserFunctionArgumentArray(ParserInput parserInput, ParserOutput parserOutput, int mode, String parserFunctionArguments) throws ParserException {
        if (StringUtils.isBlank((String)parserFunctionArguments)) {
            return new String[0];
        }
        List<String> parserFunctionArgumentList = JFlexParserUtil.tokenizeParamString(parserFunctionArguments);
        String[] parserFunctionArgumentArray = new String[parserFunctionArgumentList.size()];
        int i = 0;
        for (String argument : parserFunctionArgumentList) {
            parserFunctionArgumentArray[i++] = JFlexParserUtil.parseFragment(parserInput, parserOutput, argument.trim(), mode);
        }
        return parserFunctionArgumentArray;
    }

    static {
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_ANCHOR_ENCODE);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_FILE_PATH);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_FULL_URL);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_EXPR);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_IF);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_IF_EQUAL);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_IF_EXIST);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_LOCAL_URL);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_LOWER_CASE);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_LOWER_CASE_FIRST);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_NAMESPACE);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_NAMESPACE_ESCAPED);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_SWITCH);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_UPPER_CASE);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_UPPER_CASE_FIRST);
        PARSER_FUNCTIONS.add(PARSER_FUNCTION_URL_ENCODE);
        PARSER_FUNCTIONS.add(MAGIC_DISPLAY_TITLE);
    }
}

