/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCCallableStatement
extends JDBCPreparedStatement
implements CallableStatement {
    private IntValueHashMap parameterNameMap = new IntValueHashMap();
    private boolean wasNullValue;

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        if (this.parameterModes[--parameterIndex] == 1) {
            throw Util.invalidArgument();
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.wasNullValue;
    }

    @Override
    public synchronized String getString(int parameterIndex) throws SQLException {
        return (String)this.getColumnInType(parameterIndex, Type.SQL_VARCHAR);
    }

    @Override
    public synchronized boolean getBoolean(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_BOOLEAN);
        return o == null ? false : (Boolean)o;
    }

    @Override
    public synchronized byte getByte(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.TINYINT);
        return o == null ? (byte)0 : ((Number)o).byteValue();
    }

    @Override
    public synchronized short getShort(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_SMALLINT);
        return o == null ? (short)0 : ((Number)o).shortValue();
    }

    @Override
    public synchronized int getInt(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_INTEGER);
        return o == null ? 0 : ((Number)o).intValue();
    }

    @Override
    public synchronized long getLong(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_BIGINT);
        return o == null ? 0L : ((Number)o).longValue();
    }

    @Override
    public synchronized float getFloat(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_DOUBLE);
        return o == null ? 0.0f : ((Number)o).floatValue();
    }

    @Override
    public synchronized double getDouble(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_DOUBLE);
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (scale < 0) {
            throw Util.outOfRangeArgument();
        }
        BigDecimal bd = this.getBigDecimal(parameterIndex);
        if (bd != null) {
            bd = bd.setScale(scale, 1);
        }
        return bd;
    }

    @Override
    public synchronized byte[] getBytes(int parameterIndex) throws SQLException {
        Object x = this.getColumnInType(parameterIndex, Type.SQL_VARBINARY);
        if (x == null) {
            return null;
        }
        return ((BinaryData)x).getBytes();
    }

    @Override
    public synchronized Date getDate(int parameterIndex) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(parameterIndex, Type.SQL_DATE);
        if (t == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, t);
    }

    @Override
    public synchronized Time getTime(int parameterIndex) throws SQLException {
        TimeData t = (TimeData)this.getColumnInType(parameterIndex, Type.SQL_TIME);
        if (t == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, t);
    }

    @Override
    public synchronized Timestamp getTimestamp(int parameterIndex) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(parameterIndex, Type.SQL_TIMESTAMP);
        if (t == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, t);
    }

    @Override
    public synchronized Object getObject(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        Type sourceType = this.parameterTypes[parameterIndex - 1];
        switch (sourceType.typeCode) {
            case 50: {
                return this.getArray(parameterIndex);
            }
            case 91: {
                return this.getDate(parameterIndex);
            }
            case 92: 
            case 94: {
                return this.getTime(parameterIndex);
            }
            case 93: 
            case 95: {
                return this.getTimestamp(parameterIndex);
            }
            case 60: 
            case 61: {
                return this.getBytes(parameterIndex);
            }
            case 14: {
                boolean b = this.getBoolean(parameterIndex);
                return this.wasNull() ? null : (b ? Boolean.TRUE : Boolean.FALSE);
            }
            case 1111: 
            case 2000: {
                Object o = this.getColumnInType(parameterIndex, sourceType);
                if (o == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)o).getObject();
                }
                catch (HsqlException e) {
                    throw Util.sqlException(e);
                }
            }
        }
        return this.getColumnInType(parameterIndex, sourceType);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        Type targetType = this.parameterMetaData.columnTypes[parameterIndex - 1];
        switch (targetType.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                targetType = Type.SQL_DECIMAL;
                break;
            }
            default: {
                targetType = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(parameterIndex, targetType);
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw Util.notSupported();
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw Util.notSupported();
    }

    @Override
    public synchronized Blob getBlob(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        Type sourceType = this.parameterMetaData.columnTypes[parameterIndex - 1];
        Object o = this.getColumnInType(parameterIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof BlobDataID) {
            return new JDBCBlobClient(this.session, (BlobDataID)o);
        }
        throw Util.sqlException(5561);
    }

    @Override
    public synchronized Clob getClob(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        Type sourceType = this.parameterMetaData.columnTypes[parameterIndex - 1];
        Object o = this.getColumnInType(parameterIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof ClobDataID) {
            return new JDBCClobClient(this.session, (ClobDataID)o);
        }
        throw Util.sqlException(5561);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        Type type = this.parameterMetaData.columnTypes[parameterIndex - 1];
        if (!type.isArrayType()) {
            throw Util.sqlException(5561);
        }
        Object[] data = (Object[])this.parameterValues[parameterIndex - 1];
        if (data == null) {
            return null;
        }
        return new JDBCArray(data, type.collectionBaseType(), type, this.connection);
    }

    @Override
    public synchronized Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(parameterIndex, Type.SQL_DATE);
        if (t == null) {
            return null;
        }
        long millis = t.getSeconds() * 1000L;
        if (cal != null) {
            millis = HsqlDateTime.convertMillisToCalendar(cal, millis);
        }
        return new Date(millis);
    }

    @Override
    public synchronized Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        TimeData t = (TimeData)this.getColumnInType(parameterIndex, Type.SQL_TIME);
        if (t == null) {
            return null;
        }
        long millis = DateTimeType.normaliseTime(t.getSeconds()) * 1000;
        if (!this.parameterMetaData.columnTypes[--parameterIndex].isDateTimeTypeWithZone()) {
            Calendar calendar = cal == null ? this.session.getCalendar() : cal;
            millis = HsqlDateTime.convertMillisToCalendar(calendar, millis);
            millis = HsqlDateTime.getNormalisedTime(millis);
        }
        return new Time(millis);
    }

    @Override
    public synchronized Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(parameterIndex, Type.SQL_TIMESTAMP);
        if (t == null) {
            return null;
        }
        long millis = t.getSeconds() * 1000L;
        if (!this.parameterMetaData.columnTypes[--parameterIndex].isDateTimeTypeWithZone()) {
            Calendar calendar;
            Calendar calendar2 = calendar = cal == null ? this.session.getCalendar() : cal;
            if (cal != null) {
                millis = HsqlDateTime.convertMillisToCalendar(calendar, millis);
            }
        }
        Timestamp ts = new Timestamp(millis);
        ts.setNanos(t.getNanos());
        return ts;
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw Util.notSupported();
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.setURL(this.findParameterIndex(parameterName), val);
    }

    @Override
    public synchronized void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public synchronized void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.findParameterIndex(parameterName), x, length);
    }

    @Override
    public synchronized void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.findParameterIndex(parameterName), x, length);
    }

    @Override
    public synchronized void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.findParameterIndex(parameterName), x, targetSqlType, scale);
    }

    @Override
    public synchronized void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.findParameterIndex(parameterName), x, targetSqlType);
    }

    @Override
    public synchronized void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.findParameterIndex(parameterName), reader, length);
    }

    @Override
    public synchronized void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParameterIndex(parameterName), x, cal);
    }

    @Override
    public synchronized void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParameterIndex(parameterName), x, cal);
    }

    @Override
    public synchronized void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParameterIndex(parameterName), x, cal);
    }

    @Override
    public synchronized void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.findParameterIndex(parameterName), sqlType, typeName);
    }

    @Override
    public synchronized String getString(String parameterName) throws SQLException {
        return this.getString(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized short getShort(String parameterName) throws SQLException {
        return this.getShort(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized int getInt(String parameterName) throws SQLException {
        return this.getInt(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized long getLong(String parameterName) throws SQLException {
        return this.getLong(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.findParameterIndex(parameterName));
    }

    public synchronized Object getObject(String parameterName, Map map) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName), map);
    }

    @Override
    public synchronized Ref getRef(String parameterName) throws SQLException {
        return this.getRef(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Clob getClob(String parameterName) throws SQLException {
        return this.getClob(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(this.findParameterIndex(parameterName), cal);
    }

    @Override
    public synchronized Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(this.findParameterIndex(parameterName), cal);
    }

    @Override
    public synchronized Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(parameterName), cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getURL(this.findParameterIndex(parameterName));
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return (T)this.getObject(parameterIndex);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName), type);
    }

    public JDBCCallableStatement(JDBCConnection c, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws HsqlException, SQLException {
        super(c, sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
        if (this.parameterMetaData != null) {
            String[] names = this.parameterMetaData.columnLabels;
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (name == null || name.length() == 0) continue;
                this.parameterNameMap.put(name, i);
            }
        }
    }

    @Override
    void fetchResult() throws SQLException {
        super.fetchResult();
        if (this.resultIn.getType() == 43) {
            Object[] data = this.resultIn.getParameterData();
            for (int i = 0; i < this.parameterValues.length; ++i) {
                this.parameterValues[i] = data[i];
            }
        }
    }

    int findParameterIndex(String parameterName) throws SQLException {
        int index;
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if ((index = this.parameterNameMap.get((Object)parameterName, -1)) >= 0) {
            return index + 1;
        }
        throw Util.sqlException(421, parameterName);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.parameterNameMap = null;
        super.close();
    }

    private Object getColumnInType(int columnIndex, Type targetType) throws SQLException {
        this.checkGetParameterIndex(columnIndex);
        Type sourceType = this.parameterTypes[--columnIndex];
        Object value = this.parameterValues[columnIndex];
        if (this.trackNull(value)) {
            return null;
        }
        if (sourceType.typeCode != targetType.typeCode) {
            try {
                value = targetType.convertToTypeJDBC(this.session, value, sourceType);
            }
            catch (HsqlException e) {
                String stringValue = value instanceof Number || value instanceof String || value instanceof java.util.Date ? value.toString() : "instance of " + value.getClass().getName();
                String msg = "from SQL type " + sourceType.getNameString() + " to " + targetType.getJDBCClassName() + ", value: " + stringValue;
                HsqlException err = Error.error(5561, msg);
                throw Util.sqlException(err, e);
            }
        }
        return value;
    }

    private boolean trackNull(Object o) {
        this.wasNullValue = o == null;
        return this.wasNullValue;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

