/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.analysis.section;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.index.Payload;

public final class IntMetaDataTokenStream
extends TokenStream {
    private final String _tokenText;
    private final TermAttribute _termAttribute;
    private final OffsetAttribute _offsetAttribute;
    private final PayloadAttribute _payloadAtt;
    private Payload _payload;
    private boolean _returnToken = false;

    public IntMetaDataTokenStream(String tokenText) {
        this._tokenText = tokenText;
        this._termAttribute = (TermAttribute)this.addAttribute(TermAttribute.class);
        this._offsetAttribute = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this._payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    }

    public void setMetaData(int[] data) {
        byte[] buf = new byte[data.length * 4];
        int i = 0;
        for (int j = 0; j < data.length; ++j) {
            int datum = data[j];
            buf[i++] = (byte)datum;
            buf[i++] = (byte)(datum >>> 8);
            buf[i++] = (byte)(datum >>> 16);
            buf[i++] = (byte)(datum >>> 24);
        }
        this._payload = new Payload(buf);
        this._returnToken = true;
    }

    public boolean incrementToken() throws IOException {
        if (this._returnToken) {
            this._termAttribute.setTermBuffer(this._tokenText);
            this._offsetAttribute.setOffset(0, 0);
            this._payloadAtt.setPayload(this._payload);
            this._returnToken = false;
            return true;
        }
        return false;
    }
}

